/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.vector;

import cdjd.org.apache.arrow.vector.BigIntVector;
import cdjd.org.apache.arrow.vector.BitVector;
import cdjd.org.apache.arrow.vector.DateDayVector;
import cdjd.org.apache.arrow.vector.DateMilliVector;
import cdjd.org.apache.arrow.vector.DecimalVector;
import cdjd.org.apache.arrow.vector.Float4Vector;
import cdjd.org.apache.arrow.vector.Float8Vector;
import cdjd.org.apache.arrow.vector.IntVector;
import cdjd.org.apache.arrow.vector.IntervalDayVector;
import cdjd.org.apache.arrow.vector.IntervalYearVector;
import cdjd.org.apache.arrow.vector.SmallIntVector;
import cdjd.org.apache.arrow.vector.TimeMicroVector;
import cdjd.org.apache.arrow.vector.TimeMilliVector;
import cdjd.org.apache.arrow.vector.TimeNanoVector;
import cdjd.org.apache.arrow.vector.TimeSecVector;
import cdjd.org.apache.arrow.vector.TimeStampMicroTZVector;
import cdjd.org.apache.arrow.vector.TimeStampMicroVector;
import cdjd.org.apache.arrow.vector.TimeStampMilliTZVector;
import cdjd.org.apache.arrow.vector.TimeStampMilliVector;
import cdjd.org.apache.arrow.vector.TimeStampNanoTZVector;
import cdjd.org.apache.arrow.vector.TimeStampNanoVector;
import cdjd.org.apache.arrow.vector.TimeStampSecTZVector;
import cdjd.org.apache.arrow.vector.TimeStampSecVector;
import cdjd.org.apache.arrow.vector.TimeStampVector;
import cdjd.org.apache.arrow.vector.TinyIntVector;
import cdjd.org.apache.arrow.vector.ValueVector;
import cdjd.org.apache.arrow.vector.VarBinaryVector;
import cdjd.org.apache.arrow.vector.VarCharVector;
import java.math.BigDecimal;
import java.nio.charset.Charset;

public class GenerateSampleData {
    private GenerateSampleData() {
    }

    public static void generateTestData(ValueVector vector, int valueCount) {
        if (vector instanceof IntVector) {
            GenerateSampleData.writeIntData((IntVector)vector, valueCount);
        } else if (vector instanceof DecimalVector) {
            GenerateSampleData.writeDecimalData((DecimalVector)vector, valueCount);
        } else if (vector instanceof BitVector) {
            GenerateSampleData.writeBooleanData((BitVector)vector, valueCount);
        } else if (vector instanceof VarCharVector) {
            GenerateSampleData.writeVarCharData((VarCharVector)vector, valueCount);
        } else if (vector instanceof VarBinaryVector) {
            GenerateSampleData.writeVarBinaryData((VarBinaryVector)vector, valueCount);
        } else if (vector instanceof BigIntVector) {
            GenerateSampleData.writeBigIntData((BigIntVector)vector, valueCount);
        } else if (vector instanceof Float4Vector) {
            GenerateSampleData.writeFloatData((Float4Vector)vector, valueCount);
        } else if (vector instanceof Float8Vector) {
            GenerateSampleData.writeDoubleData((Float8Vector)vector, valueCount);
        } else if (vector instanceof DateDayVector) {
            GenerateSampleData.writeDateDayData((DateDayVector)vector, valueCount);
        } else if (vector instanceof DateMilliVector) {
            GenerateSampleData.writeDateMilliData((DateMilliVector)vector, valueCount);
        } else if (vector instanceof IntervalDayVector) {
            GenerateSampleData.writeIntervalDayData((IntervalDayVector)vector, valueCount);
        } else if (vector instanceof IntervalYearVector) {
            GenerateSampleData.writeIntervalYearData((IntervalYearVector)vector, valueCount);
        } else if (vector instanceof SmallIntVector) {
            GenerateSampleData.writeSmallIntData((SmallIntVector)vector, valueCount);
        } else if (vector instanceof TinyIntVector) {
            GenerateSampleData.writeTinyIntData((TinyIntVector)vector, valueCount);
        } else if (vector instanceof TimeMicroVector) {
            GenerateSampleData.writeTimeMicroData((TimeMicroVector)vector, valueCount);
        } else if (vector instanceof TimeMilliVector) {
            GenerateSampleData.writeTimeMilliData((TimeMilliVector)vector, valueCount);
        } else if (vector instanceof TimeNanoVector) {
            GenerateSampleData.writeTimeNanoData((TimeNanoVector)vector, valueCount);
        } else if (vector instanceof TimeSecVector) {
            GenerateSampleData.writeTimeSecData((TimeSecVector)vector, valueCount);
        } else if (vector instanceof TimeStampSecVector) {
            GenerateSampleData.writeTimeStampData((TimeStampSecVector)vector, valueCount);
        } else if (vector instanceof TimeStampMicroVector) {
            GenerateSampleData.writeTimeStampData((TimeStampMicroVector)vector, valueCount);
        } else if (vector instanceof TimeStampMilliVector) {
            GenerateSampleData.writeTimeStampData((TimeStampMilliVector)vector, valueCount);
        } else if (vector instanceof TimeStampNanoVector) {
            GenerateSampleData.writeTimeStampData((TimeStampNanoVector)vector, valueCount);
        } else if (vector instanceof TimeStampSecTZVector) {
            GenerateSampleData.writeTimeStampData((TimeStampSecTZVector)vector, valueCount);
        } else if (vector instanceof TimeStampMicroTZVector) {
            GenerateSampleData.writeTimeStampData((TimeStampMicroTZVector)vector, valueCount);
        } else if (vector instanceof TimeStampMilliTZVector) {
            GenerateSampleData.writeTimeStampData((TimeStampMilliTZVector)vector, valueCount);
        } else if (vector instanceof TimeStampNanoTZVector) {
            GenerateSampleData.writeTimeStampData((TimeStampNanoTZVector)vector, valueCount);
        }
    }

    private static void writeTimeStampData(TimeStampVector vector, int valueCount) {
        long even = 100000L;
        long odd = 200000L;
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, 100000L);
                continue;
            }
            vector.setSafe(i, 200000L);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeDecimalData(DecimalVector vector, int valueCount) {
        BigDecimal even = new BigDecimal(0.0543278923);
        BigDecimal odd = new BigDecimal(2.0543278923);
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, even);
                continue;
            }
            vector.setSafe(i, odd);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeIntData(IntVector vector, int valueCount) {
        int even = 1000;
        int odd = 2000;
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, 1000);
                continue;
            }
            vector.setSafe(i, 2000);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeBooleanData(BitVector vector, int valueCount) {
        boolean even = false;
        boolean odd = true;
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, 0);
                continue;
            }
            vector.setSafe(i, 1);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeIntervalYearData(IntervalYearVector vector, int valueCount) {
        boolean even = true;
        int odd = 2;
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, 1);
                continue;
            }
            vector.setSafe(i, 2);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeIntervalDayData(IntervalDayVector vector, int valueCount) {
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, 1, 50);
                continue;
            }
            vector.setSafe(i, 2, 100);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeTimeSecData(TimeSecVector vector, int valueCount) {
        int even = 500;
        int odd = 900;
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, 500);
                continue;
            }
            vector.setSafe(i, 900);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeTimeMilliData(TimeMilliVector vector, int valueCount) {
        int even = 1000;
        int odd = 2000;
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, 1000);
                continue;
            }
            vector.setSafe(i, 2000);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeTimeMicroData(TimeMicroVector vector, int valueCount) {
        long even = 1000000000L;
        long odd = 2000000000L;
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, 1000000000L);
                continue;
            }
            vector.setSafe(i, 2000000000L);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeTimeNanoData(TimeNanoVector vector, int valueCount) {
        long even = 1000000000L;
        long odd = 2000000000L;
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, 1000000000L);
                continue;
            }
            vector.setSafe(i, 2000000000L);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeDateDayData(DateDayVector vector, int valueCount) {
        int even = 1000;
        int odd = 2000;
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, 1000);
                continue;
            }
            vector.setSafe(i, 2000);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeDateMilliData(DateMilliVector vector, int valueCount) {
        long even = 1000000000L;
        long odd = 2000000000L;
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, 1000000000L);
                continue;
            }
            vector.setSafe(i, 2000000000L);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeSmallIntData(SmallIntVector vector, int valueCount) {
        int even = 10;
        int odd = 20;
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, (short)10);
                continue;
            }
            vector.setSafe(i, (short)20);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeTinyIntData(TinyIntVector vector, int valueCount) {
        boolean even = true;
        int odd = 2;
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, (byte)1);
                continue;
            }
            vector.setSafe(i, (byte)2);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeBigIntData(BigIntVector vector, int valueCount) {
        long even = 1000000000L;
        long odd = 2000000000L;
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, 1000000000L);
                continue;
            }
            vector.setSafe(i, 2000000000L);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeFloatData(Float4Vector vector, int valueCount) {
        float even = 20.3f;
        float odd = 40.2f;
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, 20.3f);
                continue;
            }
            vector.setSafe(i, 40.2f);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeDoubleData(Float8Vector vector, int valueCount) {
        double even = 20.2373;
        double odd = 40.2378;
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, 20.2373);
                continue;
            }
            vector.setSafe(i, 40.2378);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeVarBinaryData(VarBinaryVector vector, int valueCount) {
        Charset utf8Charset = Charset.forName("UTF-8");
        byte[] even = "AAAAA1".getBytes(utf8Charset);
        byte[] odd = "BBBBBBBBB2".getBytes(utf8Charset);
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, even);
                continue;
            }
            vector.setSafe(i, odd);
        }
        vector.setValueCount(valueCount);
    }

    private static void writeVarCharData(VarCharVector vector, int valueCount) {
        Charset utf8Charset = Charset.forName("UTF-8");
        byte[] even = "AAAAA1".getBytes(utf8Charset);
        byte[] odd = "BBBBBBBBB2".getBytes(utf8Charset);
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, even);
                continue;
            }
            vector.setSafe(i, odd);
        }
        vector.setValueCount(valueCount);
    }
}

