/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.memory;

import cdjd.com.dremio.common.VM;
import cdjd.com.dremio.common.config.SabotConfig;
import cdjd.com.dremio.common.memory.DremioRootAllocator;
import cdjd.com.dremio.config.DremioConfig;
import cdjd.com.google.common.annotations.VisibleForTesting;
import cdjd.io.netty.buffer.PooledByteBufAllocator;
import cdjd.org.apache.arrow.memory.BufferAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootAllocatorFactory {
    private static final String IO_NETTY_ALLOCATOR_USE_CACHE_FOR_ALL_THREADS_PROPERTY = "cdjd.io.netty.allocator.useCacheForAllThreads";
    private static final Logger LOGGER = LoggerFactory.getLogger(RootAllocatorFactory.class);
    public static final String TOP_LEVEL_MAX_ALLOC = "dremio.memory.top.max";

    private RootAllocatorFactory() {
    }

    @VisibleForTesting
    public static synchronized BufferAllocator newRoot(SabotConfig config) {
        return RootAllocatorFactory.newRoot(config.getLong(TOP_LEVEL_MAX_ALLOC), 0L, 100);
    }

    public static synchronized BufferAllocator newRoot(DremioConfig config) {
        return RootAllocatorFactory.newRoot(config.getSabotConfig().getLong(TOP_LEVEL_MAX_ALLOC), config.getLong("debug.alloc.est_heap_buf_size_bytes"), config.getInt("debug.alloc.max_occupancy_percent"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized DremioRootAllocator newRoot(long maxAllocBytes, long estBytesPerBuf, int maxOccupancyPercent) {
        String previousProperty = System.getProperty(IO_NETTY_ALLOCATOR_USE_CACHE_FOR_ALL_THREADS_PROPERTY);
        try {
            System.setProperty(IO_NETTY_ALLOCATOR_USE_CACHE_FOR_ALL_THREADS_PROPERTY, "false");
            long maxBuffers = estBytesPerBuf > 0L ? (long)((double)(VM.getMaxHeapMemory() * (long)maxOccupancyPercent) * 0.01 / (double)estBytesPerBuf) : Long.MAX_VALUE;
            DremioRootAllocator dremioRootAllocator = DremioRootAllocator.create(Math.min(VM.getMaxDirectMemory(), maxAllocBytes), maxBuffers);
            return dremioRootAllocator;
        }
        finally {
            if (previousProperty == null) {
                System.getProperties().remove(IO_NETTY_ALLOCATOR_USE_CACHE_FOR_ALL_THREADS_PROPERTY);
            } else {
                System.setProperty(IO_NETTY_ALLOCATOR_USE_CACHE_FOR_ALL_THREADS_PROPERTY, previousProperty);
            }
            RootAllocatorFactory.checkPoolConfiguration();
        }
    }

    private static void checkPoolConfiguration() {
        boolean value = PooledByteBufAllocator.defaultUseCacheForAllThreads();
        if (value) {
            LOGGER.error("!!! Root allocator configured to use cache for all threads !!! Expect memory issues");
        }
    }
}

