/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.memory;

import cdjd.org.apache.arrow.memory.ValueWithKeyIncluded;
import cdjd.org.apache.arrow.util.Preconditions;
import cdjd.org.apache.arrow.util.VisibleForTesting;

public class LowCostIdentityHashMap<K, V extends ValueWithKeyIncluded<K>> {
    private Object[] elementData;
    private int size;
    private int threshold;
    private static final int DEFAULT_MIN_SIZE = 1;
    private static final int LOAD_FACTOR = 7500;

    public LowCostIdentityHashMap() {
        this(1);
    }

    public LowCostIdentityHashMap(int maxSize) {
        if (maxSize < 0) {
            throw new IllegalArgumentException();
        }
        this.size = 0;
        this.threshold = this.getThreshold(maxSize);
        this.elementData = this.newElementArray(this.computeElementArraySize());
    }

    private int getThreshold(int maxSize) {
        return maxSize > 2 ? maxSize : 2;
    }

    private int computeElementArraySize() {
        int arraySize = (int)((long)this.threshold * 10000L / 7500L);
        return arraySize < 0 ? -arraySize : arraySize;
    }

    private Object[] newElementArray(int s2) {
        return new Object[s2];
    }

    public void clear() {
        this.size = 0;
        for (int i = 0; i < this.elementData.length; ++i) {
            this.elementData[i] = null;
        }
    }

    public boolean containsKey(K key) {
        Preconditions.checkNotNull(key);
        int index = this.findIndex(key, this.elementData);
        return this.elementData[index] == null ? false : ((ValueWithKeyIncluded)this.elementData[index]).getKey() == key;
    }

    public boolean containsValue(V value) {
        Preconditions.checkNotNull(value);
        for (int i = 0; i < this.elementData.length; ++i) {
            if (this.elementData[i] != value) continue;
            return true;
        }
        return false;
    }

    public V get(K key) {
        Preconditions.checkNotNull(key);
        int index = this.findIndex(key, this.elementData);
        return (V)(this.elementData[index] == null ? null : (((ValueWithKeyIncluded)this.elementData[index]).getKey() == key ? (ValueWithKeyIncluded)this.elementData[index] : null));
    }

    @VisibleForTesting
    int findIndex(Object key, Object[] array) {
        int length = array.length;
        int index = LowCostIdentityHashMap.getModuloHash(key, length);
        int last = (index + length - 1) % length;
        while (index != last && array[index] != null && ((ValueWithKeyIncluded)array[index]).getKey() != key) {
            index = (index + 1) % length;
        }
        return index;
    }

    @VisibleForTesting
    static int getModuloHash(Object key, int length) {
        return (System.identityHashCode(key) & Integer.MAX_VALUE) % length;
    }

    public V put(V value) {
        Preconditions.checkNotNull(value);
        Object key = value.getKey();
        Preconditions.checkNotNull(key);
        int index = this.findIndex(key, this.elementData);
        if (this.elementData[index] == null || ((ValueWithKeyIncluded)this.elementData[index]).getKey() != key) {
            if (++this.size > this.threshold) {
                this.rehash();
                index = this.findIndex(key, this.elementData);
            }
            this.elementData[index] = null;
        }
        Object result = this.elementData[index];
        this.elementData[index] = value;
        return (V)((ValueWithKeyIncluded)result);
    }

    @VisibleForTesting
    void rehash() {
        int newlength = this.elementData.length * 15 / 10;
        if (newlength == 0) {
            newlength = 1;
        }
        Object[] newData = this.newElementArray(newlength);
        for (int i = 0; i < this.elementData.length; ++i) {
            Object key;
            Object v0 = key = this.elementData[i] == null ? null : ((ValueWithKeyIncluded)this.elementData[i]).getKey();
            if (key == null) continue;
            int index = this.findIndex(key, newData);
            newData[index] = this.elementData[i];
        }
        this.elementData = newData;
        this.computeMaxSize();
    }

    private void computeMaxSize() {
        this.threshold = (int)((long)this.elementData.length * 7500L / 10000L);
    }

    public V remove(K key) {
        Object object;
        int next;
        Preconditions.checkNotNull(key);
        int index = next = this.findIndex(key, this.elementData);
        if (this.elementData[index] == null || ((ValueWithKeyIncluded)this.elementData[index]).getKey() != key) {
            return null;
        }
        Object result = this.elementData[index];
        this.elementData[index] = null;
        --this.size;
        int length = this.elementData.length;
        while ((object = this.elementData[next = (next + 1) % length]) != null) {
            boolean hashedOk;
            int hash = LowCostIdentityHashMap.getModuloHash(((ValueWithKeyIncluded)object).getKey(), length);
            boolean bl = hashedOk = hash > index;
            if (next < index) {
                hashedOk = hashedOk || hash <= next;
            } else {
                boolean bl2 = hashedOk = hashedOk && hash <= next;
            }
            if (hashedOk) continue;
            this.elementData[index] = object;
            index = next;
            this.elementData[index] = null;
        }
        return (V)((ValueWithKeyIncluded)result);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public V getNextValue() {
        for (int i = 0; i < this.elementData.length; ++i) {
            if (this.elementData[i] == null) continue;
            return (V)((ValueWithKeyIncluded)this.elementData[i]);
        }
        return null;
    }
}

