/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.memory;

import cdjd.org.apache.arrow.memory.ArrowBuf;
import cdjd.org.apache.arrow.memory.BaseAllocator;
import cdjd.org.apache.arrow.memory.BufferAllocator;
import cdjd.org.apache.arrow.memory.BufferLedger;
import cdjd.org.apache.arrow.memory.LowCostIdentityHashMap;
import cdjd.org.apache.arrow.util.Preconditions;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AllocationManager {
    private static final AtomicLong MANAGER_ID_GENERATOR = new AtomicLong(0L);
    private final BufferAllocator root;
    private final long allocatorManagerId = MANAGER_ID_GENERATOR.incrementAndGet();
    private final LowCostIdentityHashMap<BufferAllocator, BufferLedger> map = new LowCostIdentityHashMap();
    private final long amCreationTime = System.nanoTime();
    private volatile BufferLedger owningLedger;
    private volatile long amDestructionTime = 0L;

    protected AllocationManager(BufferAllocator accountingAllocator) {
        Preconditions.checkNotNull(accountingAllocator);
        accountingAllocator.assertOpen();
        this.root = accountingAllocator.getRoot();
        this.owningLedger = this.associate(accountingAllocator, false);
    }

    BufferLedger getOwningLedger() {
        return this.owningLedger;
    }

    void setOwningLedger(BufferLedger ledger) {
        this.owningLedger = ledger;
    }

    BufferLedger associate(BufferAllocator allocator) {
        return this.associate(allocator, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferLedger associate(BufferAllocator allocator, boolean retain) {
        allocator.assertOpen();
        Preconditions.checkState(this.root == allocator.getRoot(), "A buffer can only be associated between two allocators that share the same root");
        AllocationManager allocationManager = this;
        synchronized (allocationManager) {
            BufferLedger oldLedger;
            BufferLedger ledger = this.map.get(allocator);
            if (ledger != null) {
                if (retain) {
                    ledger.increment();
                }
                return ledger;
            }
            ledger = new BufferLedger(allocator, this);
            if (retain) {
                ledger.increment();
            }
            Preconditions.checkState((oldLedger = this.map.put(ledger)) == null, "Detected inconsistent state: A reference manager already exists for this allocator");
            if (allocator instanceof BaseAllocator) {
                ((BaseAllocator)allocator).associateLedger(ledger);
            }
            return ledger;
        }
    }

    void release(BufferLedger ledger) {
        BufferAllocator allocator = ledger.getAllocator();
        allocator.assertOpen();
        Preconditions.checkState(this.map.containsKey(allocator), "Expecting a mapping for allocator and reference manager");
        BufferLedger oldLedger = this.map.remove(allocator);
        BufferAllocator oldAllocator = oldLedger.getAllocator();
        if (oldAllocator instanceof BaseAllocator) {
            ((BaseAllocator)oldAllocator).dissociateLedger(oldLedger);
        }
        if (oldLedger == this.owningLedger) {
            if (this.map.isEmpty()) {
                oldAllocator.releaseBytes(this.getSize());
                this.release0();
                oldAllocator.getListener().onRelease(this.getSize());
                this.amDestructionTime = System.nanoTime();
                this.owningLedger = null;
            } else {
                BufferLedger newOwningLedger = this.map.getNextValue();
                oldLedger.transferBalance(newOwningLedger);
            }
        } else {
            Preconditions.checkState(this.map.size() > 0, "The final removal of reference manager should be connected to owning reference manager");
        }
    }

    public abstract long getSize();

    protected abstract long memoryAddress();

    protected abstract void release0();

    public static interface Factory {
        public AllocationManager create(BufferAllocator var1, long var2);

        public ArrowBuf empty();
    }
}

