/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.github.rollingmetrics.util;

import cdjd.com.github.rollingmetrics.util.Clock;
import java.util.Objects;
import java.util.function.Supplier;

public class CachingSupplier<T>
implements Supplier<T> {
    private final Supplier<T> targetSupplier;
    private final long cachingDurationMillis;
    private final Clock clock;
    private T cachedValue;
    private long lastSnapshotTakeTimeMillis;

    public CachingSupplier(long cachingDurationMillis, Clock clock, Supplier<T> targetSupplier) {
        if (cachingDurationMillis >= 0x3FFFFFFFFFFFFFFFL) {
            throw new IllegalArgumentException("Too big cachingDurationMillis");
        }
        this.targetSupplier = targetSupplier;
        this.cachingDurationMillis = cachingDurationMillis;
        this.clock = Objects.requireNonNull(clock);
        this.lastSnapshotTakeTimeMillis = -cachingDurationMillis;
    }

    @Override
    public final synchronized T get() {
        long nowMillis = this.clock.currentTimeMillis();
        if (nowMillis - this.lastSnapshotTakeTimeMillis < this.cachingDurationMillis) {
            return this.cachedValue;
        }
        this.cachedValue = this.targetSupplier.get();
        this.lastSnapshotTakeTimeMillis = nowMillis;
        return this.cachedValue;
    }
}

