/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.github.rollingmetrics.top.impl.recorder;

import cdjd.com.github.rollingmetrics.top.Position;
import cdjd.com.github.rollingmetrics.top.impl.collector.PositionCollector;
import cdjd.com.github.rollingmetrics.top.impl.recorder.MultiPositionRecorder;
import cdjd.com.github.rollingmetrics.top.impl.recorder.SinglePositionRecorder;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public abstract class PositionRecorder {
    protected final int size;
    protected final long latencyThresholdNanos;
    protected final int maxDescriptionLength;

    protected PositionRecorder(int size, long latencyThresholdNanos, int maxDescriptionLength) {
        this.latencyThresholdNanos = latencyThresholdNanos;
        this.size = size;
        this.maxDescriptionLength = maxDescriptionLength;
    }

    public void update(long timestamp, long latencyTime, TimeUnit latencyUnit, Supplier<String> descriptionSupplier) {
        long latencyNanos = latencyUnit.toNanos(latencyTime);
        if (latencyNanos < this.latencyThresholdNanos) {
            return;
        }
        this.updateConcurrently(timestamp, latencyTime, latencyUnit, descriptionSupplier, latencyNanos);
    }

    public int getSize() {
        return this.size;
    }

    public static PositionRecorder createRecorder(int size, long latencyThresholdNanos, int maxDescriptionLength) {
        if (size == 1) {
            return new SinglePositionRecorder(latencyThresholdNanos, maxDescriptionLength);
        }
        return new MultiPositionRecorder(size, latencyThresholdNanos, maxDescriptionLength);
    }

    public PositionRecorder createEmptyCopy() {
        return PositionRecorder.createRecorder(this.size, this.latencyThresholdNanos, this.maxDescriptionLength);
    }

    protected boolean isNeedToAdd(long newTimestamp, long newLatency, Position currentMinimum) {
        if (currentMinimum == null) {
            return true;
        }
        if (newLatency > currentMinimum.getLatencyInNanoseconds()) {
            return true;
        }
        return newLatency == currentMinimum.getLatencyInNanoseconds() && newTimestamp > currentMinimum.getTimestamp();
    }

    protected abstract void updateConcurrently(long var1, long var3, TimeUnit var5, Supplier<String> var6, long var7);

    public abstract void reset();

    public abstract void addInto(PositionCollector var1);

    public abstract List<Position> getPositionsInDescendingOrder();
}

