/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.telemetry.api.config;

import cdjd.com.dremio.telemetry.api.config.MetricsConfigurator;
import cdjd.com.dremio.telemetry.api.config.RefreshConfiguration;
import cdjd.com.dremio.telemetry.api.config.TracerConfigurator;
import cdjd.com.fasterxml.jackson.annotation.JsonCreator;
import cdjd.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;

public class TelemetryConfigurator
implements AutoCloseable {
    private final List<MetricsConfigurator> metricsConfigs;
    private final RefreshConfiguration refreshConfig;
    private final TracerConfigurator traceConfig;

    @JsonCreator
    public TelemetryConfigurator(@JsonProperty(value="auto-reload") RefreshConfiguration refreshConfig, @JsonProperty(value="metrics") List<MetricsConfigurator> metricsConfigs, @JsonProperty(value="tracing") TracerConfigurator traceConfig) {
        this.refreshConfig = refreshConfig;
        this.metricsConfigs = metricsConfigs;
        this.traceConfig = traceConfig;
    }

    @Override
    public void close() {
        this.metricsConfigs.forEach(MetricsConfigurator::close);
    }

    public List<MetricsConfigurator> getMetricsConfigs() {
        return this.metricsConfigs == null ? null : Collections.unmodifiableList(this.metricsConfigs);
    }

    public RefreshConfiguration getRefreshConfig() {
        return this.refreshConfig;
    }

    public TracerConfigurator getTracerConfig() {
        return this.traceConfig;
    }
}

