/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.telemetry.api.config;

import cdjd.com.codahale.metrics.MetricFilter;
import cdjd.com.codahale.metrics.MetricRegistry;
import cdjd.com.dremio.telemetry.api.config.IncludesExcludesFilter;
import cdjd.com.dremio.telemetry.api.config.ReporterConfigurator;
import cdjd.com.fasterxml.jackson.annotation.JsonCreator;
import cdjd.com.fasterxml.jackson.annotation.JsonProperty;
import cdjd.com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class MetricsConfigurator
implements AutoCloseable {
    private final String name;
    private final String comment;
    private final ReporterConfigurator configurator;
    private final List<String> includes;
    private final List<String> excludes;
    private final MetricFilter filter;

    @JsonCreator
    public MetricsConfigurator(@JsonProperty(value="name") String name, @JsonProperty(value="comment") String comment, @JsonProperty(value="reporter") ReporterConfigurator reporter, @JsonProperty(value="includes") List<String> includes, @JsonProperty(value="excludes") List<String> excludes) {
        this.name = Objects.requireNonNull(name, "All reporters must have a name");
        this.comment = comment;
        this.configurator = Objects.requireNonNull(reporter, () -> String.format("Invalid definition for reporter with name %s. Must define a reporter block.", name));
        this.includes = Optional.ofNullable(includes).orElse(Collections.emptyList());
        this.excludes = Optional.ofNullable(excludes).orElse(Collections.emptyList());
        this.filter = this.includes.isEmpty() && this.excludes.isEmpty() ? MetricFilter.ALL : new IncludesExcludesFilter(includes, excludes);
    }

    public String getName() {
        return this.name;
    }

    public void start(MetricRegistry registry) {
        this.configurator.configureAndStart(this.name, registry, this.filter);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.comment, this.configurator, this.includes, this.excludes);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        MetricsConfigurator o = (MetricsConfigurator)other;
        return Objects.equals(this.name, o.name) && Objects.equals(this.comment, o.comment) && Objects.equals(this.configurator, o.configurator) && Objects.equals(this.filter, o.filter);
    }

    @VisibleForTesting
    public ReporterConfigurator getConfigurator() {
        return this.configurator;
    }

    @Override
    public void close() {
        this.configurator.close();
    }
}

