/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.telemetry.api.config;

import cdjd.com.codahale.metrics.Metric;
import cdjd.com.codahale.metrics.MetricFilter;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;

class IncludesExcludesFilter
implements MetricFilter {
    private final List<Pattern> includes;
    private final List<Pattern> excludes;

    public IncludesExcludesFilter(List<String> includes, List<String> excludes) {
        this.includes = IncludesExcludesFilter.asPatterns(includes, "include");
        this.excludes = IncludesExcludesFilter.asPatterns(excludes, "exclude");
    }

    @Override
    public boolean matches(String name, Metric metric) {
        if (this.includes.isEmpty() || IncludesExcludesFilter.matches(name, this.includes)) {
            return this.allowedViaExcludes(name);
        }
        return false;
    }

    private boolean allowedViaExcludes(String name) {
        if (this.excludes.isEmpty()) {
            return true;
        }
        return !IncludesExcludesFilter.matches(name, this.excludes);
    }

    private static boolean matches(String name, List<Pattern> patterns) {
        for (Pattern p : patterns) {
            if (!p.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    private static List<Pattern> asPatterns(List<String> values, String type) {
        return values.stream().filter(v -> v != null && !v.isEmpty()).map(v -> {
            try {
                return Pattern.compile(v);
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException(String.format("Failure while trying to parse %s pattern of value %s.", type, v), e);
            }
        }).collect(Collectors.toList());
    }

    public int hashCode() {
        return Objects.hash(this.includes, this.excludes);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass() != IncludesExcludesFilter.class) {
            return false;
        }
        IncludesExcludesFilter o = (IncludesExcludesFilter)other;
        return Objects.deepEquals(this.includes, o.includes) && Objects.deepEquals(this.excludes, o.excludes);
    }
}

