/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.ssl;

import cdjd.com.google.common.annotations.VisibleForTesting;
import java.security.KeyStore;
import java.util.Optional;
import java.util.Properties;

public class SSLConfig {
    public static final String ENABLE_SSL = "ssl";
    public static final String TRUST_STORE_TYPE = "trustStoreType";
    public static final String TRUST_STORE_PATH = "trustStore";
    public static final String TRUST_STORE_PASSWORD = "trustStorePassword";
    public static final String DISABLE_CERT_VERIFICATION = "disableCertificateVerification";
    public static final String DISABLE_HOST_VERIFICATION = "disableHostVerification";
    @VisibleForTesting
    public static final String UNSPECIFIED = "";
    private final String keyStoreType;
    private final String keyStorePath;
    private final String keyStorePassword;
    private final String keyPassword;
    private final String trustStoreType;
    private final String trustStorePath;
    private final String trustStorePassword;
    private final boolean disablePeerVerification;
    private final boolean disableHostVerification;

    private SSLConfig(String keyStoreType, String keyStorePath, String keyStorePassword, String keyPassword, String trustStoreType, String trustStorePath, String trustStorePassword, boolean disablePeerVerification, boolean disableHostVerification) {
        this.keyStoreType = keyStoreType;
        this.keyStorePath = keyStorePath;
        this.keyStorePassword = keyStorePassword;
        this.keyPassword = keyPassword;
        this.trustStoreType = trustStoreType;
        this.trustStorePath = trustStorePath;
        this.trustStorePassword = trustStorePassword;
        this.disablePeerVerification = disablePeerVerification;
        this.disableHostVerification = disableHostVerification;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public boolean disablePeerVerification() {
        return this.disablePeerVerification;
    }

    public boolean disableHostVerification() {
        return this.disableHostVerification;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Optional<SSLConfig> of(Properties properties) {
        if (properties == null) {
            return Optional.empty();
        }
        Properties canonicalProperties = new Properties();
        properties.stringPropertyNames().forEach(s2 -> canonicalProperties.setProperty(s2.toLowerCase(), properties.getProperty((String)s2)));
        Optional<Boolean> enabledOption = SSLConfig.getBooleanProperty(canonicalProperties, ENABLE_SSL);
        return enabledOption.filter(Boolean::booleanValue).map(ignored -> {
            Builder builder = SSLConfig.newBuilder();
            SSLConfig.getStringProperty(canonicalProperties, TRUST_STORE_TYPE).ifPresent(builder::setTrustStoreType);
            SSLConfig.getStringProperty(canonicalProperties, TRUST_STORE_PATH).ifPresent(builder::setTrustStorePath);
            SSLConfig.getStringProperty(canonicalProperties, TRUST_STORE_PASSWORD).ifPresent(builder::setTrustStorePassword);
            SSLConfig.getBooleanProperty(canonicalProperties, DISABLE_CERT_VERIFICATION).ifPresent(builder::setDisablePeerVerification);
            SSLConfig.getBooleanProperty(canonicalProperties, DISABLE_HOST_VERIFICATION).ifPresent(builder::setDisableHostVerification);
            return builder.build();
        });
    }

    private static Optional<Boolean> getBooleanProperty(Properties canonicalProperties, String key) {
        return Optional.ofNullable(canonicalProperties.getProperty(key.toLowerCase())).map(Boolean::parseBoolean);
    }

    private static Optional<String> getStringProperty(Properties canonicalProperties, String key) {
        return Optional.ofNullable(canonicalProperties.getProperty(key.toLowerCase()));
    }

    public static class Builder {
        private String keyStoreType = KeyStore.getDefaultType();
        private String keyStorePath = "";
        private String keyStorePassword = "";
        private String keyPassword = null;
        private String trustStoreType = KeyStore.getDefaultType();
        private String trustStorePath = "";
        private String trustStorePassword = "";
        private boolean disablePeerVerification = false;
        private boolean disableHostVerification = false;

        private Builder() {
        }

        public Builder setKeyStoreType(String keyStoreType) {
            this.keyStoreType = keyStoreType;
            return this;
        }

        public Builder setKeyStorePath(String keyStorePath) {
            this.keyStorePath = keyStorePath;
            return this;
        }

        public Builder setKeyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        public Builder setKeyPassword(String keyPassword) {
            this.keyPassword = keyPassword;
            return this;
        }

        public Builder setTrustStoreType(String trustStoreType) {
            this.trustStoreType = trustStoreType;
            return this;
        }

        public Builder setTrustStorePath(String trustStorePath) {
            this.trustStorePath = trustStorePath;
            return this;
        }

        public Builder setTrustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
            return this;
        }

        public Builder setDisablePeerVerification(boolean disable) {
            this.disablePeerVerification = disable;
            return this;
        }

        public Builder setDisableHostVerification(boolean disable) {
            this.disableHostVerification = disable;
            return this;
        }

        public SSLConfig build() {
            return new SSLConfig(this.keyStoreType, this.keyStorePath, this.keyStorePassword, this.keyPassword == null ? this.keyStorePassword : this.keyPassword, this.trustStoreType, this.trustStorePath, this.trustStorePassword, this.disablePeerVerification, this.disableHostVerification);
        }
    }
}

