/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.service.coordinator.zk;

import cdjd.com.dremio.common.AutoCloseables;
import cdjd.com.dremio.common.config.SabotConfig;
import cdjd.com.dremio.service.coordinator.ClusterCoordinator;
import cdjd.com.dremio.service.coordinator.DistributedSemaphore;
import cdjd.com.dremio.service.coordinator.ElectionListener;
import cdjd.com.dremio.service.coordinator.ElectionRegistrationHandle;
import cdjd.com.dremio.service.coordinator.ServiceSet;
import cdjd.com.dremio.service.coordinator.zk.ZKClusterClient;
import cdjd.com.dremio.service.coordinator.zk.ZKClusterConfig;
import cdjd.com.dremio.service.coordinator.zk.ZKClusterServiceSetManager;
import cdjd.com.dremio.service.coordinator.zk.ZKSabotConfig;
import cdjd.com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKClusterCoordinator
extends ClusterCoordinator {
    static final Logger logger = LoggerFactory.getLogger(ZKClusterCoordinator.class);
    private final ZKClusterServiceSetManager zkClusterServiceSetManager;
    private volatile boolean closed = false;

    public ZKClusterCoordinator(SabotConfig config) throws IOException {
        this(config, (String)null);
    }

    public ZKClusterCoordinator(SabotConfig config, String connect) throws IOException {
        this.zkClusterServiceSetManager = new ZKClusterServiceSetManager((ZKClusterConfig)new ZKSabotConfig(config), connect);
    }

    public ZKClusterCoordinator(SabotConfig config, Provider<Integer> localPort) throws IOException {
        this.zkClusterServiceSetManager = new ZKClusterServiceSetManager((ZKClusterConfig)new ZKSabotConfig(config), localPort);
    }

    @VisibleForTesting
    ZKClusterClient getZkClient() {
        return this.zkClusterServiceSetManager.getZkClient();
    }

    @VisibleForTesting
    public void setPortProvider(Provider<Integer> portProvider) {
        this.zkClusterServiceSetManager.getZkClient().setPortProvider(portProvider);
    }

    @Override
    public void start() throws Exception {
        this.zkClusterServiceSetManager.start();
        if (!this.closed) {
            Thread.sleep(5L);
            for (Service service : Service.values()) {
                this.zkClusterServiceSetManager.getOrCreateServiceSet(service.role.name(), service.name);
            }
            logger.info("ZKClusterCoordination is up");
        }
    }

    @Override
    public ServiceSet getServiceSet(ClusterCoordinator.Role role) {
        return this.zkClusterServiceSetManager.getServiceSet(role);
    }

    @Override
    public ServiceSet getOrCreateServiceSet(String serviceName) {
        return this.zkClusterServiceSetManager.getOrCreateServiceSet(serviceName);
    }

    @Override
    public Iterable<String> getServiceNames() throws Exception {
        return this.zkClusterServiceSetManager.getServiceNames();
    }

    @Override
    public DistributedSemaphore getSemaphore(String name, int maximumLeases) {
        return this.zkClusterServiceSetManager.getZkClient().getSemaphore(name, maximumLeases);
    }

    @Override
    public ElectionRegistrationHandle joinElection(String name, ElectionListener listener) {
        return this.zkClusterServiceSetManager.joinElection(name, listener);
    }

    @Override
    public void close() throws Exception {
        if (!this.closed) {
            this.closed = true;
            AutoCloseables.close(this.zkClusterServiceSetManager);
        }
    }

    private static enum Service {
        COORDINATOR(ClusterCoordinator.Role.COORDINATOR, "coordinator"),
        EXECUTOR(ClusterCoordinator.Role.EXECUTOR, "executor"),
        MASTER(ClusterCoordinator.Role.MASTER, "master");

        private final ClusterCoordinator.Role role;
        private final String name;

        private Service(ClusterCoordinator.Role role, String serviceName) {
            this.role = role;
            this.name = serviceName;
        }
    }
}

