/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.service.coordinator.zk;

import cdjd.com.dremio.common.AutoCloseables;
import cdjd.com.dremio.common.concurrent.CloseableSchedulerThreadPool;
import cdjd.com.dremio.common.concurrent.NamedThreadFactory;
import cdjd.com.dremio.exec.proto.CoordinationProtos;
import cdjd.com.dremio.service.Service;
import cdjd.com.dremio.service.coordinator.CoordinatorLostHandle;
import cdjd.com.dremio.service.coordinator.DistributedSemaphore;
import cdjd.com.dremio.service.coordinator.ElectionListener;
import cdjd.com.dremio.service.coordinator.ElectionRegistrationHandle;
import cdjd.com.dremio.service.coordinator.zk.BoundedExponentialDelay;
import cdjd.com.dremio.service.coordinator.zk.ServiceInstanceHelper;
import cdjd.com.dremio.service.coordinator.zk.ZKClusterConfig;
import cdjd.com.dremio.service.coordinator.zk.ZKElectionListener;
import cdjd.com.dremio.service.coordinator.zk.ZKServiceSet;
import cdjd.com.dremio.service.coordinator.zk.ZkDistributedSemaphore;
import cdjd.com.google.common.annotations.VisibleForTesting;
import cdjd.com.google.common.base.Throwables;
import cdjd.com.google.common.util.concurrent.FutureCallback;
import cdjd.com.google.common.util.concurrent.Futures;
import cdjd.com.google.common.util.concurrent.ListenableFuture;
import cdjd.com.google.common.util.concurrent.ListeningExecutorService;
import cdjd.com.google.common.util.concurrent.MoreExecutors;
import cdjd.org.apache.curator.framework.CuratorFramework;
import cdjd.org.apache.curator.framework.CuratorFrameworkFactory;
import cdjd.org.apache.curator.framework.recipes.leader.LeaderLatch;
import cdjd.org.apache.curator.framework.recipes.leader.LeaderLatchListener;
import cdjd.org.apache.curator.framework.recipes.leader.Participant;
import cdjd.org.apache.curator.framework.state.ConnectionState;
import cdjd.org.apache.curator.framework.state.ConnectionStateListener;
import cdjd.org.apache.curator.x.discovery.ServiceDiscovery;
import cdjd.org.apache.curator.x.discovery.ServiceDiscoveryBuilder;
import cdjd.org.apache.zookeeper.ZooKeeper;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ZKClusterClient
implements Service {
    private static final Logger logger = LoggerFactory.getLogger(ZKClusterClient.class);
    private static final Pattern ZK_COMPLEX_STRING = Pattern.compile("(^[^/]*?)/(?:(.*)/)?([^/]*)$");
    public static final String ZK_LOST_HANDLER_MODULE_CLASS = "dremio.coordinator_lost_handle.module.class";
    private final String clusterId;
    private final CountDownLatch initialConnection = new CountDownLatch(1);
    private final ListeningExecutorService executorService = MoreExecutors.listeningDecorator(Executors.newCachedThreadPool(new NamedThreadFactory("zk-curator-")));
    private CuratorFramework curator;
    private ServiceDiscovery<CoordinationProtos.NodeEndpoint> discovery;
    private ZKClusterConfig config;
    private final String connect;
    private String connectionString;
    private Provider<Integer> localPortProvider;
    private volatile boolean closed = false;
    private final CoordinatorLostHandle connectionLostHandler;

    public ZKClusterClient(ZKClusterConfig config, String connect) throws IOException {
        this(config, connect, null);
    }

    public ZKClusterClient(ZKClusterConfig config, Provider<Integer> localPort) throws IOException {
        this(config, null, localPort);
    }

    private ZKClusterClient(ZKClusterConfig config, String connect, Provider<Integer> localPort) throws IOException {
        Matcher m3;
        this.localPortProvider = localPort;
        this.connect = connect;
        this.config = config;
        String clusterId = config.getClusterId();
        if (connect != null && (m3 = ZK_COMPLEX_STRING.matcher(connect)).matches()) {
            clusterId = m3.group(3);
        }
        this.clusterId = clusterId;
        this.connectionLostHandler = config.isConnectionHandleEnabled() ? config.getConnectionLostHandler() : CoordinatorLostHandle.NO_OP;
    }

    @Override
    public void start() throws Exception {
        Matcher m3;
        this.connectionString = this.localPortProvider != null ? "localhost:" + this.localPortProvider.get() : (this.connect == null || this.connect.isEmpty() ? this.config.getConnection() : this.connect);
        String zkRoot = this.config.getRoot();
        if (this.connectionString != null && (m3 = ZK_COMPLEX_STRING.matcher(this.connectionString)).matches()) {
            this.connectionString = m3.group(1);
            zkRoot = m3.group(2);
        }
        logger.info("Connect: {}, zkRoot: {}, clusterId: {}", this.connectionString, zkRoot, this.clusterId);
        BoundedExponentialDelay rp = new BoundedExponentialDelay(this.config.getRetryBaseDelayMilliSecs(), this.config.getRetryMaxDelayMilliSecs(), this.config.isRetryUnlimited(), this.config.getRetryLimit());
        this.curator = CuratorFrameworkFactory.builder().namespace(zkRoot).connectionTimeoutMs(this.config.getConnectionTimeoutMilliSecs()).sessionTimeoutMs(this.config.getSessionTimeoutMilliSecs()).maxCloseWaitMs(this.config.getRetryMaxDelayMilliSecs()).retryPolicy(rp).connectString(this.connectionString).build();
        this.curator.getConnectionStateListenable().addListener(new InitialConnectionListener());
        this.curator.getConnectionStateListenable().addListener(new ConnectionListener());
        this.curator.start();
        this.discovery = this.newDiscovery(this.clusterId);
        logger.info("Starting ZKClusterClient, ZK_TIMEOUT: {}, ZK_SESSION_TIMEOUT:{}, ZK_RETRY_MAX_DELAY:{}, ZK_RETRY_UNLIMITED:{}, ZK_RETRY_LIMIT:{}, CONNECTION_HANDLE_ENABLED:{}", this.config.getConnectionTimeoutMilliSecs(), this.config.getSessionTimeoutMilliSecs(), this.config.getRetryMaxDelayMilliSecs(), this.config.isRetryUnlimited(), this.config.getRetryLimit(), this.config.isConnectionHandleEnabled());
        this.discovery.start();
        if (!this.config.isRetryUnlimited() && !this.initialConnection.await(this.config.getInitialTimeoutMilliSecs(), TimeUnit.MILLISECONDS)) {
            logger.info("Failed to get initial connection to ZK");
            this.connectionLostHandler.handleConnectionState(ConnectionState.LOST);
        } else {
            this.initialConnection.await();
        }
    }

    @VisibleForTesting
    ZooKeeper getZooKeeperClient() throws Exception {
        return this.curator.getZookeeperClient().getZooKeeper();
    }

    @VisibleForTesting
    String getConnectionString() {
        return this.connectionString;
    }

    @VisibleForTesting
    public void setPortProvider(Provider<Integer> portProvider) {
        this.localPortProvider = portProvider;
    }

    @Override
    public void close() throws Exception {
        if (!this.closed) {
            this.closed = true;
            logger.info("Stopping ZKClusterClient");
            this.initialConnection.countDown();
            AutoCloseables.close(this.discovery, this.curator, CloseableSchedulerThreadPool.of(this.executorService, logger));
            logger.info("Stopped ZKClusterClient");
        }
    }

    public DistributedSemaphore getSemaphore(String name, int maximumLeases) {
        try {
            return new ZkDistributedSemaphore(this.curator, "/" + this.clusterId + "/semaphore/" + name, maximumLeases);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Iterable<String> getServiceNames() throws Exception {
        return (Iterable)this.curator.getChildren().forPath("/" + this.clusterId);
    }

    public ElectionRegistrationHandle joinElection(final String name, final ElectionListener listener) {
        final String id = UUID.randomUUID().toString();
        final LeaderLatch leaderLatch = new LeaderLatch(this.curator, "/" + this.clusterId + "/leader-latch/" + name, id, LeaderLatch.CloseMode.SILENT);
        final AtomicReference newLeaderRef = new AtomicReference();
        leaderLatch.addListener(new LeaderLatchListener(){
            private final long electionTimeoutMs;
            private final long electionPollingMs;
            {
                this.electionTimeoutMs = ZKClusterClient.this.config.getElectionTimeoutMilliSecs();
                this.electionPollingMs = ZKClusterClient.this.config.getElectionPollingMilliSecs();
            }

            @Override
            public void notLeader() {
                logger.debug("Lost latch for election {}.", (Object)name);
                if (leaderLatch.getState() == LeaderLatch.State.CLOSED) {
                    listener.onCancelled();
                    return;
                }
                if (listener instanceof ZKElectionListener) {
                    ((ZKElectionListener)listener).onConnectionLoss();
                }
                final Future newLeader = ZKClusterClient.this.executorService.submit(new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        while (true) {
                            if (leaderLatch.hasLeadership()) {
                                if (listener instanceof ZKElectionListener) {
                                    ((ZKElectionListener)listener).onReconnection();
                                }
                                return id;
                            }
                            Participant participant = leaderLatch.getLeader();
                            if (listener instanceof ZKElectionListener) {
                                ((ZKElectionListener)listener).onReconnection();
                            }
                            if (participant.isLeader()) {
                                return participant.getId();
                            }
                            TimeUnit.MILLISECONDS.sleep(electionPollingMs);
                        }
                    }
                });
                Future newLeaderWithTimeout = ZKClusterClient.this.executorService.submit(new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        try {
                            return (String)newLeader.get(electionTimeoutMs, TimeUnit.MILLISECONDS);
                        }
                        catch (TimeoutException e) {
                            logger.info("Not able to get election status in {}ms. Cancelling election...", (Object)electionTimeoutMs);
                            newLeader.cancel(true);
                            throw e;
                        }
                    }
                });
                Futures.addCallback(newLeaderWithTimeout, new FutureCallback<String>(){

                    @Override
                    public void onSuccess(String result) {
                        if (!id.equals(result)) {
                            logger.info("New leader elected. Cancelling election...", (Object)electionTimeoutMs);
                            listener.onCancelled();
                        }
                    }

                    @Override
                    public void onFailure(Throwable t) {
                        if (t instanceof CancellationException) {
                            return;
                        }
                        listener.onCancelled();
                    }
                }, MoreExecutors.directExecutor());
                newLeaderRef.set(newLeaderWithTimeout);
            }

            @Override
            public void isLeader() {
                logger.debug("Acquired latch for election {}.", (Object)name);
                ListenableFuture newLeader = newLeaderRef.getAndSet(null);
                if (newLeader != null) {
                    newLeader.cancel(false);
                }
                listener.onElected();
            }
        });
        try {
            leaderLatch.start();
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
        return new ElectionRegistrationHandle(){

            @Override
            public void close() {
                try {
                    leaderLatch.close();
                }
                catch (IOException e) {
                    logger.error("Error when closing registration handle for election {}", (Object)name, (Object)e);
                }
            }

            @Override
            public int instanceCount() {
                try {
                    return leaderLatch.getParticipants().size();
                }
                catch (Exception e) {
                    logger.error("Unable to get leader latch participants count for {}", (Object)name, (Object)e);
                    return 0;
                }
            }
        };
    }

    public ZKServiceSet newServiceSet(String name) {
        return new ZKServiceSet(name, this.discovery);
    }

    private ServiceDiscovery<CoordinationProtos.NodeEndpoint> newDiscovery(String clusterId) {
        return ServiceDiscoveryBuilder.builder(CoordinationProtos.NodeEndpoint.class).basePath(clusterId).client(this.curator).serializer(ServiceInstanceHelper.SERIALIZER).build();
    }

    private class ConnectionListener
    implements ConnectionStateListener {
        private ConnectionListener() {
        }

        @Override
        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            if (ZKClusterClient.this.connectionLostHandler.stateLoggingEnabled()) {
                logger.info("ZK connection state changed to {}", (Object)newState);
            }
            ZKClusterClient.this.connectionLostHandler.handleConnectionState(newState);
        }
    }

    private class InitialConnectionListener
    implements ConnectionStateListener {
        private InitialConnectionListener() {
        }

        @Override
        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            if (newState == ConnectionState.CONNECTED) {
                ZKClusterClient.this.initialConnection.countDown();
                client.getConnectionStateListenable().removeListener(this);
            }
        }
    }
}

