/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.service.coordinator;

import cdjd.com.dremio.config.DremioConfig;
import cdjd.com.dremio.service.coordinator.ProjectConfig;
import cdjd.com.dremio.service.coordinator.ProjectConfigStore;
import cdjd.com.dremio.service.coordinator.proto.DataCredentials;
import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectConfigImpl
implements ProjectConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectConfigImpl.class);
    private static final String ACCELERATION_PLUGIN_SUB_PATH = "/accelerator";
    private static final String DOWNLOADS_PLUGIN_SUB_PATH = "/downloads";
    private static final String SCRATCH_PLUGIN_SUB_PATH = "/scratch";
    private final Provider<DremioConfig> fileProvider;
    private final Provider<ProjectConfigStore> storeProvider;

    public ProjectConfigImpl(Provider<DremioConfig> fileProvider, Provider<ProjectConfigStore> storeProvider) {
        this.fileProvider = fileProvider;
        this.storeProvider = storeProvider;
    }

    @Override
    public ProjectConfig.DistPathConfig getAcceleratorConfig() {
        return this.getDistPathConfig("paths.accelerator", ACCELERATION_PLUGIN_SUB_PATH);
    }

    @Override
    public ProjectConfig.DistPathConfig getScratchConfig() {
        return this.getDistPathConfig("paths.scratch", SCRATCH_PLUGIN_SUB_PATH);
    }

    @Override
    public ProjectConfig.DistPathConfig getDownloadsConfig() {
        return this.getDistPathConfig("paths.downloads", DOWNLOADS_PLUGIN_SUB_PATH);
    }

    private ProjectConfig.DistPathConfig getDistPathConfig(String pathString, String subPath) {
        URI path;
        Object accessKey = null;
        Object secretKey = null;
        ProjectConfigStore store = (ProjectConfigStore)this.storeProvider.get();
        DataCredentials dataCredentials = null;
        if (store.get() == null || !store.get().hasDistStoreConfig()) {
            path = ((DremioConfig)this.fileProvider.get()).getURI(pathString);
        } else {
            try {
                path = new URI(store.get().getDistStoreConfig().getPath() + subPath);
                LOGGER.info("Got dist path for {} from store {}. Uri {}", (Object)store.get().getDistStoreConfig().getPath(), (Object)path);
            }
            catch (URISyntaxException e) {
                path = ((DremioConfig)this.fileProvider.get()).getURI(pathString);
                LOGGER.error("Invalid dist path for {} in store {}. Uri {}", pathString, store.get().getDistStoreConfig().getPath(), path);
            }
            dataCredentials = store.get().getDataCredentials().hasKeys() ? DataCredentials.newBuilder().setKeys(store.get().getDataCredentials().getKeys()).build() : DataCredentials.newBuilder().setDataRole(store.get().getDataCredentials().getDataRole()).build();
        }
        return new ProjectConfig.DistPathConfig(path, dataCredentials);
    }

    @Override
    public String getOrgId() {
        if (((ProjectConfigStore)this.storeProvider.get()).get() != null) {
            return ((ProjectConfigStore)this.storeProvider.get()).get().getOrgId();
        }
        return null;
    }
}

