/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.service.coordinator;

import cdjd.com.dremio.common.util.DremioVersionUtils;
import cdjd.com.dremio.exec.enginemanagement.proto.EngineManagementProtos;
import cdjd.com.dremio.exec.proto.CoordinationProtos;
import cdjd.com.dremio.options.OptionManager;
import cdjd.com.dremio.service.coordinator.ClusterCoordinator;
import cdjd.com.dremio.service.coordinator.ExecutorSetService;
import cdjd.com.dremio.service.coordinator.ListenableSet;
import cdjd.com.dremio.service.coordinator.NodeStatusListener;
import cdjd.com.dremio.service.coordinator.ServiceSet;
import cdjd.com.google.common.collect.Lists;
import cdjd.com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Provider;

public class LocalExecutorSetService
implements ExecutorSetService {
    private final Provider<ClusterCoordinator> coordinator;
    private final Provider<OptionManager> optionManagerProvider;
    private ListenableSet executorSet = null;
    private boolean isVersionCheckEnabled = true;

    public LocalExecutorSetService(Provider<ClusterCoordinator> coordinator, Provider<OptionManager> optionManagerProvider) {
        this.coordinator = coordinator;
        this.optionManagerProvider = optionManagerProvider;
    }

    @Override
    public void start() {
    }

    @Override
    public synchronized ListenableSet getExecutorSet(EngineManagementProtos.EngineId engineId, EngineManagementProtos.SubEngineId subEngineId) {
        ServiceSet serviceSet;
        if (this.executorSet == null && (serviceSet = ((ClusterCoordinator)this.coordinator.get()).getServiceSet(ClusterCoordinator.Role.EXECUTOR)) != null) {
            this.isVersionCheckEnabled = ((OptionManager)this.optionManagerProvider.get()).getOption(ExecutorSetService.DREMIO_VERSION_CHECK);
            this.executorSet = this.isVersionCheckEnabled ? this.filterCompatibleExecutors(serviceSet) : serviceSet;
        }
        return this.executorSet;
    }

    @Override
    public Collection<CoordinationProtos.NodeEndpoint> getAllAvailableEndpoints() {
        if (this.executorSet != null) {
            return this.executorSet.getAvailableEndpoints();
        }
        return Lists.newArrayList();
    }

    private ListenableSet filterCompatibleExecutors(final ListenableSet delegate) {
        return new ListenableSet(){
            private Map<NodeStatusListener, NodeStatusListener> innerToForwarderMap = new ConcurrentHashMap<NodeStatusListener, NodeStatusListener>();

            @Override
            public Collection<CoordinationProtos.NodeEndpoint> getAvailableEndpoints() {
                return DremioVersionUtils.getCompatibleNodeEndpoints(delegate.getAvailableEndpoints());
            }

            @Override
            public void addNodeStatusListener(final NodeStatusListener inner) {
                NodeStatusListener forwarder = new NodeStatusListener(){

                    @Override
                    public void nodesUnregistered(Set<CoordinationProtos.NodeEndpoint> unregisteredNodes) {
                        inner.nodesUnregistered(Sets.newHashSet(DremioVersionUtils.getCompatibleNodeEndpoints(unregisteredNodes)));
                    }

                    @Override
                    public void nodesRegistered(Set<CoordinationProtos.NodeEndpoint> registeredNodes) {
                        inner.nodesRegistered(Sets.newHashSet(DremioVersionUtils.getCompatibleNodeEndpoints(registeredNodes)));
                    }
                };
                delegate.addNodeStatusListener(forwarder);
                this.innerToForwarderMap.put(inner, forwarder);
            }

            @Override
            public void removeNodeStatusListener(NodeStatusListener inner) {
                NodeStatusListener forwarder = this.innerToForwarderMap.remove(inner);
                if (forwarder != null) {
                    delegate.removeNodeStatusListener(forwarder);
                }
            }
        };
    }

    @Override
    public void close() throws Exception {
    }
}

