/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.service.coordinator;

import cdjd.com.dremio.exec.proto.CoordinationProtos;
import cdjd.com.dremio.service.coordinator.NodeStatusListener;
import cdjd.com.dremio.service.coordinator.ServiceSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractServiceSet
implements ServiceSet {
    private final ConcurrentHashMap<NodeStatusListener, NodeStatusListener> listeners = new ConcurrentHashMap(16, 0.75f, 16);

    protected AbstractServiceSet() {
    }

    protected void nodesUnregistered(Set<CoordinationProtos.NodeEndpoint> unregisteredNodes) {
        for (NodeStatusListener listener : this.listeners.keySet()) {
            listener.nodesUnregistered(unregisteredNodes);
        }
    }

    protected void nodesRegistered(Set<CoordinationProtos.NodeEndpoint> registeredNodes) {
        for (NodeStatusListener listener : this.listeners.keySet()) {
            listener.nodesRegistered(registeredNodes);
        }
    }

    @Override
    public void addNodeStatusListener(NodeStatusListener listener) {
        this.listeners.putIfAbsent(listener, listener);
    }

    @Override
    public void removeNodeStatusListener(NodeStatusListener listener) {
        this.listeners.remove(listener);
    }

    protected void clearListeners() {
        this.listeners.clear();
    }
}

