/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.service;

import cdjd.com.dremio.common.DeferredException;
import cdjd.com.dremio.common.scanner.persistence.ScanResult;
import cdjd.com.dremio.service.BindingProvider;
import cdjd.com.dremio.service.Initializer;
import cdjd.com.dremio.service.Service;
import cdjd.com.google.common.base.Preconditions;
import cdjd.com.google.common.collect.ImmutableMap;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitializerRegistry
implements Service {
    private static final Logger logger = LoggerFactory.getLogger(InitializerRegistry.class);
    private final ScanResult scanResult;
    private final BindingProvider provider;
    private ImmutableMap<Class<?>, Object> outputs;

    public InitializerRegistry(ScanResult scanResult, BindingProvider provider) {
        this.scanResult = scanResult;
        this.provider = provider;
    }

    public <T, X extends Initializer<T>> T get(Class<X> clazz) {
        Object obj = this.outputs.get(clazz);
        Preconditions.checkNotNull(obj, "No initializer with return value registered for %s.", (Object)clazz.getName());
        return (T)obj;
    }

    @Override
    public void start() throws Exception {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Set<Class<Initializer>> functions = this.scanResult.getImplementations(Initializer.class);
        DeferredException ex = new DeferredException();
        for (Class<Initializer> functionClass : functions) {
            Initializer i;
            try {
                i = functionClass.newInstance();
            }
            catch (Exception e) {
                ex.addException(new RuntimeException("Unable to load Initializer " + functionClass.getSimpleName(), e));
                continue;
            }
            try {
                Object inited = i.initialize(this.provider);
                if (inited == null) continue;
                builder.put(functionClass, inited);
            }
            catch (Exception e) {
                ex.addException(new RuntimeException("Unable to initialize Initializer " + functionClass.getSimpleName(), e));
            }
        }
        ex.throwAndClear();
        this.outputs = builder.build();
    }

    @Override
    public void close() throws Exception {
    }
}

