/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.sabot.rpc.user;

import cdjd.com.dremio.common.config.SabotConfig;
import cdjd.com.dremio.exec.proto.CoordinationProtos;
import cdjd.com.dremio.exec.proto.GeneralRPCProtos;
import cdjd.com.dremio.exec.proto.UserBitShared;
import cdjd.com.dremio.exec.proto.UserProtos;
import cdjd.com.dremio.exec.rpc.Acks;
import cdjd.com.dremio.exec.rpc.BasicClientWithConnection;
import cdjd.com.dremio.exec.rpc.ConnectionThrottle;
import cdjd.com.dremio.exec.rpc.MessageDecoder;
import cdjd.com.dremio.exec.rpc.Response;
import cdjd.com.dremio.exec.rpc.RpcConnectionHandler;
import cdjd.com.dremio.exec.rpc.RpcException;
import cdjd.com.dremio.exec.rpc.RpcFuture;
import cdjd.com.dremio.sabot.rpc.user.BackwardsCompatibilityDecoder;
import cdjd.com.dremio.sabot.rpc.user.Dremio09BackwardCompatibilityHandler;
import cdjd.com.dremio.sabot.rpc.user.QueryResultHandler;
import cdjd.com.dremio.sabot.rpc.user.UserProtobufLengthDecoder;
import cdjd.com.dremio.sabot.rpc.user.UserResultsListener;
import cdjd.com.dremio.sabot.rpc.user.UserRpcConfig;
import cdjd.com.dremio.sabot.rpc.user.UserRpcUtils;
import cdjd.com.dremio.ssl.SSLConfig;
import cdjd.com.dremio.ssl.SSLEngineFactory;
import cdjd.com.dremio.ssl.SSLEngineFactoryImpl;
import cdjd.com.google.common.base.Preconditions;
import cdjd.com.google.common.collect.Sets;
import cdjd.com.google.protobuf.MessageLite;
import cdjd.io.netty.buffer.ByteBuf;
import cdjd.io.netty.channel.EventLoopGroup;
import cdjd.org.apache.arrow.memory.BufferAllocator;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserClient
extends BasicClientWithConnection<UserProtos.RpcType, UserProtos.UserToBitHandshake, UserProtos.BitToUserHandshake> {
    private static final Logger logger = LoggerFactory.getLogger(UserClient.class);
    private final QueryResultHandler queryResultHandler = new QueryResultHandler();
    private final boolean supportComplexTypes;
    private final String clientName;
    private volatile UserBitShared.RpcEndpointInfos serverInfos = null;
    private volatile Set<UserProtos.RpcType> supportedMethods = null;

    public UserClient(String clientName, SabotConfig config, boolean supportComplexTypes, BufferAllocator alloc, EventLoopGroup eventLoopGroup, Executor eventExecutor, Optional<SSLConfig> sslConfig) throws RpcException {
        super(UserRpcConfig.getMapping(config, eventExecutor, sslConfig), alloc, eventLoopGroup, UserProtos.RpcType.HANDSHAKE, UserProtos.BitToUserHandshake.class, UserProtos.BitToUserHandshake.PARSER, "user client", UserClient.newSSLEngineFactory(sslConfig));
        this.clientName = Preconditions.checkNotNull(clientName);
        this.supportComplexTypes = supportComplexTypes;
    }

    private static Optional<SSLEngineFactory> newSSLEngineFactory(Optional<SSLConfig> sslConfig) throws RpcException {
        try {
            return SSLEngineFactoryImpl.create(sslConfig);
        }
        catch (SSLException e) {
            throw new RpcException(e);
        }
    }

    public UserBitShared.RpcEndpointInfos getServerInfos() {
        return this.serverInfos;
    }

    public Set<UserProtos.RpcType> getSupportedMethods() {
        return this.supportedMethods;
    }

    public void submitQuery(UserResultsListener resultsListener, UserProtos.RunQuery query) {
        this.send(this.queryResultHandler.getWrappedListener(resultsListener), UserProtos.RpcType.RUN_QUERY, query, UserBitShared.QueryId.class, new ByteBuf[0]);
    }

    public void connect(RpcConnectionHandler<BasicClientWithConnection.ServerConnection> handler, CoordinationProtos.NodeEndpoint endpoint, UserProtos.UserProperties props, UserBitShared.UserCredentials credentials) {
        UserProtos.UserToBitHandshake.Builder hsBuilder = UserProtos.UserToBitHandshake.newBuilder().setRpcVersion(UserRpcConfig.RPC_VERSION).setSupportListening(true).setSupportComplexTypes(this.supportComplexTypes).setSupportTimeout(true).setCredentials(credentials).setRecordBatchType(UserProtos.RecordBatchType.DREMIO).addSupportedRecordBatchFormats(UserProtos.RecordBatchFormat.DREMIO_1_4).addSupportedRecordBatchFormats(UserProtos.RecordBatchFormat.DREMIO_0_9).setClientInfos(UserRpcUtils.getRpcEndpointInfos(this.clientName));
        if (props != null) {
            hsBuilder.setProperties(props);
        }
        this.connectAsClient(this.queryResultHandler.getWrappedConnectionHandler(handler), hsBuilder.build(), endpoint.getAddress(), endpoint.getUserPort());
    }

    @Override
    protected MessageLite getResponseDefaultInstance(int rpcType) throws RpcException {
        switch (rpcType) {
            case 1: {
                return GeneralRPCProtos.Ack.getDefaultInstance();
            }
            case 0: {
                return UserProtos.BitToUserHandshake.getDefaultInstance();
            }
            case 7: {
                return UserBitShared.QueryId.getDefaultInstance();
            }
            case 10: {
                return UserBitShared.QueryResult.getDefaultInstance();
            }
            case 6: {
                return UserBitShared.QueryData.getDefaultInstance();
            }
            case 13: {
                return UserProtos.QueryPlanFragments.getDefaultInstance();
            }
            case 18: {
                return UserProtos.GetCatalogsResp.getDefaultInstance();
            }
            case 19: {
                return UserProtos.GetSchemasResp.getDefaultInstance();
            }
            case 20: {
                return UserProtos.GetTablesResp.getDefaultInstance();
            }
            case 21: {
                return UserProtos.GetColumnsResp.getDefaultInstance();
            }
            case 23: {
                return UserProtos.CreatePreparedStatementResp.getDefaultInstance();
            }
            case 9: {
                return UserProtos.GetServerMetaResp.getDefaultInstance();
            }
        }
        throw new RpcException(String.format("Unable to deal with RpcType of %d", rpcType));
    }

    @Override
    protected Response handleReponse(ConnectionThrottle throttle, int rpcType, byte[] pBody, ByteBuf dBody) throws RpcException {
        switch (rpcType) {
            case 6: {
                this.queryResultHandler.batchArrived(throttle, pBody, dBody);
                return new Response(UserProtos.RpcType.ACK, Acks.OK, new ByteBuf[0]);
            }
            case 10: {
                this.queryResultHandler.resultArrived(pBody);
                return new Response(UserProtos.RpcType.ACK, Acks.OK, new ByteBuf[0]);
            }
        }
        throw new RpcException(String.format("Unknown Rpc Type %d. ", rpcType));
    }

    @Override
    protected void validateHandshake(UserProtos.BitToUserHandshake inbound) throws RpcException {
        if (inbound.getStatus() != UserProtos.HandshakeStatus.SUCCESS) {
            String errMsg = String.format("Status: %s, Error Id: %s, Error message: %s", inbound.getStatus(), inbound.getErrorId(), inbound.getErrorMessage());
            logger.error(errMsg);
            throw new RpcException(errMsg, inbound.getStatus().toString(), inbound.getErrorId());
        }
        if (inbound.hasServerInfos()) {
            this.serverInfos = inbound.getServerInfos();
        }
        this.supportedMethods = Sets.immutableEnumSet(inbound.getSupportedMethodsList());
        UserProtos.RecordBatchFormat recordBatchFormat = inbound.hasRecordBatchFormat() ? inbound.getRecordBatchFormat() : UserProtos.RecordBatchFormat.DREMIO_0_9;
        switch (recordBatchFormat) {
            case DREMIO_1_4: {
                break;
            }
            case DREMIO_0_9: {
                BufferAllocator bcAllocator = ((BasicClientWithConnection.ServerConnection)this.connection).getAllocator().newChildAllocator("dremio09-backward", 0L, Long.MAX_VALUE);
                logger.debug("Adding dremio 09 backwards compatibility decoder");
                ((BasicClientWithConnection.ServerConnection)this.connection).getChannel().pipeline().addAfter("protocol-decoder", "dremio09-backward", new BackwardsCompatibilityDecoder(bcAllocator, new Dremio09BackwardCompatibilityHandler(bcAllocator)));
                break;
            }
            default: {
                throw new RpcException("Unsupported record batch format: " + recordBatchFormat);
            }
        }
    }

    @Override
    protected void finalizeConnection(UserProtos.BitToUserHandshake handshake, BasicClientWithConnection.ServerConnection connection) {
    }

    @Override
    public MessageDecoder newDecoder(BufferAllocator allocator) {
        return new UserProtobufLengthDecoder(allocator);
    }

    public RpcFuture<UserProtos.QueryPlanFragments> planQuery(UserProtos.GetQueryPlanFragments req) {
        return this.send(UserProtos.RpcType.GET_QUERY_PLAN_FRAGMENTS, req, UserProtos.QueryPlanFragments.class, new ByteBuf[0]);
    }
}

