/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.io.file;

import cdjd.com.dremio.io.file.Path;
import cdjd.com.google.common.base.Preconditions;
import java.util.function.Predicate;

public final class PathFilters {
    public static final Predicate<Path> ALL_FILES = unused -> true;
    public static final Predicate<Path> NO_HIDDEN_FILES = path -> {
        String name = path.getName();
        if (name.isEmpty()) {
            return true;
        }
        switch (name.charAt(0)) {
            case '.': 
            case '_': {
                return false;
            }
        }
        return true;
    };

    private PathFilters() {
    }

    public static Predicate<Path> startsWith(String prefix) {
        Preconditions.checkNotNull(prefix);
        return path -> path.getName().startsWith(prefix);
    }

    public static Predicate<Path> endsWith(String suffix) {
        Preconditions.checkNotNull(suffix);
        return path -> path.getName().endsWith(suffix);
    }
}

