/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.exec.vector.accessor;

import cdjd.com.dremio.common.types.TypeProtos;
import cdjd.com.dremio.common.types.Types;
import cdjd.com.dremio.exec.vector.accessor.AbstractSqlAccessor;
import cdjd.com.dremio.exec.vector.accessor.sql.TimePrintMillis;
import cdjd.com.google.common.base.Preconditions;
import cdjd.org.apache.arrow.vector.TimeMilliVector;
import java.sql.Time;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.TimeZone;

public class TimeMilliAccessor
extends AbstractSqlAccessor {
    private static final TypeProtos.MajorType TYPE = Types.optional(TypeProtos.MinorType.TIME);
    private final TimeZone defaultTimeZone;
    private final TimeMilliVector ac;

    public TimeMilliAccessor(TimeMilliVector vector, TimeZone defaultTZ) {
        this.ac = vector;
        this.defaultTimeZone = Preconditions.checkNotNull(defaultTZ, "Null TimeZone supplied.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return TYPE;
    }

    @Override
    public boolean isNull(int index) {
        return this.ac.isNull(index);
    }

    @Override
    public Class<?> getObjectClass() {
        return Time.class;
    }

    @Override
    public Object getObject(int index) {
        return this.getTime(index, this.defaultTimeZone);
    }

    @Override
    public Time getTime(int index, Calendar calendar) {
        Preconditions.checkNotNull(calendar, "Invalid calendar used when attempting to retrieve time.");
        return this.getTime(index, calendar.getTimeZone());
    }

    private Time getTime(int index, TimeZone tz) {
        if (this.ac.isNull(index)) {
            return null;
        }
        LocalDateTime date = LocalDateTime.ofInstant(Instant.ofEpochMilli(this.ac.get(index)), tz.toZoneId());
        return new TimePrintMillis(date);
    }
}

