/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.exec.rpc;

import cdjd.com.dremio.exec.proto.UserBitShared;
import cdjd.com.dremio.exec.rpc.ChannelListenerWithCoordinationId;
import cdjd.com.dremio.exec.rpc.ConnectionThrottle;
import cdjd.com.dremio.exec.rpc.RequestIdMap;
import cdjd.com.dremio.exec.rpc.ResettableBarrier;
import cdjd.com.dremio.exec.rpc.RpcException;
import cdjd.com.dremio.exec.rpc.RpcOutcome;
import cdjd.com.dremio.exec.rpc.RpcOutcomeListener;
import cdjd.io.netty.channel.ChannelFutureListener;
import cdjd.io.netty.channel.ChannelHandler;
import cdjd.io.netty.channel.ChannelHandlerContext;
import cdjd.io.netty.channel.ChannelInboundHandlerAdapter;
import cdjd.io.netty.channel.socket.SocketChannel;
import cdjd.org.apache.arrow.memory.BufferAllocator;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RemoteConnection
implements ConnectionThrottle,
AutoCloseable {
    static final Logger logger = LoggerFactory.getLogger(RemoteConnection.class);
    protected static final String BACK_PRESSURE_HANDLER = "back-pressure-handler";
    private final SocketChannel channel;
    private final WriteManager writeManager;
    private final RequestIdMap requestIdMap;
    private final String clientName;
    private String name;

    boolean inEventLoop() {
        return this.channel.eventLoop().inEventLoop();
    }

    protected RemoteConnection(RemoteConnection connection) {
        this.channel = connection.channel;
        this.clientName = connection.clientName;
        this.writeManager = new WriteManager();
        this.requestIdMap = new RequestIdMap(this.getName());
        this.writeManager.disable();
    }

    public RemoteConnection(SocketChannel channel, String name) {
        this(channel, name, true);
    }

    public RemoteConnection(SocketChannel channel, String name, boolean blockOnSocket) {
        this.channel = channel;
        this.clientName = name;
        this.writeManager = new WriteManager();
        this.requestIdMap = new RequestIdMap(this.getName());
        if (!blockOnSocket) {
            this.writeManager.disable();
        }
        channel.pipeline().addLast(BACK_PRESSURE_HANDLER, (ChannelHandler)new BackPressureHandler());
    }

    public String getName() {
        if (this.name == null) {
            this.name = String.format("%s <--> %s (%s)", this.channel.localAddress(), this.channel.remoteAddress(), this.clientName);
        }
        return this.name;
    }

    protected abstract BufferAllocator getAllocator();

    public final SocketChannel getChannel() {
        return this.channel;
    }

    boolean blockOnNotWritable(RpcOutcomeListener<?> listener) {
        try {
            this.writeManager.waitForWritable();
            return true;
        }
        catch (InterruptedException e) {
            listener.interrupted(e);
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public void setAutoRead(boolean enableAutoRead) {
        this.channel.config().setAutoRead(enableAutoRead);
    }

    protected boolean isActive() {
        return this.channel.isActive();
    }

    public void setChannelCloseHandler(ChannelFutureListener closeHandler) {
        this.channel.closeFuture().addListener(closeHandler);
    }

    <V> RpcOutcome<V> getAndRemoveRpcOutcome(int rpcType, int coordinationId, Class<V> clazz) {
        return this.requestIdMap.getAndRemoveRpcOutcome(rpcType, coordinationId, clazz);
    }

    <V> ChannelListenerWithCoordinationId createNewRpcListener(RpcOutcomeListener<V> handler, Class<V> clazz) {
        return this.requestIdMap.createNewRpcListener(handler, clazz, this);
    }

    void recordRemoteFailure(int coordinationId, UserBitShared.DremioPBError failure) {
        this.requestIdMap.recordRemoteFailure(coordinationId, failure);
    }

    void channelClosed(RpcException ex) {
        this.writeManager.disable();
        this.writeManager.setWritable(true);
        this.requestIdMap.channelClosed(ex);
    }

    @Override
    public void close() {
        try {
            if (this.channel.isActive()) {
                this.channel.close().get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            logger.warn("Caught exception while closing channel.", e);
            Thread.currentThread().interrupt();
        }
    }

    private class BackPressureHandler
    extends ChannelInboundHandlerAdapter {
        private BackPressureHandler() {
        }

        @Override
        public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
            RemoteConnection.this.writeManager.setWritable(ctx.channel().isWritable());
            ctx.fireChannelWritabilityChanged();
        }
    }

    private static class WriteManager {
        private final ResettableBarrier barrier = new ResettableBarrier();
        private volatile boolean disabled = false;

        public WriteManager() {
            this.barrier.openBarrier();
        }

        public void waitForWritable() throws InterruptedException {
            this.barrier.await();
        }

        public void setWritable(boolean isWritable) {
            if (isWritable) {
                this.barrier.openBarrier();
            } else if (!this.disabled) {
                this.barrier.closeBarrier();
            }
        }

        public void disable() {
            this.disabled = true;
        }
    }
}

