/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.exec.rpc;

import cdjd.com.dremio.exec.rpc.ConnectionFailedException;
import cdjd.com.dremio.exec.rpc.RemoteConnection;
import cdjd.com.dremio.exec.rpc.RpcCheckedFuture;
import cdjd.com.dremio.exec.rpc.RpcCommand;
import cdjd.com.dremio.exec.rpc.RpcConnectionHandler;
import cdjd.com.dremio.exec.rpc.RpcException;
import cdjd.com.dremio.exec.rpc.RpcFuture;
import cdjd.com.dremio.exec.rpc.RpcOutcomeListener;
import cdjd.com.google.common.util.concurrent.SettableFuture;
import cdjd.com.google.protobuf.MessageLite;
import cdjd.io.netty.buffer.ByteBuf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FutureBitCommand<T extends MessageLite, C extends RemoteConnection>
implements RpcCommand<T, C> {
    static final Logger logger = LoggerFactory.getLogger(FutureBitCommand.class);
    protected final SettableFuture<T> settableFuture = SettableFuture.create();
    private final RpcCheckedFuture<T> parentFuture = new RpcCheckedFuture<T>(this.settableFuture);

    public abstract void doRpcCall(RpcOutcomeListener<T> var1, C var2);

    @Override
    public void connectionAvailable(C connection) {
        this.doRpcCall(new DeferredRpcOutcome(), connection);
    }

    @Override
    public void connectionSucceeded(C connection) {
        this.connectionAvailable(connection);
    }

    public RpcFuture<T> getFuture() {
        return this.parentFuture;
    }

    @Override
    public void connectionFailed(RpcConnectionHandler.FailureType type, Throwable t) {
        this.settableFuture.setException(ConnectionFailedException.mapException(RpcException.mapException(String.format("Command failed while establishing connection.  Failure type %s.", new Object[]{type}), t), type));
    }

    private class DeferredRpcOutcome
    implements RpcOutcomeListener<T> {
        private DeferredRpcOutcome() {
        }

        @Override
        public void failed(RpcException ex) {
            FutureBitCommand.this.settableFuture.setException(ex);
        }

        @Override
        public void success(T value, ByteBuf buf) {
            FutureBitCommand.this.parentFuture.setBuffer(buf);
            FutureBitCommand.this.settableFuture.set(value);
        }

        @Override
        public void interrupted(InterruptedException e) {
            logger.warn("Interrupted while running the command", e);
            this.failed(new RpcException(e));
        }
    }
}

