/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.exec.record;

import cdjd.com.dremio.common.expression.BasePath;
import cdjd.com.dremio.common.expression.CompleteType;
import cdjd.com.dremio.common.types.TypeProtos;
import cdjd.com.dremio.common.util.MajorTypeHelper;
import cdjd.com.dremio.exec.expr.TypeHelper;
import cdjd.com.dremio.exec.record.BatchSchema;
import cdjd.com.dremio.exec.record.HyperVectorWrapper;
import cdjd.com.dremio.exec.record.SchemaBuilder;
import cdjd.com.dremio.exec.record.SimpleVectorWrapper;
import cdjd.com.dremio.exec.record.TypedFieldId;
import cdjd.com.dremio.exec.record.VectorAccessible;
import cdjd.com.dremio.exec.record.VectorWrapper;
import cdjd.com.dremio.exec.record.selection.SelectionVector2;
import cdjd.com.dremio.exec.record.selection.SelectionVector4;
import cdjd.com.google.common.base.Function;
import cdjd.com.google.common.base.Preconditions;
import cdjd.com.google.common.collect.FluentIterable;
import cdjd.com.google.common.collect.Lists;
import cdjd.org.apache.arrow.memory.BufferAllocator;
import cdjd.org.apache.arrow.vector.FieldVector;
import cdjd.org.apache.arrow.vector.ValueVector;
import cdjd.org.apache.arrow.vector.VectorSchemaRoot;
import cdjd.org.apache.arrow.vector.complex.FieldIdUtil2;
import cdjd.org.apache.arrow.vector.types.pojo.Field;
import cdjd.org.apache.arrow.vector.types.pojo.Schema;
import cdjd.org.apache.arrow.vector.util.CallBack;
import cdjd.org.apache.arrow.vector.util.TransferPair;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorContainer
implements Iterable<VectorWrapper<?>>,
VectorAccessible,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(VectorContainer.class);
    private final Resetter resetter = new Resetter();
    protected final List<VectorWrapper<?>> wrappers = Lists.newArrayList();
    protected final BufferAllocator allocator;
    private BatchSchema schema;
    private int recordCount = -1;
    public static final Function<VectorWrapper<?>, FieldVector> WRAPPER_TO_FIELD = new Function<VectorWrapper<?>, FieldVector>(){

        @Override
        public FieldVector apply(VectorWrapper<?> input) {
            return (FieldVector)input.getValueVector();
        }
    };
    public static final Function<VectorWrapper<?>, FieldVector[]> HYPER_WRAPPER_TO_FIELD = new Function<VectorWrapper<?>, FieldVector[]>(){

        @Override
        public FieldVector[] apply(VectorWrapper<?> input) {
            return (FieldVector[])input.getValueVectors();
        }
    };

    public VectorContainer() {
        this.allocator = null;
    }

    public VectorContainer(BufferAllocator allocator) {
        this.allocator = allocator;
    }

    public String toString() {
        return super.toString() + "[recordCount = " + this.recordCount + ", schema = " + this.schema + ", wrappers = " + this.wrappers + ", ...]";
    }

    public void addHyperList(List<ValueVector> vectors) {
        this.addHyperList(vectors, true);
    }

    private void clearSchema() {
        this.schema = null;
    }

    public void addHyperList(List<ValueVector> vectors, boolean releasable) {
        this.clearSchema();
        ValueVector[] vv = new ValueVector[vectors.size()];
        for (int i = 0; i < vv.length; ++i) {
            vv[i] = vectors.get(i);
        }
        this.add(vv, releasable);
    }

    void transferIn(VectorContainer containerIn) {
        Preconditions.checkArgument(this.wrappers.size() == containerIn.wrappers.size());
        for (int i = 0; i < this.wrappers.size(); ++i) {
            containerIn.wrappers.get(i).transfer(this.wrappers.get(i));
        }
    }

    public void addSchema(Schema schema) {
        this.clearSchema();
        for (Field f : schema.getFields()) {
            this.addOrGet(f);
        }
    }

    public void transferOut(VectorContainer containerOut) {
        Preconditions.checkArgument(this.wrappers.size() == containerOut.wrappers.size());
        for (int i = 0; i < this.wrappers.size(); ++i) {
            this.wrappers.get(i).transfer(containerOut.wrappers.get(i));
        }
    }

    public void addIfMissing(Field field, boolean isHyper) {
        TypedFieldId id = FieldIdUtil2.getFieldId(this.getPartialSchema(), BasePath.getSimple(field.getName()));
        if (id == null) {
            if (isHyper) {
                this.addEmptyHyper(field);
            } else {
                FieldVector vector = TypeHelper.getNewVector(field, this.allocator, this.resetter);
                this.add(vector);
            }
        }
    }

    public boolean isNewSchema() {
        return this.schema == null;
    }

    public <T extends ValueVector> T addOrGet(Field field) {
        FieldVector vector;
        TypedFieldId id = FieldIdUtil2.getFieldId(this.getPartialSchema(), BasePath.getSimple(field.getName()));
        if (id != null) {
            Class<? extends FieldVector> clazz = CompleteType.fromField(field).getValueVectorClass();
            vector = this.getValueAccessorById(id.getFieldIds()).getValueVector();
            if (id.getFieldIds().length == 1 && clazz != null && !clazz.isAssignableFrom(vector.getClass())) {
                FieldVector newVector = TypeHelper.getNewVector(field, this.allocator, this.resetter);
                this.replace(vector, newVector);
                return (T)newVector;
            }
        } else {
            vector = TypeHelper.getNewVector(field, this.allocator, this.resetter);
            this.add(vector);
        }
        return (T)vector;
    }

    public <T extends ValueVector> T addOrGet(String name, TypeProtos.MajorType type, Class<T> clazz) {
        Field field = new Field(name, true, MajorTypeHelper.getArrowMinorType(type.getMinorType()).getType(), null);
        return this.addOrGet(field);
    }

    public static VectorContainer getTransferClone(VectorAccessible incoming, BufferAllocator allocator) {
        VectorContainer vc = new VectorContainer(allocator);
        for (VectorWrapper w : incoming) {
            vc.cloneAndTransfer(w);
        }
        vc.setRecordCount(incoming.getRecordCount());
        vc.buildSchema(BatchSchema.SelectionVectorMode.NONE);
        return vc;
    }

    public static void transferFromRoot(VectorSchemaRoot root, VectorContainer container, BufferAllocator allocator) {
        container.clear();
        for (FieldVector fv : root.getFieldVectors()) {
            TransferPair tp = fv.getTransferPair(allocator);
            tp.transfer();
            container.add(tp.getTo());
        }
        container.setRecordCount(root.getRowCount());
        container.addSchema(root.getSchema());
        container.buildSchema();
    }

    public static VectorContainer create(BufferAllocator allocator, Schema schema) {
        VectorContainer container = new VectorContainer(allocator);
        for (Field field : schema.getFields()) {
            container.addOrGet(field);
        }
        container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
        return container;
    }

    private void cloneAndTransfer(VectorWrapper<?> wrapper) {
        this.wrappers.add(wrapper.cloneAndTransfer(this.allocator, this.resetter));
    }

    public void addCollection(Iterable<ValueVector> vectors) {
        this.clearSchema();
        for (ValueVector vv : vectors) {
            this.wrappers.add(SimpleVectorWrapper.create(vv));
        }
    }

    public TypedFieldId add(ValueVector vv) {
        this.clearSchema();
        int i = this.wrappers.size();
        this.wrappers.add(SimpleVectorWrapper.create(vv));
        return new TypedFieldId(CompleteType.fromField(vv.getField()), i);
    }

    public <T extends ValueVector> void addEmptyHyper(Field f) {
        this.clearSchema();
        ValueVector[] c = (ValueVector[])Array.newInstance(TypeHelper.getValueVectorClass(f), 0);
        this.wrappers.add(HyperVectorWrapper.create((Field)f, (ValueVector[])c, (boolean)true));
    }

    public void add(ValueVector[] hyperVector) {
        this.add(hyperVector, true);
    }

    public void add(ValueVector[] hyperVector, boolean releasable) {
        assert (hyperVector.length != 0);
        this.clearSchema();
        Class<?> clazz = hyperVector[0].getClass();
        ValueVector[] c = (ValueVector[])Array.newInstance(clazz, hyperVector.length);
        for (int i = 0; i < hyperVector.length; ++i) {
            c[i] = hyperVector[i];
        }
        this.wrappers.add(HyperVectorWrapper.create((Field)hyperVector[0].getField(), (ValueVector[])c, (boolean)releasable));
    }

    public void remove(ValueVector v) {
        this.clearSchema();
        Iterator<VectorWrapper<?>> iter = this.wrappers.iterator();
        while (iter.hasNext()) {
            VectorWrapper<?> w = iter.next();
            if (w.isHyper() || v != w.getValueVector()) continue;
            w.clear();
            iter.remove();
            return;
        }
        throw new IllegalStateException("You attempted to remove a vector that didn't exist.");
    }

    public void replace(ValueVector old, ValueVector newVector) {
        this.clearSchema();
        int i = 0;
        for (VectorWrapper<?> w : this.wrappers) {
            if (!w.isHyper() && old == w.getValueVector()) {
                w.clear();
                this.wrappers.set(i, new SimpleVectorWrapper<ValueVector>(newVector));
                return;
            }
            ++i;
        }
        throw new IllegalStateException("You attempted to remove a vector that didn't exist.");
    }

    @Override
    public TypedFieldId getValueVectorId(BasePath path) {
        return FieldIdUtil2.getFieldId(this.getPartialSchema(), path);
    }

    @Override
    public <T extends ValueVector> VectorWrapper<T> getValueAccessorById(Class<T> clazz, int ... fieldIds) {
        Preconditions.checkArgument(fieldIds.length >= 1);
        VectorWrapper<?> va = this.wrappers.get(fieldIds[0]);
        if (va == null) {
            return null;
        }
        if (fieldIds.length == 1 && clazz != null && !clazz.isAssignableFrom(va.getVectorClass())) {
            throw new IllegalStateException(String.format("Failure while reading vector.  Expected vector class of %s but was holding vector class %s, field= %s ", clazz.getCanonicalName(), va.getVectorClass().getCanonicalName(), va.getField()));
        }
        return va.getChildWrapper(fieldIds);
    }

    private VectorWrapper<?> getValueAccessorById(int ... fieldIds) {
        Preconditions.checkArgument(fieldIds.length >= 1);
        VectorWrapper<?> va = this.wrappers.get(fieldIds[0]);
        if (va == null) {
            return null;
        }
        return va.getChildWrapper(fieldIds);
    }

    public boolean hasSchema() {
        return this.schema != null;
    }

    private BatchSchema getPartialSchema() {
        if (this.schema == null) {
            SchemaBuilder bldr = BatchSchema.newBuilder().setSelectionVectorMode(BatchSchema.SelectionVectorMode.NONE);
            for (VectorWrapper<?> v : this.wrappers) {
                bldr.addField(v.getField());
            }
            return bldr.build();
        }
        return this.schema;
    }

    private BufferAllocator getAllocator() {
        throw new UnsupportedOperationException("Intentionally not exposing the allocator of the VectorContainer. Doing so might accidentally expose the fragment output allocator");
    }

    @Override
    public BatchSchema getSchema() {
        Preconditions.checkNotNull(this.schema, "Container schema is not set. Either schema was not built, or schema was cleared.");
        return this.schema;
    }

    public void buildSchema() {
        this.buildSchema(BatchSchema.SelectionVectorMode.NONE);
    }

    public void buildSchema(BatchSchema.SelectionVectorMode mode) {
        SchemaBuilder bldr = BatchSchema.newBuilder().setSelectionVectorMode(mode);
        for (VectorWrapper<?> v : this.wrappers) {
            bldr.addField(v.getField());
        }
        this.schema = bldr.build();
    }

    @Override
    public Iterator<VectorWrapper<?>> iterator() {
        return this.wrappers.iterator();
    }

    public void clear() {
        this.close();
    }

    @Override
    public void close() {
        this.clearSchema();
        this.zeroVectors();
        this.wrappers.clear();
    }

    public void setRecordCount(int recordCount) {
        this.recordCount = recordCount;
    }

    @Override
    public int getRecordCount() {
        Preconditions.checkState(this.recordCount != -1, "Record count not set for this vector container");
        return this.recordCount;
    }

    @Override
    public SelectionVector2 getSelectionVector2() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SelectionVector4 getSelectionVector4() {
        throw new UnsupportedOperationException();
    }

    public void zeroVectors() {
        for (VectorWrapper<?> w : this.wrappers) {
            w.clear();
        }
    }

    public int getNumberOfColumns() {
        return this.wrappers.size();
    }

    public void setInitialCapacity(int initialCapacity) {
        for (VectorWrapper<?> w : this.wrappers) {
            Object vv = w.getValueVector();
            vv.setInitialCapacity(initialCapacity);
        }
    }

    public void allocateNew() {
        for (VectorWrapper<?> w : this.wrappers) {
            w.getValueVector().allocateNew();
        }
    }

    public int setAllCount(int records) {
        if (records != 0) {
            for (VectorWrapper<?> w : this) {
                w.getValueVector().setValueCount(records);
            }
        }
        this.setRecordCount(records);
        return records;
    }

    public static List<FieldVector[]> getHyperFieldVectors(VectorAccessible a) {
        return FluentIterable.from(a).transform(HYPER_WRAPPER_TO_FIELD).toList();
    }

    public static List<FieldVector> getFieldVectors(VectorAccessible a) {
        return FluentIterable.from(a).transform(WRAPPER_TO_FIELD).toList();
    }

    private class Resetter
    implements CallBack {
        private Resetter() {
        }

        @Override
        public void doWork() {
            VectorContainer.this.clearSchema();
        }
    }
}

