/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.context;

import cdjd.com.dremio.context.LocalValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;

public class RequestContext {
    private static final LocalValue<RequestContext> CURRENT = new LocalValue();
    private static final RequestContext EMPTY = new RequestContext(Collections.emptyMap());
    private final Map<Key<?>, Object> values;

    private RequestContext(Map<Key<?>, Object> values) {
        this.values = values;
    }

    public <T> RequestContext with(Key<T> key, T value) {
        HashMap newValues = new HashMap(this.values);
        newValues.put(key, value);
        return new RequestContext(newValues);
    }

    public RequestContext with(Map<Key<?>, Object> map) {
        HashMap newValues = new HashMap(this.values);
        newValues.putAll(map);
        return new RequestContext(newValues);
    }

    public <T> T get(Key<T> key) {
        return (T)this.values.get(key);
    }

    public void run(Runnable runnable) {
        RequestContext saved = RequestContext.current();
        CURRENT.set(this);
        try {
            runnable.run();
        }
        finally {
            CURRENT.set(saved);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V call(Callable<V> callable) throws Exception {
        RequestContext saved = RequestContext.current();
        CURRENT.set(this);
        try {
            V v = callable.call();
            return v;
        }
        finally {
            CURRENT.set(saved);
        }
    }

    public static RequestContext current() {
        return CURRENT.get().orElse(EMPTY);
    }

    public static RequestContext empty() {
        return EMPTY;
    }

    public static <T> Key<T> newKey(String name) {
        return new KeyImpl(name);
    }

    private static class KeyImpl<T>
    implements Key<T> {
        private final String name;

        public KeyImpl(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static interface Key<T> {
        public String getName();
    }
}

