/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.utils.protos;

import cdjd.com.dremio.common.utils.protos.ExternalIdHelper;
import cdjd.com.dremio.exec.proto.UserBitShared;

public class AttemptId {
    private static final int MASK = 255;
    private final UserBitShared.ExternalId externalId;
    private final int attempt;

    public AttemptId() {
        this(ExternalIdHelper.generateExternalId(), 0);
    }

    public AttemptId(UserBitShared.ExternalId externalId, int attempt) {
        assert (ExternalIdHelper.isValid(externalId)) : "not a valid externalId";
        assert (attempt >= 0 && attempt < 256) : "invalid attempt# " + attempt;
        this.externalId = externalId;
        this.attempt = attempt;
    }

    public UserBitShared.QueryId toQueryId() {
        long part1 = this.externalId.getPart1();
        long part2 = this.externalId.getPart2();
        return UserBitShared.QueryId.newBuilder().setPart1(part1).setPart2(part2 + (long)((byte)this.attempt & 0xFF)).build();
    }

    public UserBitShared.ExternalId getExternalId() {
        return this.externalId;
    }

    public String toString() {
        return ExternalIdHelper.toString(this.externalId) + "/" + this.attempt;
    }

    public int getAttemptNum() {
        return this.attempt;
    }

    public static AttemptId of(UserBitShared.ExternalId externalId) {
        return new AttemptId(externalId, 0);
    }

    public static AttemptId of(UserBitShared.QueryId queryId) {
        UserBitShared.ExternalId externalId = ExternalIdHelper.toExternal(queryId);
        int attempt = (int)(queryId.getPart2() & 0xFFL);
        return new AttemptId(externalId, attempt);
    }

    public AttemptId nextAttempt() {
        return new AttemptId(this.externalId, this.attempt + 1);
    }
}

