/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.utils;

import cdjd.com.google.common.base.CharMatcher;
import cdjd.com.google.common.base.Function;
import cdjd.com.google.common.base.Joiner;
import cdjd.com.google.common.base.Preconditions;
import cdjd.com.google.common.collect.FluentIterable;
import cdjd.com.google.common.collect.ImmutableCollection;
import cdjd.com.google.common.collect.ImmutableSet;
import cdjd.com.google.common.io.Resources;
import cdjd.org.apache.commons.lang3.text.StrTokenizer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlUtils {
    private static final Logger logger = LoggerFactory.getLogger(SqlUtils.class);
    public static final String LEGACY_USE_BACKTICKS = "dremio.legacy.backticks_for_identifiers";
    public static final char QUOTE;
    public static final String QUOTE_WITH_ESCAPE;
    private static final String RESERVED_SQL_KEYWORDS_FILE = "sql-reserved-keywords.txt";
    private static final CharMatcher ALPHANUM_MATCHER;
    private static final CharMatcher NEWLINE_MATCHER;
    public static ImmutableSet<String> RESERVED_SQL_KEYWORDS;
    public static Function<String, String> QUOTER;

    public static String quotedCompound(List<String> strings) {
        return FluentIterable.from(strings).transform(QUOTER).join(Joiner.on('.'));
    }

    public static String quoteIdentifier(String id) {
        if (id.isEmpty()) {
            return id;
        }
        if (SqlUtils.isKeyword(id)) {
            return SqlUtils.quoteString(id);
        }
        if (Character.isAlphabetic(id.charAt(0)) && ALPHANUM_MATCHER.matchesAllOf(id)) {
            return id;
        }
        if (NEWLINE_MATCHER.matchesAnyOf(id)) {
            return SqlUtils.quoteUnicodeString(id);
        }
        return SqlUtils.quoteString(id);
    }

    private static String quoteString(String id) {
        StringBuilder sb = new StringBuilder();
        sb.append(QUOTE);
        sb.append(CharMatcher.is(QUOTE).replaceFrom((CharSequence)id, QUOTE_WITH_ESCAPE));
        sb.append(QUOTE);
        return sb.toString();
    }

    private static String quoteUnicodeString(String id) {
        StringBuilder sb = new StringBuilder();
        sb.append("U&").append(QUOTE);
        block4: for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            switch (c) {
                case '\n': {
                    sb.append("\\000a");
                    continue block4;
                }
                case '\r': {
                    sb.append("\\000d");
                    continue block4;
                }
                default: {
                    if (c == QUOTE) {
                        sb.append(QUOTE_WITH_ESCAPE);
                        continue block4;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append(QUOTE);
        return sb.toString();
    }

    public static boolean isKeyword(String id) {
        Preconditions.checkState(RESERVED_SQL_KEYWORDS != null, "SQL reserved keyword list is not loaded. Please check the logs for error messages.");
        return RESERVED_SQL_KEYWORDS.contains(id.toUpperCase());
    }

    public static final String stringLiteral(String value) {
        String escaped = value.replaceAll("'", "''");
        return "'" + escaped + "'";
    }

    public static List<String> parseSchemaPath(String schemaPath) {
        return new StrTokenizer(schemaPath, '.', QUOTE).setIgnoreEmptyTokens(true).getTokenList();
    }

    static {
        if ("true".equalsIgnoreCase(System.getProperty(LEGACY_USE_BACKTICKS))) {
            QUOTE = (char)96;
            QUOTE_WITH_ESCAPE = "``";
        } else {
            QUOTE = (char)34;
            QUOTE_WITH_ESCAPE = "\"\"";
        }
        ALPHANUM_MATCHER = CharMatcher.inRange('0', '9').or(CharMatcher.inRange('a', 'z')).or(CharMatcher.inRange('A', 'Z')).or(CharMatcher.is('_')).precomputed();
        NEWLINE_MATCHER = CharMatcher.anyOf("\n\r").precomputed();
        URL parserListPath = null;
        try {
            parserListPath = Resources.getResource(RESERVED_SQL_KEYWORDS_FILE);
        }
        catch (Throwable e) {
            logger.error(String.format("Failed to find Dremio SQL parser's reserved keywords file '%s' on classpath.", RESERVED_SQL_KEYWORDS_FILE), e);
        }
        ImmutableCollection set = null;
        if (parserListPath != null) {
            try {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                for (String line : Resources.readLines(parserListPath, StandardCharsets.UTF_8)) {
                    String trimmedLine = line.trim();
                    if (trimmedLine.startsWith("#")) continue;
                    builder.add(trimmedLine);
                }
                set = builder.build();
            }
            catch (Throwable e) {
                logger.error(String.format("Failed to load Dremio SQL parser's reserved keywords from file: %s", parserListPath.toString()), e);
            }
        }
        RESERVED_SQL_KEYWORDS = set;
        QUOTER = new Function<String, String>(){

            @Override
            public String apply(String input) {
                return SqlUtils.quoteIdentifier(input);
            }
        };
    }
}

