/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.exceptions;

import cdjd.com.dremio.common.exceptions.AdditionalExceptionContext;
import cdjd.com.dremio.common.exceptions.UserException;
import cdjd.com.dremio.common.serde.ProtobufByteStringSerDe;
import cdjd.com.fasterxml.jackson.core.JsonGenerator;
import cdjd.com.fasterxml.jackson.core.JsonProcessingException;
import cdjd.com.fasterxml.jackson.databind.ObjectMapper;
import cdjd.com.google.protobuf.ByteString;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JsonAdditionalExceptionContext
implements AdditionalExceptionContext {
    private static final Logger logger = LoggerFactory.getLogger(JsonAdditionalExceptionContext.class);
    private static final ObjectMapper contextMapper = new ObjectMapper();

    protected static <T extends AdditionalExceptionContext> T fromUserException(Class<T> clazz, UserException ex) {
        if (ex.getRawAdditionalExceptionContext() == null) {
            logger.debug("missing additional context in UserException");
            return null;
        }
        try {
            return (T)((AdditionalExceptionContext)ProtobufByteStringSerDe.readValue(contextMapper.readerFor(clazz), ex.getRawAdditionalExceptionContext(), ProtobufByteStringSerDe.Codec.NONE, logger));
        }
        catch (IOException ignored) {
            logger.debug("unable to deserialize additional exception context", ignored);
            return null;
        }
    }

    @Override
    public ByteString toByteString() {
        try {
            return ProtobufByteStringSerDe.writeValue(contextMapper, this, ProtobufByteStringSerDe.Codec.NONE);
        }
        catch (JsonProcessingException ignored) {
            logger.debug("unable to serialize additional exception context", ignored);
            return null;
        }
    }

    static {
        contextMapper.enable(JsonGenerator.Feature.IGNORE_UNKNOWN);
    }
}

