/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.config;

import cdjd.com.dremio.common.config.NestedConfig;
import cdjd.com.dremio.common.config.SabotConfigurationException;
import cdjd.com.dremio.common.exceptions.UserException;
import cdjd.com.dremio.common.scanner.ClassPathScanner;
import cdjd.com.google.common.annotations.VisibleForTesting;
import cdjd.com.google.common.base.Preconditions;
import cdjd.com.google.common.base.Stopwatch;
import cdjd.com.google.common.collect.ImmutableList;
import cdjd.com.typesafe.config.Config;
import cdjd.com.typesafe.config.ConfigFactory;
import cdjd.com.typesafe.config.ConfigRenderOptions;
import cdjd.com.typesafe.config.ConfigValue;
import cdjd.org.reflections.util.ClasspathHelper;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SabotConfig
extends NestedConfig {
    private static final Logger logger = LoggerFactory.getLogger(SabotConfig.class);
    private final ImmutableList<String> startupArguments;

    private SabotConfig(Config config, ImmutableList<String> startupArguments) {
        super(config);
        this.startupArguments = startupArguments;
    }

    @VisibleForTesting
    public SabotConfig(Config config, boolean enableServerConfigs) {
        super(config);
        logger.debug("Setting up SabotConfig object.");
        logger.trace("Given Config object is:\n{}", (Object)config.root().render(ConfigRenderOptions.defaults()));
        RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
        this.startupArguments = ImmutableList.copyOf(bean.getInputArguments());
        logger.debug("SabotConfig object initialized.");
    }

    public <T> T getInstance(String path, Class<T> iface, Object ... constructorArgs) {
        try {
            String className = this.getString(path);
            Class<?> clazz = Class.forName(className);
            return this.instantiate(iface, clazz, constructorArgs);
        }
        catch (Exception e) {
            throw UserException.unsupportedError(e).message("Failure while attempting to load instance of the class of type %s requested at path %s.", iface.getName(), path).build(logger);
        }
    }

    public <T> T getInstance(String path, Class<T> iface, Class<? extends T> defaultImpl) {
        if (this.hasPath(path)) {
            return this.getInstance(path, iface, new Object[0]);
        }
        try {
            return this.instantiate(iface, defaultImpl, new Object[0]);
        }
        catch (Exception e) {
            throw UserException.unsupportedError(e).message("Failure while attempting to instantiate default implementation class %s for interface  %s. The sabot config key is %s ", defaultImpl.getName(), iface.getName(), path).build(logger);
        }
    }

    public <T> T getInstance(String path, Class<T> iface, T defaultInstance, Object ... constructorArgs) {
        if (this.hasPath(path)) {
            return this.getInstance(path, iface, constructorArgs);
        }
        return defaultInstance;
    }

    public <T> Class<? extends T> getClass(String path, Class<T> iface, Class<? extends T> defaultImpl) {
        if (this.hasPath(path)) {
            String className = this.getString(path);
            try {
                Class<?> clazz = Class.forName(className);
                Preconditions.checkArgument(iface.isAssignableFrom(clazz));
                return clazz;
            }
            catch (ClassNotFoundException e) {
                throw UserException.unsupportedError(e).message("Failure while attempting to find implementation class %s for interface  %s. The sabot config key is %s ", defaultImpl.getName(), iface.getName(), path).build(logger);
            }
        }
        return defaultImpl;
    }

    private <T> T instantiate(Class<T> iface, Class<?> clazz, Object ... constructorArgs) throws ReflectiveOperationException {
        Preconditions.checkArgument(iface.isAssignableFrom(clazz));
        Class[] argClasses = new Class[constructorArgs.length];
        for (int i = 0; i < constructorArgs.length; ++i) {
            argClasses[i] = constructorArgs[i].getClass();
        }
        Constructor<?> constructor = clazz.getConstructor(argClasses);
        return (T)constructor.newInstance(constructorArgs);
    }

    public List<String> getStartupArguments() {
        return this.startupArguments;
    }

    public static SabotConfig create() {
        return SabotConfig.create(null, true);
    }

    public static SabotConfig forClient() {
        return SabotConfig.create(null, false);
    }

    public static SabotConfig create(String overrideFileResourcePathname) {
        return SabotConfig.create(overrideFileResourcePathname, true);
    }

    @VisibleForTesting
    public static SabotConfig create(Properties testConfigurations) {
        return SabotConfig.create(null, testConfigurations, true);
    }

    public static SabotConfig create(String overrideFileResourcePathname, boolean enableServerConfigs) {
        return SabotConfig.create(overrideFileResourcePathname, null, enableServerConfigs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SabotConfig create(String overrideFileResourcePathname, Properties overriderProps, boolean enableServerConfigs) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        if (null == originalClassLoader) {
            Thread.currentThread().setContextClassLoader(SabotConfig.class.getClassLoader());
        }
        try {
            SabotConfig sabotConfig = SabotConfig.doCreate(overrideFileResourcePathname, overriderProps, enableServerConfigs);
            return sabotConfig;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private static SabotConfig doCreate(String overrideFileResourcePathname, Properties overriderProps, boolean enableServerConfigs) {
        ClassLoader[] classLoaders;
        StringBuilder logString = new StringBuilder();
        Stopwatch watch = Stopwatch.createStarted();
        overrideFileResourcePathname = overrideFileResourcePathname == null ? "sabot-override.conf" : overrideFileResourcePathname;
        Config fallback = null;
        for (ClassLoader classLoader : classLoaders = ClasspathHelper.classLoaders(new ClassLoader[0])) {
            URL url = classLoader.getResource("sabot-default.conf");
            if (null == url) continue;
            logString.append("Base Configuration:\n\t- ").append(url).append("\n");
            fallback = ConfigFactory.load(classLoader, "sabot-default.conf");
            break;
        }
        Collection<URL> urls = ClassPathScanner.getConfigURLs();
        logString.append("\nIntermediate Configuration and Plugin files, in order of precedence:\n");
        for (URL url : urls) {
            logString.append("\t- ").append(url).append("\n");
            fallback = ConfigFactory.parseURL(url).withFallback(fallback);
        }
        logString.append("\n");
        URL overrideFileUrl = Thread.currentThread().getContextClassLoader().getResource(overrideFileResourcePathname);
        if (null != overrideFileUrl) {
            logString.append("Override File: ").append(overrideFileUrl).append("\n");
        }
        Config effectiveConfig = ConfigFactory.load(overrideFileResourcePathname).withFallback(fallback);
        if (overriderProps != null) {
            logString.append("Overridden Properties:\n");
            for (Map.Entry<Object, Object> entry : overriderProps.entrySet()) {
                logString.append("\t-").append(entry.getKey()).append(" = ").append(entry.getValue()).append("\n");
            }
            logString.append("\n");
            effectiveConfig = ConfigFactory.parseProperties(overriderProps).withFallback(effectiveConfig);
        }
        logger.info("Configuration and plugin file(s) identified in {}ms.\n{}", (Object)watch.elapsed(TimeUnit.MILLISECONDS), (Object)logString);
        return new SabotConfig(effectiveConfig.resolve(), enableServerConfigs);
    }

    public <T> Class<? extends T> getClassAt(String location, Class<T> clazz) throws SabotConfigurationException {
        Class<T> c = this.getClassAt(location, clazz, null);
        if (c != null) {
            return c;
        }
        throw new SabotConfigurationException(String.format("No class defined at location '%s'. Expected a definition of the class [%s]", location, clazz.getCanonicalName()));
    }

    public <T> Class<? extends T> getClassAt(String location, Class<T> clazz, Class<? extends T> defaultClazz) throws SabotConfigurationException {
        String className = this.getString(location);
        if (className == null) {
            return defaultClazz;
        }
        try {
            Class<?> c = Class.forName(className);
            if (clazz.isAssignableFrom(c)) {
                Class<?> t = c;
                return t;
            }
            throw new SabotConfigurationException(String.format("The class [%s] listed at location '%s' should be of type [%s].  It isn't.", className, location, clazz.getCanonicalName()));
        }
        catch (Exception ex) {
            if (ex instanceof SabotConfigurationException) {
                throw (SabotConfigurationException)ex;
            }
            throw new SabotConfigurationException(String.format("Failure while initializing class [%s] described at configuration value '%s'.", className, location), ex);
        }
    }

    public <T> T getInstanceOf(String location, Class<T> clazz) throws SabotConfigurationException {
        Class<T> c = this.getClassAt(location, clazz);
        try {
            T t = c.newInstance();
            return t;
        }
        catch (Exception ex) {
            throw new SabotConfigurationException(String.format("Failure while instantiating class [%s] located at '%s.", clazz.getCanonicalName(), location), ex);
        }
    }

    @Override
    public SabotConfig withValue(String path, ConfigValue value) {
        return new SabotConfig(this.getInnerConfig().withValue(path, value), this.startupArguments);
    }

    public String toString() {
        return this.root().render();
    }
}

