/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.concurrent;

import cdjd.com.dremio.common.concurrent.CloseableExecutorService;
import cdjd.com.dremio.common.tracing.TracingUtils;
import cdjd.com.dremio.context.RequestContext;
import cdjd.com.google.common.base.Preconditions;
import cdjd.io.opentracing.Scope;
import cdjd.io.opentracing.Span;
import cdjd.io.opentracing.Tracer;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

public class ContextMigratingExecutorService<E extends ExecutorService>
implements ExecutorService {
    public static final String WORK_OPERATION_NAME = "thread-pool-work";
    public static final String WAITING_OPERATION_NAME = "blocked-on-thread-pool";
    private final E delegate;
    private final Tracer tracer;

    public ContextMigratingExecutorService(E delegate, Tracer tracer) {
        this.delegate = delegate;
        this.tracer = tracer;
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit(this.decorate(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.delegate.submit(this.decorate(task), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.delegate.submit(this.decorate(task));
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(this.decorate(command));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        throw new UnsupportedOperationException("ContextMigrator does not support invoke methods.");
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException("ContextMigrator does not support invoke methods.");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException("ContextMigrator does not support invoke methods.");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException("ContextMigrator does not support invoke methods.");
    }

    private Span makeWaitingSpan() {
        return TracingUtils.buildChildSpan(this.tracer, WAITING_OPERATION_NAME, new String[0]);
    }

    <T> Callable<T> decorate(Callable<T> inner) {
        Span parentSpan = this.tracer.activeSpan();
        Span waitingSpan = this.makeWaitingSpan();
        RequestContext savedContext = RequestContext.current();
        return () -> {
            Span workSpan = ContextMigratingExecutorService.atTaskStart(waitingSpan, parentSpan, this.tracer);
            try {
                Scope s2 = this.tracer.activateSpan(workSpan);
                Throwable throwable = null;
                try {
                    Object v = savedContext.call(inner);
                    return v;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (s2 != null) {
                        ContextMigratingExecutorService.$closeResource(throwable, s2);
                    }
                }
                {
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                }
            }
            finally {
                workSpan.finish();
            }
        };
    }

    private static Span atTaskStart(Span waitingSpan, Span parentSpan, Tracer tracer) {
        Thread thisThread = Thread.currentThread();
        waitingSpan.finish();
        return TracingUtils.childSpanBuilder(tracer, parentSpan, WORK_OPERATION_NAME, "thread-group", thisThread.getThreadGroup().getName(), "thread-name", thisThread.getName()).asChildOf(parentSpan).start();
    }

    Runnable decorate(Runnable inner) {
        Span parentSpan = this.tracer.activeSpan();
        Span waitingSpan = this.makeWaitingSpan();
        Function<Runnable, Runnable> factory = inner instanceof Comparable ? runnable -> new ComparableRunnable(inner, (Runnable)runnable) : runnable -> runnable;
        RequestContext savedContext = RequestContext.current();
        return factory.apply(() -> {
            Span workSpan = ContextMigratingExecutorService.atTaskStart(waitingSpan, parentSpan, this.tracer);
            try {
                Scope s2 = this.tracer.activateSpan(workSpan);
                Throwable throwable = null;
                try {
                    savedContext.run(inner);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (s2 != null) {
                        ContextMigratingExecutorService.$closeResource(throwable, s2);
                    }
                }
            }
            finally {
                workSpan.finish();
            }
        });
    }

    public E getDelegate() {
        return this.delegate;
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    public static class ContextMigratingCloseableExecutorService<C extends AutoCloseable & ExecutorService>
    extends ContextMigratingExecutorService<C>
    implements CloseableExecutorService {
        private final C delegate;

        public ContextMigratingCloseableExecutorService(C delegate, Tracer tracer) {
            super(delegate, tracer);
            this.delegate = delegate;
        }

        @Override
        public void close() throws Exception {
            this.delegate.close();
        }
    }

    private static class ComparableRunnable
    implements Comparable<ComparableRunnable>,
    Runnable {
        private final Runnable comparableDelegate;
        private final Runnable work;

        ComparableRunnable(Runnable original, Runnable work) {
            Preconditions.checkArgument(original instanceof Comparable, "The delegate must be comparable");
            this.comparableDelegate = original;
            this.work = work;
        }

        @Override
        public int compareTo(ComparableRunnable o) {
            return ((Comparable)((Object)this.comparableDelegate)).compareTo(o.comparableDelegate);
        }

        @Override
        public void run() {
            this.work.run();
        }
    }
}

