/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.concurrent;

import cdjd.com.dremio.common.util.Closeable;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;

public class AutoCloseableLock
implements Closeable {
    private final boolean singleUse;
    private final AtomicBoolean closed = new AtomicBoolean(true);
    private final Lock lock;

    public AutoCloseableLock(Lock lock) {
        this(lock, false);
    }

    public AutoCloseableLock(Lock lock, boolean singleUse) {
        this.lock = lock;
        this.singleUse = singleUse;
    }

    public AutoCloseableLock open() {
        this.startOpen();
        this.lock.lock();
        return this;
    }

    private void startOpen() {
        if (this.singleUse && !this.closed.compareAndSet(true, false)) {
            throw new IllegalStateException("Trying to open an already opened lock. AutoCloseableLock allows only one lock count to be held at a time.");
        }
    }

    private boolean shouldClose() {
        return !this.singleUse || this.closed.compareAndSet(false, true);
    }

    public Optional<AutoCloseableLock> tryOpen(long time, TimeUnit unit) throws InterruptedException {
        this.startOpen();
        if (this.lock.tryLock(time, unit)) {
            return Optional.of(this);
        }
        this.shouldClose();
        return Optional.empty();
    }

    @Override
    public void close() {
        if (this.shouldClose()) {
            this.lock.unlock();
        }
    }

    public static AutoCloseableLock of(Lock lock, boolean singleUse) {
        return new AutoCloseableLock(lock, singleUse);
    }

    public static AutoCloseableLock ofAlreadyOpen(Lock lock, boolean singleUse) {
        AutoCloseableLock acl = new AutoCloseableLock(lock, singleUse);
        acl.startOpen();
        return acl;
    }

    public static AutoCloseableLock lockAndWrap(Lock lock, boolean singleUse) {
        lock.lock();
        return AutoCloseableLock.ofAlreadyOpen(lock, singleUse);
    }
}

