/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common;

import cdjd.com.dremio.service.Service;
import cdjd.com.google.common.annotations.VisibleForTesting;
import cdjd.com.google.common.base.Throwables;
import cdjd.com.google.inject.AbstractModule;
import cdjd.com.google.inject.Binding;
import cdjd.com.google.inject.Injector;
import cdjd.com.google.inject.Scope;
import cdjd.com.google.inject.internal.SingletonScope;
import cdjd.com.google.inject.matcher.Matchers;
import cdjd.com.google.inject.spi.BindingScopingVisitor;
import cdjd.com.google.inject.spi.DefaultBindingScopingVisitor;
import cdjd.com.google.inject.spi.ProvisionListener;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiceServiceModule
extends AbstractModule {
    private static final Logger logger = LoggerFactory.getLogger(GuiceServiceModule.class);
    private final Deque<Class<?>> serviceList = new ArrayDeque();

    protected void configure() {
        this.binder().bindListener(Matchers.any(), new ProvisionListener[]{new ProvisionListener(){

            public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provision) {
                Binding binding = provision.getBinding();
                logger.debug("provisioning {}", (Object)binding.getKey().getTypeLiteral());
                Object provisioned = provision.provision();
                if (provisioned != null && Service.class.isAssignableFrom(provisioned.getClass())) {
                    final AtomicBoolean start = new AtomicBoolean(false);
                    binding.acceptScopingVisitor((BindingScopingVisitor)new DefaultBindingScopingVisitor<T>(){

                        public T visitEagerSingleton() {
                            start.set(true);
                            return super.visitEagerSingleton();
                        }

                        public T visitScope(Scope scope) {
                            if (scope instanceof SingletonScope) {
                                start.set(true);
                            }
                            return super.visitScope(scope);
                        }
                    });
                    if (start.get()) {
                        GuiceServiceModule.this.serviceList.push(binding.getKey().getTypeLiteral().getRawType());
                        try {
                            logger.debug("starting {}", (Object)binding.getKey().getTypeLiteral());
                            ((Service)provisioned).start();
                        }
                        catch (Exception e) {
                            Throwables.throwIfUnchecked(e);
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
        }});
    }

    public void close(Injector injector) throws Exception {
        this.serviceList.forEach(clazz -> {
            Object instance = injector.getInstance(clazz);
            if (instance instanceof Service) {
                try {
                    logger.debug("stopping {}", (Object)instance.getClass().toString());
                    ((Service)instance).close();
                }
                catch (Exception e) {
                    Throwables.throwIfUnchecked(e);
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @VisibleForTesting
    protected List<Class> getServiceList() {
        return new ArrayList<Class>(this.serviceList);
    }
}

