/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.carrotsearch.hppc;

import cdjd.com.carrotsearch.hppc.BitMixer;
import cdjd.com.carrotsearch.hppc.Containers;

public class XorShift128P {
    private long state0;
    private long state1;

    public XorShift128P(long seed) {
        this.state0 = XorShift128P.notZero(BitMixer.mix64(seed));
        this.state1 = XorShift128P.notZero(BitMixer.mix64(seed + 1L));
    }

    public XorShift128P() {
        this(Containers.randomSeed64());
    }

    public long nextLong() {
        long s0;
        long s1 = this.state0;
        this.state0 = s0 = this.state1;
        s1 ^= s1 << 23;
        this.state1 = s1 ^ s0 ^ s1 >>> 17 ^ s0 >>> 26;
        return this.state1 + s0;
    }

    public int nextInt() {
        return (int)this.nextLong();
    }

    private static long notZero(long value) {
        return value == 0L ? 244837814090430L : value;
    }

    public int nextInt(int bound) {
        if (bound <= 0) {
            throw new IllegalArgumentException();
        }
        int r = this.nextInt() >>> 1;
        int m3 = bound - 1;
        if ((bound & m3) == 0) {
            r = (int)((long)bound * (long)r >> 31);
        } else {
            int u = r;
            while (u - (r = u % bound) + m3 < 0) {
                u = this.nextInt() >>> 1;
            }
        }
        return r;
    }
}

