/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.carrotsearch.hppc;

import cdjd.com.carrotsearch.hppc.DoubleCollection;
import cdjd.com.carrotsearch.hppc.DoubleLookupContainer;
import cdjd.com.carrotsearch.hppc.cursors.DoubleCursor;
import cdjd.com.carrotsearch.hppc.predicates.DoublePredicate;
import java.util.Arrays;

abstract class AbstractDoubleCollection
implements DoubleCollection {
    AbstractDoubleCollection() {
    }

    @Override
    public int removeAll(final DoubleLookupContainer c) {
        return this.removeAll(new DoublePredicate(){

            @Override
            public boolean apply(double k) {
                return c.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final DoubleLookupContainer c) {
        return this.removeAll(new DoublePredicate(){

            @Override
            public boolean apply(double k) {
                return !c.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final DoublePredicate predicate) {
        return this.removeAll(new DoublePredicate(){

            @Override
            public boolean apply(double value) {
                return !predicate.apply(value);
            }
        });
    }

    @Override
    public double[] toArray() {
        double[] array = new double[this.size()];
        int i = 0;
        for (DoubleCursor c : this) {
            array[i++] = c.value;
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

