"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateTestDistro = void 0;
const core_1 = require("@aws-solutions-constructs/core");
const cloudfront = require("@aws-cdk/aws-cloudfront");
const origins = require("@aws-cdk/aws-cloudfront-origins");
function CreateTestDistro(stack, id) {
    const newDistro = new cloudfront.Distribution(stack, id, {
        defaultBehavior: {
            origin: new origins.OriginGroup({
                primaryOrigin: new origins.HttpOrigin("www.example.com"),
                fallbackOrigin: new origins.HttpOrigin("admin.example.com"),
                // optional, defaults to: 500, 502, 503 and 504
                fallbackStatusCodes: [404],
            }),
        },
    });
    core_1.addCfnSuppressRules(newDistro, [{ id: "W10", reason: "Test Resource" }]);
    core_1.addCfnSuppressRules(newDistro, [{ id: "W70", reason: "Test Resource" }]);
    return newDistro;
}
exports.CreateTestDistro = CreateTestDistro;
//# sourceMappingURL=data:application/json;base64,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