"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ *
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const core_2 = require("@aws-solutions-constructs/core");
const test_helper_1 = require("./test-helper");
const app = new core_1.App();
const stack = new core_1.Stack(app, core_2.generateIntegStackName(__filename));
const newDistroOne = test_helper_1.CreateTestDistro(stack, "distroOne");
const newDistroTwo = test_helper_1.CreateTestDistro(stack, "distroTwo");
const ownsWaf = new lib_1.WafwebaclToCloudFront(stack, 'first-construct', {
    existingCloudFrontWebDistribution: newDistroOne,
});
new lib_1.WafwebaclToCloudFront(stack, 'second-construct', {
    existingCloudFrontWebDistribution: newDistroTwo,
    existingWebaclObj: ownsWaf.webacl
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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