import numpy as np


def _swiss_roll_sample_data():
    matrix = np.array([[-0.4894, 1.5333, 7.9007],
                       [-2.9166, 10.143, 7.6818],
                       [8.3068, 3.5432, -8.3503],
                       [7.3161, 6.1689, -9.0958],
                       [0.06178, 5.7664, 7.8459],
                       [9.7424, 6.1378, -6.9183],
                       [4.1468, 19.766, 5.9403],
                       [6.3269, 8.5837, 1.6477],
                       [1.8535, 8.7667, -4.7356],
                       [-4.4986, 9.7833, 7.1149],
                       [7.64, 6.5697, -8.8699],
                       [6.4255, 18.089, -9.6381],
                       [5.6093, 11.613, -1.9705],
                       [2.1547, 1.6845, -10.98],
                       [4.339, 7.4109, 5.7557],
                       [-2.4323, 7.0107, 7.7857],
                       [4.2081, 17.659, 13.172],
                       [0.15113, 6.3757, -4.7418],
                       [-6.4082, 7.0026, 5.8606],
                       [9.5397, 16.775, -7.1522],
                       [0.071027, 12.611, 7.8446],
                       [0.43318, 2.0673, -4.7831],
                       [11.607, 15.654, 5.941],
                       [10.838, 7.2692, 7.4835],
                       [3.7714, 5.6765, -3.9657],
                       [8.1416, 5.0093, -8.4864],
                       [0.8358, 17.775, -4.8123],
                       [3.7779, 11.878, -3.9614],
                       [3.6971, 4.9007, 6.3234],
                       [1.1084, 5.7283, -11.04],
                       [0.96994, 18.712, 7.667],
                       [1.944, 10.764, -4.7184],
                       [0.18419, 16.942, -11.011],
                       [6.3545, 14.701, 0.70116],
                       [6.2522, 8.6363, 12.147],
                       [4.3804, 11.904, -3.5028],
                       [9.9852, 17.292, -6.621],
                       [-6.727, 10.779, 5.5693],
                       [-4.0201, 4.3006, 7.3253],
                       [5.9784, 0.64796, 3.1816],
                       [3.2128, 12.393, 6.672],
                       [3.5458, 4.3578, 6.4389],
                       [4.5631, 12.761, -3.3352],
                       [-3.2792, 2.132, 7.5835],
                       [6.5724, 5.0027, -9.5561],
                       [-5.8869, 17.575, 6.2792],
                       [5.3571, 19.2, 4.4728],
                       [2.9265, 3.6838, -4.416],
                       [4.8232, 19.478, -3.0686],
                       [-3.1915, 18.689, 7.6089],
                       [6.0376, 20.658, 12.276],
                       [4.0847, 14.566, -3.7444],
                       [10.329, 15.354, 8.2874],
                       [4.8071, 15.07, 5.241],
                       [2.4538, 10.004, 7.1101],
                       [5.9294, 14.991, -1.2923],
                       [5.2833, 2.3383, -2.4936],
                       [5.165, 17.111, -2.6565],
                       [1.5583, 10.129, -4.7799],
                       [2.8162, 14.355, -4.4609],
                       [10.208, 18.764, -6.3298],
                       [10.768, 0.20263, 7.6015],
                       [6.3299, 6.3541, 1.6185],
                       [1.6705, 11.497, 7.4483],
                       [5.6702, 12.984, 3.9084],
                       [0.5813, 11.235, -4.7979],
                       [4.8985, 0.44878, -2.9844],
                       [-2.0226, 0.39014, 7.8498],
                       [12.449, 17.27, 2.9859],
                       [6.1578, 9.8884, -0.59663],
                       [0.73289, 16.176, 7.7247],
                       [10.751, 6.7072, 7.6312],
                       [8.4163, 7.6502, -8.2572],
                       [5.5535, 3.5126, -10.07],
                       [5.6866, 7.6838, -1.8258],
                       [10.299, 18.088, -6.2053],
                       [1.2903, 20.203, 13.986],
                       [0.71278, 0.36885, -4.807],
                       [5.8743, 8.0215, -1.4263],
                       [-0.70893, 11.704, 7.9117],
                       [3.1717, 11.958, -4.3052],
                       [3.7271, 10.636, 6.2998],
                       [1.5628, 13.6, -4.7794],
                       [12.314, 4.0817, -1.692],
                       [10.221, 9.9819, -6.3122],
                       [5.6237, 2.0822, -1.9443],
                       [5.3561, 19.972, -2.387],
                       [-0.46948, 7.7173, 7.8994],
                       [-4.2316, 17.994, 7.2367],
                       [4.2275, 20.561, 5.8645],
                       [1.6736, 6.4506, -4.7648],
                       [-3.6761, 17.593, 7.455],
                       [2.8364, 18.238, 6.9042],
                       [0.9942, 7.048, -4.8144],
                       [3.6489, 6.3273, 6.3609],
                       [5.4321, 10.907, 4.3485],
                       [6.3603, 5.4713, 1.0853],
                       [10.335, 19.759, -6.156],
                       [12.606, 16.963, 1.0447],
                       [5.8879, 20.704, 3.4208],
                       [0.70145, 2.1682, 7.7318],
                       [5.5976, 1.809, -1.9917],
                       [8.3982, 19.284, 10.523],
                       [-2.5743, 1.2849, 7.7584],
                       [5.3322, 18.47, -2.4226],
                       [6.1911, 10.321, -0.46372],
                       [12.227, 7.1697, 4.0766],
                       [6.27, 19.881, 2.0655],
                       [4.8726, 13.64, 5.1603],
                       [3.8244, 20.534, -10.675],
                       [5.8386, 18.312, 3.5406],
                       [12.37, 17.245, -1.4233],
                       [6.3091, 16.394, 0.17962],
                       [9.0857, 18.548, 9.8378],
                       [10.296, 0.66298, -6.2095],
                       [9.1525, 20.625, 9.7656],
                       [5.8209, 18.444, 3.5823],
                       [-7.3337, 13.603, 4.9241],
                       [0.22025, 19.924, 14.12],
                       [2.4149, 9.074, -4.6005],
                       [3.1284, 19.135, 6.7268],
                       [6.205, 20.646, -0.4043],
                       [9.1196, 9.2605, 9.8013],
                       [4.9859, 5.2449, -2.8822],
                       [3.4078, 13.219, -4.1837],
                       [-5.084, 11.265, 6.8064],
                       [2.8772, 19.363, -4.4364],
                       [3.1386, 3.6886, -4.321],
                       [1.0288, 16.989, 14.026],
                       [6.3519, 12.307, 1.3283],
                       [6.0724, 5.9454, 12.255],
                       [-6.2501, 2.0323, 5.9946],
                       [5.2117, 11.168, -2.5937],
                       [3.9238, 2.8904, 6.1382],
                       [2.5926, 16.113, -4.5433],
                       [1.0388, 0.97384, -4.8141],
                       [7.7505, 17.321, 11.086],
                       [5.498, 17.528, -10.094],
                       [2.2442, 3.6641, -4.6488],
                       [12.377, 16.553, 3.3934],
                       [2.3676, 6.4539, -4.6145],
                       [12.148, 19.562, -2.3564],
                       [1.8068, 18.496, 7.3969],
                       [11.899, 4.303, 5.1778],
                       [-8.0613, 16.812, 3.9355],
                       [-0.4646, 17.849, 7.8991],
                       [-4.6098, 9.8869, 7.0608],
                       [-4.2434, 18.152, 7.2316],
                       [4.3078, 4.6367, -3.5653],
                       [-4.4673, 2.9429, 7.1298],
                       [10.951, 3.0432, 7.2862],
                       [6.2133, 6.9484, -0.36716],
                       [2.7576, 17.444, 6.9491],
                       [12.59, 15.336, 0.37147],
                       [10.958, 0.7353, -5.1887],
                       [8.9402, 16.744, 9.9914],
                       [6.11, 15.899, 2.771],
                       [-1.7236, 14.558, 7.883],
                       [8.1487, 4.0901, 10.749],
                       [-7.0794, 13.961, 5.2106],
                       [2.2124, 8.1649, -10.974],
                       [11.409, 3.215, -4.3318],
                       [12.253, 1.1072, 3.9673],
                       [-7.7386, 14.539, 4.4097],
                       [5.4779, 1.4353, -10.103],
                       [6.2762, 2.774, -0.043164],
                       [4.0772, 2.3363, 6.0039],
                       [6.2019, 18.806, 2.4107],
                       [-8.0915, 6.0922, 3.8875],
                       [0.63514, 0.41641, -11.035],
                       [4.3499, 6.4021, 5.7449],
                       [0.80077, 19.091, -4.8111],
                       [-5.0498, 18.211, 6.8261],
                       [11.488, 17.52, 6.2175],
                       [10.04, 18.428, 8.6929],
                       [1.383, 8.8159, 7.5471],
                       [3.6314, 3.0923, 6.3743],
                       [12.39, 4.7369, 3.3284],
                       [12.591, 6.4556, 1.6091],
                       [12.398, 16.028, -1.2756],
                       [2.0706, 0.42733, 13.834],
                       [4.9742, 17.431, 5.03],
                       [8.299, 20.827, -8.3568],
                       [1.7721, 20.565, 7.4103],
                       [0.9729, 12.713, -4.8145],
                       [3.853, 12.16, 6.1977],
                       [1.132, 7.5496, 14.011],
                       [-3.4416, 18.318, 7.5336],
                       [1.0518, 17.303, 14.023],
                       [4.4824, 5.7919, 5.6086],
                       [5.237, 1.404, -10.204],
                       [5.2634, 0.23722, -10.194],
                       [7.1198, 17.639, -9.2249],
                       [4.9577, 2.0387, -2.9157],
                       [5.7273, 10.594, -1.7455],
                       [-1.8856, 17.414, 7.8664],
                       [-6.814, 9.2056, 5.4845],
                       [11.49, 1.1386, -4.1585],
                       [2.5466, 4.6381, 7.0628],
                       [4.0574, 4.0489, -3.765],
                       [11.248, 3.9863, -4.6565],
                       [2.5238, 20.273, -4.5663],
                       [2.0912, 7.9602, 7.2798],
                       [2.588, 15.364, -4.5448],
                       [4.1675, 2.57, 5.9211],
                       [2.123, 12.839, 7.2659],
                       [6.6059, 16.396, -9.537],
                       [-4.9288, 6.4689, 6.894],
                       [5.4323, 18.611, -2.2697],
                       [-6.6112, 2.7572, 5.6785],
                       [5.2269, 4.4776, 12.715],
                       [5.2128, 19.02, 4.6967],
                       [8.9183, 8.8767, -7.7996],
                       [2.177, 1.6967, -10.978],
                       [5.4466, 3.6047, -2.2469],
                       [1.8919, 16.948, -11.004],
                       [-6.248, 0.24221, 5.9964],
                       [-1.3159, 4.1481, 7.9101],
                       [6.2259, 14.934, 2.2997],
                       [6.3155, 10.536, 1.7502],
                       [6.1739, 17.308, 2.5296],
                       [5.2475, 3.5067, -2.5443],
                       [4.706, 6.2773, 12.961],
                       [11.563, 20.415, 6.045],
                       [7.5294, 18.046, -8.9488],
                       [9.0694, 15.147, -7.6511],
                       [4.252, 16.779, 5.841],
                       [0.73879, 16.895, 7.7234],
                       [4.5986, 7.3489, 13.008],
                       [0.19583, 0.4575, 7.8265],
                       [12.6, 4.9883, 1.3967],
                       [-7.6947, 7.6332, 4.4695],
                       [8.1794, 8.8728, 10.722],
                       [6.2094, 13.332, -0.38487],
                       [0.43746, 17.785, -4.7836],
                       [12.594, 18.3, 0.44087],
                       [-0.75914, 19.915, 7.9133],
                       [5.4688, 18.729, -2.2113],
                       [6.0909, 15.055, 2.8368],
                       [-6.0304, 1.4473, 6.1705],
                       [-6.1455, 16.297, 6.0799],
                       [4.6721, 6.5814, -10.417],
                       [9.2297, 7.4876, 9.6809],
                       [0.22519, 5.3964, 7.822],
                       [5.4685, 8.2515, -10.107],
                       [6.0217, 20.507, 3.0561],
                       [1.1096, 6.9806, 7.6293],
                       [6.262, 11.703, -0.12507],
                       [6.3347, 16.168, 1.5675],
                       [6.3365, 6.05, 0.43103],
                       [6.0721, 10.136, 2.899],
                       [12.564, 19.977, 2.0301],
                       [0.79173, 19.065, 7.7111],
                       [-7.507, 17.816, 4.7135],
                       [11.491, 16.085, -4.1553],
                       [7.9345, 2.7922, 10.934],
                       [-7.4518, 13.885, 4.7821],
                       [6.2012, 12.512, -0.42082],
                       [11.628, 9.0603, -3.8441],
                       [5.6886, 15.215, 3.8709],
                       [1.3924, 20.175, -4.7969],
                       [7.4131, 1.2964, -9.0298],
                       [0.44357, 5.7527, 7.7844],
                       [4.2565, 11.91, -3.6082],
                       [5.6256, 16.24, 3.9969],
                       [2.7235, 4.8009, -4.4965],
                       [-7.8833, 4.479, 4.2052],
                       [3.137, 20.425, -4.3218],
                       [3.2094, 6.2327, 13.529],
                       [1.9993, 14.404, 7.3192],
                       [6.1662, 7.7889, 2.561],
                       [11.354, 7.9845, -4.4454],
                       [6.0476, 6.9192, 2.9771],
                       [1.1869, 5.3616, -11.039],
                       [4.7354, 18.175, -3.1626],
                       [2.8918, 1.5953, -10.878],
                       [12.078, 18.17, -2.5987],
                       [4.3843, 17.567, 13.1],
                       [12.517, 9.8124, -0.49361],
                       [11.718, 16.202, 5.6679],
                       [9.2226, 3.626, 9.6888],
                       [4.4725, 20.239, -3.4202],
                       [4.2558, 18.492, -3.6088],
                       [5.5219, 0.45461, -2.1233],
                       [2.848, 6.2755, 13.637],
                       [1.1763, 11.409, 7.6103],
                       [2.1425, 0.73196, 7.2572],
                       [-0.25542, 7.6869, 7.8822],
                       [12.295, 7.0557, 3.7858],
                       [5.8964, 5.2836, 3.3996],
                       [-3.571, 11.843, 7.4912],
                       [6.0258, 16.935, 3.0438],
                       [-7.5997, 19.55, 4.5952],
                       [9.4325, 19.027, -7.2711],
                       [6.1107, 12.074, -0.76569],
                       [11.368, 19.882, 6.4788],
                       [4.831, 0.86435, 12.904],
                       [6.5162, 15.163, 11.982],
                       [-4.6264, 13.329, 7.0526],
                       [10.616, 4.1643, -5.7445],
                       [9.3408, 18.661, -7.3702],
                       [-4.2124, 1.519, 7.245],
                       [-0.87008, 19.745, 7.9158],
                       [11.808, 6.6202, -3.3959],
                       [3.3121, 11.785, -4.2347],
                       [11.395, 5.1768, -4.361],
                       [7.9001, 7.3012, -8.6764],
                       [9.1536, 2.0867, -7.5659],
                       [10.174, 5.9251, -6.376],
                       [11.835, 17.519, -3.3223],
                       [5.0303, 16.08, 4.9553],
                       [10.98, 1.9908, 7.2335],
                       [2.478, 1.9783, -4.581],
                       [8.7558, 17.237, -7.9536],
                       [10.839, 3.0558, 7.482],
                       [3.9495, 18.206, -3.844],
                       [0.77416, 2.0079, -4.8101],
                       [6.2888, 8.1465, 1.9477],
                       [-3.0993, 16.158, 7.6345],
                       [6.1809, 6.1933, -9.7685],
                       [2.5029, 3.2111, 13.731],
                       [-4.1575, 19.961, 7.2685],
                       [5.3843, 11.469, -2.3443],
                       [12.115, 17.661, 4.4922],
                       [11.275, 17.441, -4.6033],
                       [12.528, 8.2168, 2.4028],
                       [12.491, 5.5242, -0.70147],
                       [2.1243, 16.246, 13.822],
                       [0.65748, 17.497, 7.7414],
                       [5.1368, 5.6556, 4.8074],
                       [6.349, 15.695, 1.379],
                       [0.98597, 12.94, -4.8145],
                       [4.274, 8.5376, 5.8197],
                       [4.2818, 13.757, 5.8122],
                       [9.4743, 9.5961, 9.4024],
                       [0.19028, 2.1718, 14.122],
                       [1.2818, 3.3683, -4.805],
                       [6.1411, 6.9676, -0.65888],
                       [-1.329, 16.209, 7.9096],
                       [4.6188, 15.277, -3.281],
                       [-1.7135, 17.676, 7.8839],
                       [6.0276, 17.14, -1.0269],
                       [6.5333, 1.9658, -9.5781],
                       [4.2555, 19.35, 5.8376],
                       [12.387, 19.509, 3.3411],
                       [2.7711, 17.583, -10.898],
                       [9.0897, 6.7878, -7.6307],
                       [4.5118, 6.1066, -3.3838],
                       [7.7072, 17.856, -8.821],
                       [10.761, 20.557, 7.613],
                       [4.6112, 11.153, -3.2885],
                       [2.1442, 11.59, 7.2565],
                       [5.4548, 11.268, -2.234],
                       [6.3482, 4.9449, 1.3918],
                       [-6.5489, 9.4794, 5.7356],
                       [5.6778, 5.1138, 12.479],
                       [5.7219, 17.966, -1.7562],
                       [2.2414, 4.0457, -4.6495],
                       [6.3141, 18.777, 1.762],
                       [-6.567, 2.8184, 5.7192],
                       [8.344, 7.4955, 10.573],
                       [-3.5775, 2.853, 7.489],
                       [2.7695, 11.785, -4.4791],
                       [6.9885, 17.942, -9.3081],
                       [12.496, 16.572, 2.6575],
                       [4.6259, 3.1535, -3.274],
                       [2.157, 3.6951, 7.2508],
                       [7.5868, 9.7322, 11.218],
                       [-6.2989, 0.92774, 5.954],
                       [1.1747, 17.72, -4.8105],
                       [5.5175, 11.238, 4.1993],
                       [8.2523, 19.368, -8.3957],
                       [10.99, 15.367, 7.217],
                       [6.5879, 8.26, -9.5472],
                       [3.1054, 12.896, 6.7415],
                       [5.7501, 18.819, 3.741],
                       [0.27748, 12.066, 7.8136],
                       [0.56783, 7.1381, -11.032],
                       [3.4501, 18.474, -10.766],
                       [3.4012, 15.613, -10.777],
                       [10.524, 19.313, 7.9947],
                       [4.3534, 19.688, 5.7414],
                       [2.3172, 2.926, -10.962],
                       [12.01, 9.6338, 4.8434],
                       [-4.1655, 15.618, 7.2651],
                       [3.2293, 10.468, -4.2769],
                       [4.1407, 16.97, 5.946],
                       [10.275, 9.25, -6.238],
                       [2.9727, 6.5528, 6.8237],
                       [11.074, 17.292, -4.9823],
                       [2.9135, 6.913, 6.8592],
                       [-6.3851, 19.041, 5.8806],
                       [-7.8311, 1.208, 4.2803],
                       [-1.6546, 14.267, 7.8891],
                       [3.748, 14.867, 6.2832],
                       [5.9262, 19.927, 12.34],
                       [1.2977, 20.102, 7.5739],
                       [4.6531, 17.132, 5.4218],
                       [2.2635, 18.142, -4.6437],
                       [2.6436, 3.5187, 7.0116],
                       [5.0837, 6.868, -2.7619],
                       [7.8986, 16.234, -8.6775],
                       [4.3934, 0.72573, 5.7009],
                       [12.606, 0.80732, 0.94792],
                       [9.1339, 20.92, -7.586],
                       [4.7761, 4.6232, 5.2785],
                       [4.4052, 9.5656, -3.4808],
                       [5.1946, 5.7283, -10.222],
                       [11.55, 19.588, 6.0756],
                       [-2.5473, 18.18, 7.7638],
                       [6.263, 2.0547, -0.1193],
                       [6.3571, 2.8101, 0.766],
                       [-7.4666, 14.139, 4.7638],
                       [-0.22858, 8.7176, 7.8797],
                       [0.68047, 10.714, 7.7364],
                       [4.4723, 0.10028, -3.4203],
                       [2.1093, 0.25906, -4.6825],
                       [1.7751, 18.866, -4.7492],
                       [-3.5968, 20.198, 7.4825],
                       [7.6991, 8.0365, 11.128],
                       [0.77481, 12.128, -4.8101],
                       [1.4767, 17.145, 7.5163],
                       [0.15937, 3.4223, 7.832],
                       [-0.49017, 11.476, 7.9008],
                       [10.918, 0.65067, -5.256],
                       [5.7477, 12.503, 3.7462],
                       [2.9608, 18.689, -4.4014],
                       [2.7628, 5.5002, -4.4817],
                       [2.814, 3.8296, -4.4618],
                       [3.1318, 19.242, 13.553],
                       [2.23, 4.549, -4.6525],
                       [-8.0974, 19.837, 3.878],
                       [12.577, 17.625, 0.14815],
                       [6.3607, 20.317, 0.92152],
                       [-5.7972, 20.758, 6.3447],
                       [10.637, 7.7373, 7.8159],
                       [-4.5515, 11.023, 7.0894],
                       [0.52241, 3.2175, 7.7693],
                       [3.7898, 1.8435, 6.2496],
                       [-1.9624, 5.1891, 7.8574],
                       [-7.6871, 15.07, 4.4796],
                       [-3.9442, 20.453, 7.3554],
                       [-3.1317, 12.313, 7.6257],
                       [6.2391, 3.2303, -0.24516],
                       [0.60741, 12.592, -4.8],
                       [0.91298, 0.48576, -4.814],
                       [-7.325, 15.736, 4.9343],
                       [2.4774, 14.025, -4.5812],
                       [12.481, 0.18157, 2.7678],
                       [4.7583, 6.9688, 5.2997],
                       [4.2713, 12.826, 5.8223],
                       [12.427, 16.998, 3.1205],
                       [-7.3076, 18.594, 4.9547],
                       [10.733, 15.214, 7.6608],
                       [4.918, 3.4711, -2.962],
                       [0.64882, 4.8065, -4.803],
                       [-5.3431, 4.1914, 6.6503],
                       [0.40099, 1.3071, 14.103],
                       [0.0065786, 18.707, 14.137],
                       [2.533, 15.342, 7.0699],
                       [12.6, 4.0696, 1.3761],
                       [1.218, 7.854, -4.8086],
                       [0.59356, 5.9909, -4.7989],
                       [0.74029, 2.2199, -11.038],
                       [12.519, 16.731, 2.4811],
                       [5.6533, 1.0018, 3.9423],
                       [1.3583, 5.8962, 7.555],
                       [1.4374, 4.9997, -4.7929],
                       [2.1741, 18.552, -4.6668],
                       [2.5306, 15.317, -4.564],
                       [12.189, 6.0591, 4.2226],
                       [-0.077672, 12.723, 7.8635],
                       [-6.5314, 16.218, 5.7515],
                       [0.12879, 19.921, -4.7378],
                       [-5.657, 5.3597, 6.4436],
                       [2.8583, 8.7121, -10.883],
                       [-6.7852, 0.52536, 5.5129],
                       [5.8921, 9.8503, 3.4103],
                       [0.87679, 10.566, 7.6906],
                       [-3.6752, 8.4921, 7.4553],
                       [5.4998, 11.889, 4.231],
                       [6.2699, 15.845, -0.08008],
                       [5.8452, 14.134, -1.4937],
                       [6.1589, 17.803, -0.59234],
                       [12.364, 5.9245, 3.4601],
                       [6.2982, 16.065, 1.8835],
                       [-2.3387, 3.5152, 7.8022],
                       [0.20356, 16.109, -4.7509],
                       [12.495, 20.176, 2.6711],
                       [12.585, 4.9963, 1.7286],
                       [3.9585, 16.843, -3.8375],
                       [-3.5048, 8.1875, 7.5132],
                       [3.7608, 3.0769, 13.343],
                       [-7.4092, 10.621, 4.834],
                       [12.115, 19.857, -2.4751],
                       [10.923, 18.924, 7.3364],
                       [12.529, 8.7609, -0.38963],
                       [9.7137, 6.7441, -6.9521],
                       [0.60443, 2.0896, -4.7998],
                       [-1.1356, 9.0511, 7.9154],
                       [6.0663, 6.6106, 2.9176],
                       [0.15761, 9.1151, 7.8323],
                       [6.2747, 8.4288, 2.037],
                       [12.353, 8.2899, 3.5183],
                       [5.3086, 3.4164, -10.175],
                       [0.21574, 8.7679, 7.8234],
                       [-7.0617, 13.693, 5.2297],
                       [6.2168, 13.056, 2.3426],
                       [6.3504, 14.881, 1.3558],
                       [0.48872, 5.3143, -4.7892],
                       [3.5156, 6.7584, 6.4612],
                       [-5.1146, 13.593, 6.7886],
                       [5.2246, 20.62, -10.209],
                       [12.558, 16.413, 2.091],
                       [-7.7541, 8.2711, 4.3884],
                       [4.8654, 9.613, -10.348],
                       [1.7501, 16.508, 13.902],
                       [6.3365, 8.5751, 0.431],
                       [1.8806, 5.8985, -11.005],
                       [6.2912, 2.8751, 0.051616],
                       [6.0335, 0.25005, -1.0096],
                       [5.8977, 0.76069, -1.3706],
                       [4.2805, 7.4096, -3.5883],
                       [9.3868, 16.876, 9.5038],
                       [12.529, 9.1475, 2.3854],
                       [-1.7968, 3.0279, 7.8759],
                       [4.2567, 6.5506, -3.608],
                       [0.08299, 2.6568, 7.843],
                       [3.1759, 17.634, -4.3031],
                       [4.0891, 9.3701, -3.7411],
                       [5.8411, 2.0719, -9.9374],
                       [-5.7189, 19.789, 6.4005],
                       [4.0676, 5.7773, 6.0125],
                       [5.9159, 17.731, -9.9015],
                       [12.185, 18.463, 4.2375],
                       [6.3491, 13.125, 0.6004],
                       [-4.6904, 9.6943, 7.0203],
                       [-5.1552, 14.547, 6.7647],
                       [6.3414, 10.835, 0.49001],
                       [-6.0477, 7.2476, 6.157],
                       [0.20539, 11.674, -4.7512],
                       [-7.0214, 7.5766, 5.2726],
                       [7.1168, 3.5536, -9.2268],
                       [4.5864, 13.655, -3.3127],
                       [3.9142, 7.0929, -3.8689],
                       [5.7097, 14.268, 3.8271],
                       [-8.092, 19.387, 3.8866],
                       [6.1847, 1.8211, 2.4847],
                       [4.8358, 10.744, -3.0547],
                       [4, 12.531, -3.8075],
                       [0.93917, 15.529, 14.039],
                       [-7.5231, 3.66, 4.6933],
                       [4.8295, 11.607, 5.2138],
                       [-3.9873, 0.49224, 7.3384],
                       [10.415, 7.9286, -6.042],
                       [4.668, 20.123, -10.419],
                       [9.1542, 8.8258, -7.5652],
                       [6.3406, 7.6233, 0.48042],
                       [2.4712, 3.6627, 7.1014],
                       [12.359, 8.4504, 3.4881],
                       [2.1118, 2.6542, -10.984],
                       [5.1612, 9.0122, -2.6616],
                       [-2.2037, 11.499, 7.8241],
                       [-5.3502, 10.652, 6.6458],
                       [6.3374, 6.3101, 1.5367],
                       [6.7146, 6.5507, 11.852],
                       [10.511, 0.91519, 8.015],
                       [-6.573, 14.763, 5.7136],
                       [0.37639, 14.858, -4.7762],
                       [2.3172, 12.278, -4.6289],
                       [0.58045, 12.205, -4.7978],
                       [1.212, 6.4588, -4.8089],
                       [-7.038, 7.2117, 5.255],
                       [4.882, 16.562, 12.881],
                       [12.041, 5.4629, 4.7428],
                       [7.52, 9.5521, 11.27],
                       [0.57403, 19.219, -4.7973],
                       [3.4789, 16.588, 6.4879],
                       [3.5503, 13.264, -4.1029],
                       [4.3098, 18.885, -3.5636],
                       [4.8904, 15.051, -2.9936],
                       [6.324, 17.315, 0.30483],
                       [1.7745, 14.397, 7.4094],
                       [-0.49449, 15.298, 7.901],
                       [12.578, 15.67, 1.8306],
                       [5.9249, 11.169, 3.3263],
                       [12.211, 0.86252, -2.1231],
                       [6.2915, 9.6861, 0.053652],
                       [-2.0054, 14.3, 7.852],
                       [5.206, 17.254, -2.6014],
                       [4.2986, 19.819, 5.7957],
                       [8.0587, 2.3537, -8.5527],
                       [-0.097457, 15.329, 7.8658],
                       [-1.2772, 6.3976, 7.9116],
                       [-2.3607, 14.462, 7.7985],
                       [6.4394, 8.0052, -9.6304],
                       [2.738, 19.808, -4.4911],
                       [2.1761, 18.326, 13.81],
                       [3.4103, 20.921, -4.1823],
                       [-4.5857, 4.8229, 7.0727],
                       [7.5359, 3.1, -8.9443],
                       [2.9547, 8.1465, -10.867],
                       [0.53623, 1.5992, -4.7939],
                       [-4.9332, 1.5702, 6.8915],
                       [1.7253, 19.073, 7.428],
                       [0.19539, 3.0237, 14.122],
                       [12.238, 2.0317, -2.0177],
                       [4.2528, 16.612, 13.154],
                       [-0.45465, 6.6325, 7.8984],
                       [11.632, 6.0484, 5.8814],
                       [-3.0194, 7.9373, 7.6557],
                       [6.3601, 7.5231, 1.0934],
                       [4.855, 13.707, 5.1822],
                       [6.613, 19.494, -9.5329],
                       [12.427, 8.9769, -1.1175],
                       [11.286, 8.7863, -4.5826],
                       [-1.6279, 10.52, 7.8913],
                       [5.9646, 18.331, -1.2014],
                       [6.1192, 19.556, -0.73649],
                       [-2.1206, 9.5968, 7.8364],
                       [-6.8515, 7.3383, 5.4473],
                       [4.0375, 13.31, -3.7799],
                       [9.6949, 3.5341, -6.9741],
                       [8.3275, 4.6085, 10.588],
                       [5.8479, 5.9486, 3.5185],
                       [2.1453, 9.4845, -10.981],
                       [3.4469, 15.699, 6.511],
                       [12.335, 4.788, 3.6021],
                       [3.6588, 1.3868, 6.3532],
                       [5.1154, 17.029, -10.253],
                       [5.8019, 7.2639, 3.6261],
                       [-5.7968, 8.9504, 6.345],
                       [3.6202, 10.324, 6.3829],
                       [-0.37448, 18.311, 7.8925],
                       [3.0859, 10.12, -4.3456],
                       [5.4406, 1.0438, 4.334],
                       [5.8428, 12.394, -1.4992],
                       [11.836, 19.705, -3.3199],
                       [0.49045, 0.11207, -11.029],
                       [-6.2053, 20.224, 6.0315],
                       [-2.025, 17.39, 7.8495],
                       [5.0755, 15.854, -2.7722],
                       [4.1321, 15.787, -3.7079],
                       [6.3507, 3.7793, 1.3504],
                       [9.293, 6.4704, 9.6104],
                       [10.254, 19.669, -6.2671],
                       [12.577, 5.7876, 1.855],
                       [0.46916, 17.999, 14.096],
                       [2.4385, 2.7805, -4.5933],
                       [0.94101, 12.785, -4.8143],
                       [12.027, 15.197, -2.7633],
                       [12.606, 18.179, 0.95821],
                       [9.7726, 6.0943, -6.8823],
                       [12.451, 20.96, 2.9736],
                       [-4.5974, 10.388, 7.0669],
                       [5.2818, 17.476, -2.4957],
                       [-7.6998, 15.503, 4.4625],
                       [5.9559, 10.64, 3.2437],
                       [5.284, 20.348, -2.4926],
                       [3.1812, 1.1739, -4.3006],
                       [-3.5043, 15.6, 7.5134],
                       [6.2735, 1.9412, -0.058927],
                       [0.048243, 10.1, -4.7224],
                       [3.3849, 8.8739, 6.5549],
                       [1.952, 12.234, 7.3389],
                       [-4.1413, 2.2902, 7.2754],
                       [3.6381, 2.8034, 6.3692],
                       [5.9871, 7.1033, -1.1411],
                       [-3.7603, 12.366, 7.4249],
                       [6.2078, 13.216, 2.3841],
                       [1.7805, 5.8999, -4.7483],
                       [10.742, 3.2725, 7.6451],
                       [2.3955, 10.992, -4.6063],
                       [2.8333, 5.4455, 6.906],
                       [2.9419, 1.6719, -4.4094],
                       [4.36, 0.95721, -3.5205],
                       [5.2641, 1.5652, 12.696],
                       [9.5774, 6.1428, -7.1095],
                       [4.2267, 0.086482, -3.6326],
                       [-5.4898, 11.427, 6.5561],
                       [1.3457, 7.8235, -4.8006],
                       [5.5297, 9.8038, -2.1101],
                       [1.4744, 17.175, -4.7892],
                       [5.8311, 1.7473, 3.5584],
                       [5.7582, 1.413, -1.6824],
                       [9.2142, 17.125, -7.5035],
                       [2.2159, 5.2728, -4.6562],
                       [6.1374, 4.8689, 2.6719],
                       [3.2567, 7.7637, 13.514],
                       [4.1375, 0.25101, 5.9489],
                       [-3.9769, 8.1124, 7.3425],
                       [2.8547, 16.992, -4.4456],
                       [6.2034, 16.336, 2.404],
                       [12.603, 8.1972, 1.2518],
                       [5.8545, 4.9857, -1.4723],
                       [1.8553, 16.219, 13.881],
                       [0.53016, 8.8352, -11.031],
                       [11.155, 0.58001, 6.9073],
                       [5.2124, 7.6534, 4.6973],
                       [-6.6234, 10.318, 5.6672],
                       [-3.9887, 6.0182, 7.3379],
                       [10.743, 9.9521, 7.6436],
                       [12.602, 9.4204, 1.3271],
                       [4.4109, 10.317, -3.4758],
                       [-0.75925, 4.6708, 7.9133],
                       [-7.7148, 7.1586, 4.4422],
                       [4.5133, 14.383, -3.3823],
                       [-7.1743, 1.9776, 5.1067],
                       [1.1843, 4.2748, -11.039],
                       [6.3429, 20.373, 1.4684],
                       [1.7367, 8.6016, 13.905],
                       [6.8846, 4.7543, 11.736],
                       [0.94254, 13.01, 7.6741],
                       [3.6592, 18.02, -4.0372],
                       [0.59293, 18.859, -4.7988],
                       [4.0333, 3.0516, 6.0432],
                       [6.3438, 12.167, 1.4574],
                       [2.2654, 20.82, 13.79],
                       [-5.6907, 7.6198, 6.4202],
                       [8.6779, 7.3809, 10.256],
                       [6.1139, 9.0885, -0.75492],
                       [5.6391, 5.2043, 3.9705],
                       [10.798, 8.8062, 7.5521]])
    labels = np.array(
        ['class_0', 'class_0', 'class_1', 'class_1', 'class_0', 'class_1', 'class_0', 'class_0', 'class_0', 'class_0',
         'class_1', 'class_2', 'class_0', 'class_1', 'class_0', 'class_0', 'class_2', 'class_0', 'class_0', 'class_2',
         'class_0', 'class_0', 'class_2', 'class_1', 'class_0', 'class_1', 'class_0', 'class_0', 'class_0', 'class_1',
         'class_0', 'class_0', 'class_2', 'class_0', 'class_1', 'class_0', 'class_2', 'class_0', 'class_0', 'class_0',
         'class_0', 'class_0', 'class_0', 'class_0', 'class_1', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0',
         'class_2', 'class_0', 'class_2', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0',
         'class_2', 'class_1', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_2', 'class_0',
         'class_0', 'class_1', 'class_1', 'class_1', 'class_0', 'class_2', 'class_2', 'class_0', 'class_0', 'class_0',
         'class_0', 'class_0', 'class_0', 'class_1', 'class_1', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0',
         'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_2', 'class_2', 'class_0',
         'class_0', 'class_0', 'class_2', 'class_0', 'class_0', 'class_0', 'class_1', 'class_0', 'class_0', 'class_2',
         'class_0', 'class_2', 'class_0', 'class_2', 'class_1', 'class_2', 'class_0', 'class_0', 'class_2', 'class_0',
         'class_0', 'class_0', 'class_1', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_2', 'class_0',
         'class_1', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_2', 'class_2', 'class_0', 'class_2',
         'class_0', 'class_2', 'class_0', 'class_1', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0',
         'class_1', 'class_0', 'class_0', 'class_2', 'class_1', 'class_2', 'class_0', 'class_0', 'class_1', 'class_0',
         'class_1', 'class_1', 'class_1', 'class_0', 'class_1', 'class_0', 'class_0', 'class_0', 'class_0', 'class_1',
         'class_0', 'class_0', 'class_0', 'class_2', 'class_2', 'class_0', 'class_0', 'class_1', 'class_1', 'class_2',
         'class_1', 'class_0', 'class_2', 'class_0', 'class_0', 'class_0', 'class_1', 'class_0', 'class_2', 'class_0',
         'class_1', 'class_1', 'class_2', 'class_0', 'class_0', 'class_0', 'class_0', 'class_1', 'class_0', 'class_0',
         'class_1', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_2', 'class_0', 'class_0', 'class_0',
         'class_1', 'class_0', 'class_1', 'class_1', 'class_0', 'class_2', 'class_0', 'class_0', 'class_0', 'class_0',
         'class_0', 'class_0', 'class_1', 'class_2', 'class_2', 'class_2', 'class_0', 'class_0', 'class_1', 'class_0',
         'class_1', 'class_0', 'class_1', 'class_0', 'class_0', 'class_2', 'class_0', 'class_0', 'class_0', 'class_0',
         'class_0', 'class_1', 'class_1', 'class_0', 'class_1', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0',
         'class_0', 'class_2', 'class_0', 'class_0', 'class_2', 'class_1', 'class_0', 'class_0', 'class_1', 'class_0',
         'class_0', 'class_1', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_1', 'class_0',
         'class_0', 'class_1', 'class_0', 'class_1', 'class_0', 'class_1', 'class_2', 'class_2', 'class_1', 'class_2',
         'class_1', 'class_0', 'class_0', 'class_0', 'class_1', 'class_0', 'class_0', 'class_0', 'class_1', 'class_0',
         'class_0', 'class_0', 'class_0', 'class_2', 'class_0', 'class_2', 'class_1', 'class_2', 'class_0', 'class_1',
         'class_2', 'class_0', 'class_0', 'class_1', 'class_0', 'class_1', 'class_1', 'class_1', 'class_1', 'class_2',
         'class_0', 'class_1', 'class_0', 'class_2', 'class_1', 'class_0', 'class_0', 'class_0', 'class_0', 'class_1',
         'class_1', 'class_0', 'class_0', 'class_2', 'class_2', 'class_1', 'class_1', 'class_2', 'class_0', 'class_0',
         'class_0', 'class_0', 'class_0', 'class_0', 'class_1', 'class_1', 'class_0', 'class_0', 'class_0', 'class_0',
         'class_0', 'class_0', 'class_1', 'class_0', 'class_2', 'class_2', 'class_1', 'class_0', 'class_2', 'class_2',
         'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_1', 'class_0', 'class_0', 'class_0', 'class_0',
         'class_1', 'class_0', 'class_0', 'class_2', 'class_2', 'class_0', 'class_0', 'class_1', 'class_0', 'class_0',
         'class_0', 'class_2', 'class_2', 'class_1', 'class_0', 'class_0', 'class_0', 'class_1', 'class_2', 'class_2',
         'class_2', 'class_0', 'class_1', 'class_1', 'class_0', 'class_0', 'class_0', 'class_1', 'class_0', 'class_2',
         'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_2', 'class_0', 'class_0', 'class_0', 'class_0',
         'class_0', 'class_2', 'class_0', 'class_1', 'class_2', 'class_0', 'class_0', 'class_1', 'class_2', 'class_0',
         'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_1',
         'class_0', 'class_0', 'class_0', 'class_0', 'class_1', 'class_0', 'class_0', 'class_0', 'class_0', 'class_2',
         'class_0', 'class_0', 'class_2', 'class_0', 'class_0', 'class_1', 'class_0', 'class_0', 'class_0', 'class_0',
         'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_1', 'class_0',
         'class_0', 'class_2', 'class_0', 'class_2', 'class_0', 'class_0', 'class_0', 'class_1', 'class_2', 'class_0',
         'class_1', 'class_0', 'class_0', 'class_1', 'class_2', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0',
         'class_1', 'class_0', 'class_0', 'class_0', 'class_0', 'class_1', 'class_0', 'class_0', 'class_0', 'class_0',
         'class_0', 'class_0', 'class_0', 'class_0', 'class_1', 'class_0', 'class_0', 'class_0', 'class_2', 'class_1',
         'class_0', 'class_0', 'class_1', 'class_0', 'class_2', 'class_2', 'class_1', 'class_1', 'class_0', 'class_0',
         'class_0', 'class_0', 'class_0', 'class_1', 'class_1', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0',
         'class_0', 'class_0', 'class_2', 'class_2', 'class_0', 'class_1', 'class_2', 'class_0', 'class_1', 'class_0',
         'class_0', 'class_0', 'class_0', 'class_2', 'class_1', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0',
         'class_1', 'class_0', 'class_0', 'class_2', 'class_2', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0',
         'class_0', 'class_0', 'class_1', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0',
         'class_2', 'class_0', 'class_0', 'class_0', 'class_1', 'class_2', 'class_1', 'class_0', 'class_0', 'class_1',
         'class_1', 'class_0', 'class_0', 'class_0', 'class_0', 'class_1', 'class_1', 'class_0', 'class_0', 'class_0',
         'class_0', 'class_0', 'class_0', 'class_2', 'class_1', 'class_1', 'class_0', 'class_0', 'class_0', 'class_0',
         'class_0', 'class_0', 'class_0', 'class_0', 'class_2', 'class_0', 'class_1', 'class_0', 'class_0', 'class_0',
         'class_0', 'class_1', 'class_0', 'class_0', 'class_0', 'class_1', 'class_0', 'class_2', 'class_0', 'class_0',
         'class_1', 'class_1', 'class_0', 'class_0', 'class_0', 'class_1', 'class_1', 'class_2', 'class_0', 'class_1',
         'class_0', 'class_0', 'class_0', 'class_2', 'class_1', 'class_1', 'class_0', 'class_0', 'class_0', 'class_0',
         'class_0', 'class_0', 'class_1', 'class_1', 'class_0', 'class_1', 'class_0', 'class_1', 'class_0', 'class_2',
         'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_2', 'class_1', 'class_0',
         'class_0', 'class_0', 'class_0', 'class_0', 'class_1', 'class_2', 'class_1', 'class_2', 'class_0', 'class_0',
         'class_2', 'class_2', 'class_1', 'class_2', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0',
         'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0',
         'class_0', 'class_1', 'class_0', 'class_0', 'class_0', 'class_0', 'class_1', 'class_1', 'class_0', 'class_0',
         'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_2', 'class_0', 'class_0', 'class_1', 'class_0',
         'class_0', 'class_0', 'class_0', 'class_1', 'class_0', 'class_2', 'class_1', 'class_1', 'class_0', 'class_0',
         'class_0', 'class_1', 'class_1', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_1', 'class_0',
         'class_1', 'class_1', 'class_0', 'class_0', 'class_0', 'class_0', 'class_0', 'class_2', 'class_0', 'class_1',
         'class_0', 'class_0', 'class_1'])
    positives = np.array(['class_1', 'class_2'])

    return matrix, labels, positives


def _smokers_sample_data():
    matrix = np.array([[71, 176, 93, 124, 69, 163, 77, 109, 64, 131, 83, 125, 67, 133, 75, 117, 64, 119, 80, 122, 68,
                        142, 70, 121, 64, 142, 88, 130, 68, 180, 82, 115, 68, 183, 78, 115, 66, 132, 86, 118, 68, 128,
                        77, 114, 66, 137, 68, 115, 71, 174, 74, 127, 72, 202, 95, 130, 65, 129, 79, 114, 71, 181, 92,
                        130, 69, 191, 95, 124, 69, 131, 79, 123, 70, 179, 77, 119, 68, 172, 76, 125, 65, 133, 75, 121,
                        64, 117, 79, 123, 62, 137, 88, 114, 66, 146, 90, 128, 65, 123, 96, 129, 70, 189, 77, 114, 63,
                        143, 80, 113, 63, 114, 76, 125, 68, 166, 83, 120, 67, 186, 89, 127, 70, 126, 92, 134, 66, 137,
                        83, 121, 64, 138, 80, 115, 70, 187, 84, 127, 71, 193, 92, 121, 66, 137, 83, 127, 71, 192, 90,
                        136, 66, 118, 85, 117, 66, 180, 90, 124, 63, 128, 74, 120, 71, 164, 92, 128, 69, 183, 80, 116,
                        70, 169, 89, 132, 70, 194, 96, 137, 67, 172, 89, 117, 65, 135, 77, 116, 68, 182, 81, 119, 62,
                        121, 76, 123, 70, 158, 83, 116, 67, 179, 78, 124, 68, 170, 95, 129, 62, 136, 91, 130, 64, 135,
                        91, 132, 66, 147, 86, 117, 72, 186, 89, 129, 63, 124, 79, 118, 66, 134, 74, 120, 70, 170, 82,
                        138, 71, 180, 76, 117, 68, 130, 81, 113, 63, 130, 77, 122, 65, 127, 73, 115, 67, 141, 85, 120,
                        66, 111, 76, 117, 68, 134, 80, 123, 71, 189, 80, 123, 70, 137, 79, 119, 60, 136, 82, 110, 64,
                        130, 79, 121, 64, 137, 82, 138, 66, 186, 75, 125, 64, 127, 91, 122, 72, 176, 74, 120, 65, 127,
                        78, 117, 67, 115, 85, 125, 72, 178, 84, 124, 64, 131, 75, 121, 68, 183, 78, 118, 66, 194, 81,
                        120, 64, 126, 79, 118, 68, 186, 85, 118, 69, 188, 79, 122, 69, 189, 82, 134, 64, 120, 80, 131,
                        63, 132, 80, 113, 68, 182, 92, 125, 65, 120, 92, 135, 63, 123, 96, 128, 66, 141, 87, 123, 65,
                        129, 81, 122, 68, 184, 90, 138, 71, 181, 77, 124, 70, 124, 91, 130, 71, 174, 79, 123, 66, 134,
                        73, 129, 69, 171, 99, 128, 69, 188, 92, 124, 70, 186, 74, 119, 68, 172, 93, 136, 66, 177, 86,
                        114]])
    # Height | Weight | Diastolic | Systolic
    matrix = matrix.reshape(-1, 4)

    labels = np.array(['Smoker', 'Non-smoker', 'Non-smoker', 'Non-smoker', 'Non-smoker', 'Non-smoker', 'Smoker',
                       'Non-smoker', 'Non-smoker', 'Non-smoker', 'Non-smoker', 'Non-smoker', 'Non-smoker', 'Smoker',
                       'Non-smoker', 'Smoker', 'Smoker', 'Smoker', 'Non-smoker', 'Non-smoker', 'Non-smoker',
                       'Non-smoker', 'Non-smoker', 'Smoker', 'Smoker', 'Non-smoker', 'Non-smoker', 'Non-smoker',
                       'Non-smoker', 'Smoker', 'Smoker', 'Non-smoker', 'Non-smoker', 'Non-smoker', 'Non-smoker',
                       'Non-smoker', 'Smoker', 'Non-smoker', 'Smoker', 'Non-smoker', 'Smoker', 'Non-smoker', 'Smoker',
                       'Smoker', 'Non-smoker', 'Non-smoker', 'Non-smoker', 'Non-smoker', 'Non-smoker', 'Smoker',
                       'Smoker', 'Smoker', 'Smoker', 'Non-smoker', 'Smoker', 'Non-smoker', 'Non-smoker', 'Smoker',
                       'Non-smoker', 'Non-smoker', 'Non-smoker', 'Non-smoker', 'Non-smoker', 'Non-smoker',
                       'Non-smoker', 'Non-smoker', 'Non-smoker', 'Non-smoker', 'Non-smoker', 'Smoker', 'Non-smoker',
                       'Smoker', 'Non-smoker', 'Non-smoker', 'Smoker', 'Smoker', 'Non-smoker', 'Non-smoker',
                       'Non-smoker', 'Non-smoker', 'Non-smoker', 'Non-smoker', 'Smoker', 'Non-smoker', 'Non-smoker',
                       'Smoker', 'Smoker', 'Smoker', 'Smoker', 'Non-smoker', 'Smoker', 'Non-smoker', 'Non-smoker',
                       'Non-smoker', 'Non-smoker', 'Smoker', 'Smoker', 'Non-smoker', 'Smoker', 'Non-smoker'])

    positives = np.array(['Smoker'])

    return matrix, labels, positives
