"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.obtainScope = exports.cloudAssemblyBuildSpecDir = exports.embeddedAsmPath = exports.pipelineSynth = exports.assemblyBuilderOf = exports.appOf = void 0;
/**
 * Get access to construct internals that we need but got removed from the Stages PR.
 */
const path = require("path");
const core_1 = require("../../../core");
const constructs_1 = require("constructs");
// eslint-disable-next-line no-duplicate-imports,import/order
const core_2 = require("../../../core");
function appOf(construct) {
    const root = constructs_1.Node.of(construct).root;
    if (!core_1.App.isApp(root)) {
        throw new Error(`Construct must be created under an App, but is not: ${constructs_1.Node.of(construct).path}`);
    }
    return root;
}
exports.appOf = appOf;
function assemblyBuilderOf(stage) {
    return stage._assemblyBuilder;
}
exports.assemblyBuilderOf = assemblyBuilderOf;
function pipelineSynth(stage) {
    return stage.synth({ validateOnSynthesis: true });
}
exports.pipelineSynth = pipelineSynth;
/**
 * Return the relative path from the app assembly to the scope's (nested) assembly
 */
function embeddedAsmPath(scope) {
    var _a;
    const appAsmRoot = assemblyBuilderOf(appOf(scope)).outdir;
    const stage = (_a = core_1.Stage.of(scope)) !== null && _a !== void 0 ? _a : appOf(scope);
    const stageAsmRoot = assemblyBuilderOf(stage).outdir;
    return path.relative(appAsmRoot, stageAsmRoot) || '.';
}
exports.embeddedAsmPath = embeddedAsmPath;
/**
 * Determine the directory where the cloud assembly will be written, for use in a BuildSpec
 */
function cloudAssemblyBuildSpecDir(scope) {
    return assemblyBuilderOf(appOf(scope)).outdir;
}
exports.cloudAssemblyBuildSpecDir = cloudAssemblyBuildSpecDir;
function obtainScope(parent, id) {
    const existing = constructs_1.Node.of(parent).tryFindChild(id);
    if (existing) {
        return existing;
    }
    return new core_2.Construct(parent, id);
}
exports.obtainScope = obtainScope;
//# sourceMappingURL=data:application/json;base64,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