"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SimpleSynthAction = void 0;
const jsiiDeprecationWarnings = require("../../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const crypto = require("crypto");
const path = require("path");
const codebuild = require("../../../../aws-codebuild");
const codepipeline = require("../../../../aws-codepipeline");
const codepipeline_actions = require("../../../../aws-codepipeline-actions");
const ec2 = require("../../../../aws-ec2");
const core_1 = require("../../../../core");
const docker_credentials_1 = require("../../docker-credentials");
const fs_1 = require("../../private/fs");
const _util_1 = require("./_util");
const DEFAULT_OUTPUT_DIR = 'cdk.out';
/**
 * A standard synth with a generated buildspec
 *
 * @deprecated This class is part of the old API. Use the API based on the `CodePipeline` class instead
 */
class SimpleSynthAction {
    constructor(props) {
        var _b, _c, _d;
        this.props = props;
        jsiiDeprecationWarnings.print("monocdk.pipelines.SimpleSynthAction", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        jsiiDeprecationWarnings.monocdk_pipelines_SimpleSynthActionProps(props);
        // A number of actionProperties get read before bind() is even called (so before we
        // have made the Project and can construct the actual CodeBuildAction)
        //
        // - actionName
        // - resource
        // - region
        // - category
        // - role
        // - owner
        this._actionProperties = {
            actionName: (_b = props.actionName) !== null && _b !== void 0 ? _b : 'Synth',
            category: codepipeline.ActionCategory.BUILD,
            provider: 'CodeBuild',
            artifactBounds: { minInputs: 0, maxInputs: 5, minOutputs: 0, maxOutputs: 5 },
            inputs: [props.sourceArtifact],
            outputs: [props.cloudAssemblyArtifact, ...((_c = props.additionalArtifacts) !== null && _c !== void 0 ? _c : []).map(a => a.artifact)],
        };
        if (this.props.installCommand && this.props.installCommands) {
            throw new Error('Pass either \'installCommand\' or \'installCommands\', but not both');
        }
        if (this.props.buildCommand && this.props.buildCommands) {
            throw new Error('Pass either \'buildCommand\' or \'buildCommands\', but not both');
        }
        const addls = (_d = props.additionalArtifacts) !== null && _d !== void 0 ? _d : [];
        if (Object.keys(addls).length > 0) {
            if (!props.cloudAssemblyArtifact.artifactName) {
                throw new Error('You must give all output artifacts, including the \'cloudAssemblyArtifact\', names when using \'additionalArtifacts\'');
            }
            for (const addl of addls) {
                if (!addl.artifact.artifactName) {
                    throw new Error('You must give all output artifacts passed to SimpleSynthAction names when using \'additionalArtifacts\'');
                }
            }
        }
    }
    /**
     * Create a standard NPM synth action
     *
     * Uses `npm ci` to install dependencies and `npx cdk synth` to synthesize.
     *
     * If you need a build step, add `buildCommand: 'npm run build'`.
     */
    static standardNpmSynth(options) {
        var _b, _c, _d;
        jsiiDeprecationWarnings.print("monocdk.pipelines.SimpleSynthAction#standardNpmSynth", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        jsiiDeprecationWarnings.monocdk_pipelines_StandardNpmSynthOptions(options);
        return new SimpleSynthAction({
            ...options,
            installCommand: (_b = options.installCommand) !== null && _b !== void 0 ? _b : 'npm ci',
            synthCommand: (_c = options.synthCommand) !== null && _c !== void 0 ? _c : 'npx cdk synth',
            vpc: options.vpc,
            subnetSelection: options.subnetSelection,
            environment: {
                ...options.environment,
                environmentVariables: {
                    // Need this in case the CDK CLI is not in the 'package.json' of the project,
                    // and 'npx' is going to download it; without this setting, 'npx' will not properly
                    // install the package into the root user's home directory
                    NPM_CONFIG_UNSAFE_PERM: { value: 'true' },
                    ...(_d = options.environment) === null || _d === void 0 ? void 0 : _d.environmentVariables,
                },
            },
        });
    }
    /**
     * Create a standard Yarn synth action
     *
     * Uses `yarn install --frozen-lockfile` to install dependencies and `npx cdk synth` to synthesize.
     *
     * If you need a build step, add `buildCommand: 'yarn build'`.
     */
    static standardYarnSynth(options) {
        var _b, _c, _d;
        jsiiDeprecationWarnings.print("monocdk.pipelines.SimpleSynthAction#standardYarnSynth", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        jsiiDeprecationWarnings.monocdk_pipelines_StandardYarnSynthOptions(options);
        return new SimpleSynthAction({
            ...options,
            installCommand: (_b = options.installCommand) !== null && _b !== void 0 ? _b : 'yarn install --frozen-lockfile',
            synthCommand: (_c = options.synthCommand) !== null && _c !== void 0 ? _c : 'npx cdk synth',
            vpc: options.vpc,
            subnetSelection: options.subnetSelection,
            environment: {
                ...options.environment,
                environmentVariables: {
                    // Need this in case the CDK CLI is not in the 'package.json' of the project,
                    // and 'npx' is going to download it; without this setting, 'npx' will not properly
                    // install the package into the root user's home directory
                    NPM_CONFIG_UNSAFE_PERM: { value: 'true' },
                    ...(_d = options.environment) === null || _d === void 0 ? void 0 : _d.environmentVariables,
                },
            },
        });
    }
    /**
     * Exists to implement IAction
     */
    get actionProperties() {
        jsiiDeprecationWarnings.print("monocdk.pipelines.SimpleSynthAction#actionProperties", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        return this._actionProperties;
    }
    /**
     * Project generated to run the synth command
     */
    get project() {
        jsiiDeprecationWarnings.print("monocdk.pipelines.SimpleSynthAction#project", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        if (!this._project) {
            throw new Error('Project becomes available after SimpleSynthAction has been bound to a stage');
        }
        return this._project;
    }
    /**
     * Exists to implement IAction
     */
    bind(scope, stage, options) {
        var _b, _c, _d, _e, _f;
        jsiiDeprecationWarnings.print("monocdk.pipelines.SimpleSynthAction#bind", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_codepipeline_IStage(stage);
        jsiiDeprecationWarnings.monocdk_aws_codepipeline_ActionBindOptions(options);
        const buildCommands = (_b = this.props.buildCommands) !== null && _b !== void 0 ? _b : [this.props.buildCommand];
        const installCommands = (_c = this.props.installCommands) !== null && _c !== void 0 ? _c : [this.props.installCommand];
        const testCommands = (_d = this.props.testCommands) !== null && _d !== void 0 ? _d : [];
        const synthCommand = this.props.synthCommand;
        const environment = { buildImage: codebuild.LinuxBuildImage.STANDARD_5_0, ...this.props.environment };
        const osType = (environment.buildImage instanceof codebuild.WindowsBuildImage)
            ? ec2.OperatingSystemType.WINDOWS
            : ec2.OperatingSystemType.LINUX;
        const buildSpec = codebuild.BuildSpec.fromObject({
            version: '0.2',
            phases: {
                pre_build: {
                    commands: _util_1.filterEmpty([
                        this.props.subdirectory ? `cd ${this.props.subdirectory}` : '',
                        ...installCommands,
                        ...docker_credentials_1.dockerCredentialsInstallCommands(docker_credentials_1.DockerCredentialUsage.SYNTH, this._dockerCredentials, osType),
                    ]),
                },
                build: {
                    commands: _util_1.filterEmpty([
                        ...buildCommands,
                        ...testCommands,
                        synthCommand,
                    ]),
                },
            },
            artifacts: renderArtifacts(this),
        });
        const environmentVariables = {
            ..._util_1.copyEnvironmentVariables(...this.props.copyEnvironmentVariables || []),
        };
        const mergedBuildSpec = this.props.buildSpec ? codebuild.mergeBuildSpecs(this.props.buildSpec, buildSpec) : buildSpec;
        // A hash over the values that make the CodeBuild Project unique (and necessary
        // to restart the pipeline if one of them changes). projectName is not necessary to include
        // here because the pipeline will definitely restart if projectName changes.
        // (Resolve tokens)
        const projectConfigHash = hash(core_1.Stack.of(scope).resolve({
            environment: serializeBuildEnvironment(environment),
            buildSpecString: mergedBuildSpec.toBuildSpec(),
            environmentVariables,
        }));
        const project = new codebuild.PipelineProject(scope, 'CdkBuildProject', {
            projectName: this.props.projectName,
            environment,
            vpc: this.props.vpc,
            subnetSelection: this.props.subnetSelection,
            buildSpec: mergedBuildSpec,
            environmentVariables,
        });
        if (this.props.rolePolicyStatements !== undefined) {
            this.props.rolePolicyStatements.forEach(policyStatement => {
                project.addToRolePolicy(policyStatement);
            });
        }
        this._project = project;
        (_e = this._dockerCredentials) === null || _e === void 0 ? void 0 : _e.forEach(reg => reg.grantRead(project.grantPrincipal, docker_credentials_1.DockerCredentialUsage.SYNTH));
        this._action = new codepipeline_actions.CodeBuildAction({
            actionName: this.actionProperties.actionName,
            input: this.props.sourceArtifact,
            outputs: [this.props.cloudAssemblyArtifact, ...((_f = this.props.additionalArtifacts) !== null && _f !== void 0 ? _f : []).map(a => a.artifact)],
            // Inclusion of the hash here will lead to the pipeline structure for any changes
            // made the config of the underlying CodeBuild Project.
            // Hence, the pipeline will be restarted. This is necessary if the users
            // adds (for example) build or test commands to the buildspec.
            environmentVariables: {
                ...this.props.environmentVariables,
                _PROJECT_CONFIG_HASH: { value: projectConfigHash },
            },
            project,
        });
        this._actionProperties = this._action.actionProperties;
        return this._action.bind(scope, stage, options);
        function renderArtifacts(self) {
            // save the generated files in the output artifact
            // This part of the buildspec has to look completely different depending on whether we're
            // using secondary artifacts or not.
            var _b;
            const cloudAsmArtifactSpec = {
                'base-directory': fs_1.toPosixPath(path.join((_b = self.props.subdirectory) !== null && _b !== void 0 ? _b : '.', DEFAULT_OUTPUT_DIR)),
                'files': '**/*',
            };
            if (self.props.additionalArtifacts) {
                const secondary = {};
                if (!self.props.cloudAssemblyArtifact.artifactName) {
                    throw new Error('When using additional output artifacts, you must also name the CloudAssembly artifact');
                }
                secondary[self.props.cloudAssemblyArtifact.artifactName] = cloudAsmArtifactSpec;
                self.props.additionalArtifacts.forEach((art) => {
                    var _b;
                    if (!art.artifact.artifactName) {
                        throw new Error('You must give the output artifact a name');
                    }
                    secondary[art.artifact.artifactName] = {
                        'base-directory': fs_1.toPosixPath(path.join((_b = self.props.subdirectory) !== null && _b !== void 0 ? _b : '.', art.directory)),
                        'files': '**/*',
                    };
                });
                return { 'secondary-artifacts': secondary };
            }
            return cloudAsmArtifactSpec;
        }
    }
    /**
     * The CodeBuild Project's principal
     */
    get grantPrincipal() {
        jsiiDeprecationWarnings.print("monocdk.pipelines.SimpleSynthAction#grantPrincipal", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        return this.project.grantPrincipal;
    }
    /**
     * Exists to implement IAction
     */
    onStateChange(name, target, options) {
        jsiiDeprecationWarnings.print("monocdk.pipelines.SimpleSynthAction#onStateChange", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        jsiiDeprecationWarnings.monocdk_aws_events_IRuleTarget(target);
        jsiiDeprecationWarnings.monocdk_aws_events_RuleProps(options);
        if (!this._action) {
            throw new Error('Need bind() first');
        }
        return this._action.onStateChange(name, target, options);
    }
    /**
     * Associate one or more Docker registries and associated credentials with the synth action.
     * This will be used to inject installation commands to set up `cdk-assets`,
     * and grant read access to the credentials.
     * @internal
     */
    _addDockerCredentials(dockerCredentials) {
        this._dockerCredentials = dockerCredentials;
    }
}
exports.SimpleSynthAction = SimpleSynthAction;
_a = JSII_RTTI_SYMBOL_1;
SimpleSynthAction[_a] = { fqn: "monocdk.pipelines.SimpleSynthAction", version: "1.149.0" };
function hash(obj) {
    const d = crypto.createHash('sha256');
    d.update(JSON.stringify(obj));
    return d.digest('hex');
}
/**
 * Serialize a build environment to data (get rid of constructs & objects), so we can JSON.stringify it
 */
function serializeBuildEnvironment(env) {
    var _b, _c, _d, _e, _f;
    return {
        privileged: env.privileged,
        environmentVariables: env.environmentVariables,
        type: (_b = env.buildImage) === null || _b === void 0 ? void 0 : _b.type,
        imageId: (_c = env.buildImage) === null || _c === void 0 ? void 0 : _c.imageId,
        computeType: env.computeType,
        imagePullPrincipalType: (_d = env.buildImage) === null || _d === void 0 ? void 0 : _d.imagePullPrincipalType,
        secretsManagerArn: (_f = (_e = env.buildImage) === null || _e === void 0 ? void 0 : _e.secretsManagerCredentials) === null || _f === void 0 ? void 0 : _f.secretArn,
    };
}
//# sourceMappingURL=data:application/json;base64,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