"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StackOutput = exports.CdkStage = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codebuild = require("../../../aws-codebuild");
const cpactions = require("../../../aws-codepipeline-actions");
const aws_codepipeline_actions_1 = require("../../../aws-codepipeline-actions");
const core_1 = require("../../../core");
const constructs_1 = require("constructs");
const asset_type_1 = require("../blueprint/asset-type");
const application_security_check_1 = require("../private/application-security-check");
const asset_manifest_1 = require("../private/asset-manifest");
const construct_internals_1 = require("../private/construct-internals");
const toposort_1 = require("../private/toposort");
const actions_1 = require("./actions");
const pipeline_1 = require("./pipeline");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("../../../core");
/**
 * Stage in a CdkPipeline
 *
 * You don't need to instantiate this class directly. Use
 * `cdkPipeline.addStage()` instead.
 *
 * @deprecated This class is part of the old API. Use the API based on the `CodePipeline` class instead
 */
class CdkStage extends core_2.Construct {
    constructor(scope, id, props) {
        var _c;
        super(scope, id);
        this._nextSequentialRunOrder = 1; // Must start at 1 eh
        this._manualApprovalCounter = 1;
        this.stacksToDeploy = new Array();
        this._prepared = false;
        jsiiDeprecationWarnings.print("monocdk.pipelines.CdkStage", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        jsiiDeprecationWarnings.monocdk_pipelines_CdkStageProps(props);
        if (scope instanceof pipeline_1.CdkPipeline) {
            this.pipeline = scope;
        }
        this.stageName = props.stageName;
        this.pipelineStage = props.pipelineStage;
        this.cloudAssemblyArtifact = props.cloudAssemblyArtifact;
        this.host = props.host;
        this.confirmBroadeningPermissions = (_c = props.confirmBroadeningPermissions) !== null && _c !== void 0 ? _c : false;
        this.securityNotificationTopic = props.securityNotificationTopic;
        core_1.Aspects.of(this).add({ visit: () => this.prepareStage() });
    }
    /**
     * Add all stacks in the application Stage to this stage
     *
     * The application construct should subclass `Stage` and can contain any
     * number of `Stacks` inside it that may have dependency relationships
     * on one another.
     *
     * All stacks in the application will be deployed in the appropriate order,
     * and all assets found in the application will be added to the asset
     * publishing stage.
     */
    addApplication(appStage, options = {}) {
        var _c, _d;
        jsiiDeprecationWarnings.print("monocdk.pipelines.CdkStage#addApplication", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        jsiiDeprecationWarnings.monocdk_Stage(appStage);
        jsiiDeprecationWarnings.monocdk_pipelines_AddStageOptions(options);
        const asm = construct_internals_1.pipelineSynth(appStage);
        const extraRunOrderSpace = (_c = options.extraRunOrderSpace) !== null && _c !== void 0 ? _c : 0;
        if ((_d = options.confirmBroadeningPermissions) !== null && _d !== void 0 ? _d : this.confirmBroadeningPermissions) {
            this.addSecurityCheck(appStage, options);
        }
        if (asm.stacks.length === 0) {
            // If we don't check here, a more puzzling "stage contains no actions"
            // error will be thrown come deployment time.
            throw new Error(`The given Stage construct ('${appStage.node.path}') should contain at least one Stack`);
        }
        const sortedTranches = toposort_1.topologicalSort(asm.stacks, stack => stack.id, stack => stack.dependencies.map(d => d.id));
        for (const stacks of sortedTranches) {
            const runOrder = this.nextSequentialRunOrder(extraRunOrderSpace + 2); // 2 actions for Prepare/Execute ChangeSet
            let executeRunOrder = runOrder + extraRunOrderSpace + 1;
            // If we need to insert a manual approval action, then what's the executeRunOrder
            // now is where we add a manual approval step, and we allocate 1 more runOrder
            // for the execute.
            if (options.manualApprovals) {
                this.addManualApprovalAction({ runOrder: runOrder + 1 });
                executeRunOrder = this.nextSequentialRunOrder();
            }
            // These don't have a dependency on each other, so can all be added in parallel
            for (const stack of stacks) {
                this.addStackArtifactDeployment(stack, { runOrder, executeRunOrder });
            }
        }
    }
    /**
     * Get a cached version of an ApplicationSecurityCheck, which consists of:
     *  - CodeBuild Project to check for security changes in a stage
     *  - Lambda Function that approves the manual approval if no security changes are detected
     *
     * The ApplicationSecurityCheck is cached from the pipeline **if** this stage is scoped
     * to a CDK Pipeline. If this stage **is not** scoped to a pipeline, create an ApplicationSecurityCheck
     * scoped to the stage itself.
     *
     * @internal
     */
    getApplicationSecurityCheck() {
        if (this._applicationSecurityCheck) {
            return this._applicationSecurityCheck;
        }
        this._applicationSecurityCheck = this.pipeline
            ? this.pipeline._getApplicationSecurityCheck()
            : new application_security_check_1.ApplicationSecurityCheck(this, 'StageApplicationSecurityCheck', {
                codePipeline: this.pipelineStage.pipeline,
            });
        return this._applicationSecurityCheck;
    }
    /**
     * Add a deployment action based on a stack artifact
     */
    addStackArtifactDeployment(stackArtifact, options = {}) {
        var _c, _d;
        jsiiDeprecationWarnings.print("monocdk.pipelines.CdkStage#addStackArtifactDeployment", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        jsiiDeprecationWarnings.monocdk_cx_api_CloudFormationStackArtifact(stackArtifact);
        jsiiDeprecationWarnings.monocdk_pipelines_AddStackOptions(options);
        // Get all assets manifests and add the assets in 'em to the asset publishing stage.
        this.publishAssetDependencies(stackArtifact);
        // Remember for later, see 'prepare()'
        // We know that deploying a stack is going to take up 2 runorder slots later on.
        const runOrder = (_c = options.runOrder) !== null && _c !== void 0 ? _c : this.nextSequentialRunOrder(2);
        const executeRunOrder = (_d = options.executeRunOrder) !== null && _d !== void 0 ? _d : runOrder + 1;
        this.stacksToDeploy.push({
            prepareRunOrder: runOrder,
            executeRunOrder,
            stackArtifact,
        });
        this.advanceRunOrderPast(runOrder);
        this.advanceRunOrderPast(executeRunOrder);
    }
    /**
     * Add a manual approval action
     *
     * If you need more flexibility than what this method offers,
     * use `addAction` with a `ManualApprovalAction`.
     */
    addManualApprovalAction(options = {}) {
        var _c;
        jsiiDeprecationWarnings.print("monocdk.pipelines.CdkStage#addManualApprovalAction", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        jsiiDeprecationWarnings.monocdk_pipelines_AddManualApprovalOptions(options);
        let actionName = options.actionName;
        if (!actionName) {
            actionName = `ManualApproval${this._manualApprovalCounter > 1 ? this._manualApprovalCounter : ''}`;
            this._manualApprovalCounter += 1;
        }
        this.addActions(new cpactions.ManualApprovalAction({
            actionName,
            runOrder: (_c = options.runOrder) !== null && _c !== void 0 ? _c : this.nextSequentialRunOrder(),
        }));
    }
    /**
     * Add one or more CodePipeline Actions
     *
     * You need to make sure it is created with the right runOrder. Call `nextSequentialRunOrder()`
     * for every action to get actions to execute in sequence.
     */
    addActions(...actions) {
        jsiiDeprecationWarnings.print("monocdk.pipelines.CdkStage#addActions", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        jsiiDeprecationWarnings.monocdk_aws_codepipeline_IAction(actions);
        for (const action of actions) {
            this.pipelineStage.addAction(action);
        }
    }
    /**
     * Return the runOrder number necessary to run the next Action in sequence with the rest
     *
     * FIXME: This is here because Actions are immutable and can't be reordered
     * after creation, nor is there a way to specify relative priorities, which
     * is a limitation that we should take away in the base library.
     */
    nextSequentialRunOrder(count = 1) {
        jsiiDeprecationWarnings.print("monocdk.pipelines.CdkStage#nextSequentialRunOrder", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        const ret = this._nextSequentialRunOrder;
        this._nextSequentialRunOrder += count;
        return ret;
    }
    /**
     * Whether this Stage contains an action to deploy the given stack, identified by its artifact ID
     */
    deploysStack(artifactId) {
        jsiiDeprecationWarnings.print("monocdk.pipelines.CdkStage#deploysStack", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        return this.stacksToDeploy.map(s => s.stackArtifact.id).includes(artifactId);
    }
    /**
     * Actually add all the DeployStack actions to the stage.
     *
     * We do this late because before we can render the actual DeployActions,
     * we need to know whether or not we need to capture the stack outputs.
     *
     * FIXME: This is here because Actions are immutable and can't be reordered
     * after creation, nor is there a way to specify relative priorities, which
     * is a limitation that we should take away in the base library.
     */
    prepareStage() {
        // FIXME: Make sure this only gets run once. There seems to be an issue in the reconciliation
        // loop that may trigger this more than once if it throws an error somewhere, and the exception
        // that gets thrown here will then override the actual failure.
        if (this._prepared) {
            return;
        }
        this._prepared = true;
        for (const { prepareRunOrder, stackArtifact, executeRunOrder } of this.stacksToDeploy) {
            const artifact = this.host.stackOutputArtifact(stackArtifact.id);
            this.pipelineStage.addAction(actions_1.DeployCdkStackAction.fromStackArtifact(this, stackArtifact, {
                baseActionName: this.simplifyStackName(stackArtifact.stackName),
                cloudAssemblyInput: this.cloudAssemblyArtifact,
                output: artifact,
                outputFileName: artifact ? 'outputs.json' : undefined,
                prepareRunOrder,
                executeRunOrder,
            }));
        }
    }
    /**
     * Advance the runorder counter so that the next sequential number is higher than the given one
     */
    advanceRunOrderPast(lastUsed) {
        this._nextSequentialRunOrder = Math.max(lastUsed + 1, this._nextSequentialRunOrder);
    }
    /**
     * Simplify the stack name by removing the `Stage-` prefix if it exists.
     */
    simplifyStackName(s) {
        return stripPrefix(s, `${this.stageName}-`);
    }
    /**
     * Add a security check before the prepare/deploy actions of an CDK stage.
     * The security check consists of two actions:
     *  - CodeBuild Action to check for security changes in a stage
     *  - Manual Approval Action that is auto approved via a Lambda if no security changes detected
     */
    addSecurityCheck(appStage, options) {
        var _c;
        const { cdkDiffProject } = this.getApplicationSecurityCheck();
        const notificationTopic = (_c = options === null || options === void 0 ? void 0 : options.securityNotificationTopic) !== null && _c !== void 0 ? _c : this.securityNotificationTopic;
        notificationTopic === null || notificationTopic === void 0 ? void 0 : notificationTopic.grantPublish(cdkDiffProject);
        const appStageName = appStage.stageName;
        const approveActionName = `${appStageName}ManualApproval`;
        const diffAction = new aws_codepipeline_actions_1.CodeBuildAction({
            runOrder: this.nextSequentialRunOrder(),
            actionName: `${appStageName}SecurityCheck`,
            input: this.cloudAssemblyArtifact,
            project: cdkDiffProject,
            variablesNamespace: `${appStageName}SecurityCheck`,
            environmentVariables: {
                STAGE_PATH: {
                    value: constructs_1.Node.of(appStage).path,
                    type: codebuild.BuildEnvironmentVariableType.PLAINTEXT,
                },
                STAGE_NAME: {
                    value: this.stageName,
                    type: codebuild.BuildEnvironmentVariableType.PLAINTEXT,
                },
                ACTION_NAME: {
                    value: approveActionName,
                    type: codebuild.BuildEnvironmentVariableType.PLAINTEXT,
                },
                ...notificationTopic ? {
                    NOTIFICATION_ARN: {
                        value: notificationTopic.topicArn,
                        type: codebuild.BuildEnvironmentVariableType.PLAINTEXT,
                    },
                    NOTIFICATION_SUBJECT: {
                        value: `Confirm permission broadening in ${appStageName}`,
                        type: codebuild.BuildEnvironmentVariableType.PLAINTEXT,
                    },
                } : {},
            },
        });
        const approve = new cpactions.ManualApprovalAction({
            actionName: approveActionName,
            runOrder: this.nextSequentialRunOrder(),
            additionalInformation: `#{${appStageName}SecurityCheck.MESSAGE}`,
            externalEntityLink: `#{${appStageName}SecurityCheck.LINK}`,
        });
        this.addActions(diffAction, approve);
    }
    /**
     * Make sure all assets depended on by this stack are published in this pipeline
     *
     * Taking care to exclude the stack template itself -- it is being published
     * as an asset because the CLI needs to know the asset publishing role when
     * pushing the template to S3, but in the case of CodePipeline we always
     * reference the template from the artifact bucket.
     *
     * (NOTE: this is only true for top-level stacks, not nested stacks. Nested
     * Stack templates are always published as assets).
     */
    publishAssetDependencies(stackArtifact) {
        const assetManifests = stackArtifact.dependencies.filter(isAssetManifest);
        for (const manifestArtifact of assetManifests) {
            const manifest = asset_manifest_1.AssetManifestReader.fromFile(manifestArtifact.file);
            for (const entry of manifest.entries) {
                let assetType;
                if (entry instanceof asset_manifest_1.DockerImageManifestEntry) {
                    assetType = asset_type_1.AssetType.DOCKER_IMAGE;
                }
                else if (entry instanceof asset_manifest_1.FileManifestEntry) {
                    // Don't publish the template for this stack
                    if (entry.source.packaging === 'file' && entry.source.path === stackArtifact.templateFile) {
                        continue;
                    }
                    assetType = asset_type_1.AssetType.FILE;
                }
                else {
                    throw new Error(`Unrecognized asset type: ${entry.type}`);
                }
                if (!entry.destination.assumeRoleArn) {
                    throw new Error('assumeRoleArn is missing on asset and required');
                }
                this.host.publishAsset({
                    assetManifestPath: manifestArtifact.file,
                    assetId: entry.id.assetId,
                    assetSelector: entry.id.toString(),
                    assetType,
                    assetPublishingRoleArn: entry.destination.assumeRoleArn,
                });
            }
        }
    }
}
exports.CdkStage = CdkStage;
_a = JSII_RTTI_SYMBOL_1;
CdkStage[_a] = { fqn: "monocdk.pipelines.CdkStage", version: "1.149.0" };
/**
 * A single output of a Stack
 *
 * @deprecated This class is part of the old API. Use the API based on the `CodePipeline` class instead
 */
class StackOutput {
    /**
     * Build a StackOutput from a known artifact and an output name
     */
    constructor(artifactFile, outputName) {
        jsiiDeprecationWarnings.print("monocdk.pipelines.StackOutput", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        jsiiDeprecationWarnings.monocdk_aws_codepipeline_ArtifactPath(artifactFile);
        this.artifactFile = artifactFile;
        this.outputName = outputName;
    }
}
exports.StackOutput = StackOutput;
_b = JSII_RTTI_SYMBOL_1;
StackOutput[_b] = { fqn: "monocdk.pipelines.StackOutput", version: "1.149.0" };
function stripPrefix(s, prefix) {
    return s.startsWith(prefix) ? s.substr(prefix.length) : s;
}
function isAssetManifest(s) {
    // instanceof is too risky, and we're at a too late stage to properly fix.
    // return s instanceof cxapi.AssetManifestArtifact;
    return s.constructor.name === 'AssetManifestArtifact';
}
//# sourceMappingURL=data:application/json;base64,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