"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CdkPipeline = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const codepipeline = require("../../../aws-codepipeline");
const iam = require("../../../aws-iam");
const core_1 = require("../../../core");
const asset_type_1 = require("../blueprint/asset-type");
const docker_credentials_1 = require("../docker-credentials");
const application_security_check_1 = require("../private/application-security-check");
const asset_singleton_role_1 = require("../private/asset-singleton-role");
const cli_version_1 = require("../private/cli-version");
const construct_internals_1 = require("../private/construct-internals");
const actions_1 = require("./actions");
const stage_1 = require("./stage");
const synths_1 = require("./synths");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("../../../core");
const CODE_BUILD_LENGTH_LIMIT = 100;
/**
 * A Pipeline to deploy CDK apps
 *
 * Defines an AWS CodePipeline-based Pipeline to deploy CDK applications.
 *
 * Automatically manages the following:
 *
 * - Stack dependency order.
 * - Asset publishing.
 * - Keeping the pipeline up-to-date as the CDK apps change.
 * - Using stack outputs later on in the pipeline.
 *
 * @deprecated This class is part of the old API. Use the API based on the `CodePipeline` class instead
 */
class CdkPipeline extends core_2.Construct {
    constructor(scope, id, props) {
        var _b, _c, _d;
        super(scope, id);
        this._stages = [];
        this._outputArtifacts = {};
        jsiiDeprecationWarnings.print("monocdk.pipelines.CdkPipeline", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        jsiiDeprecationWarnings.monocdk_pipelines_CdkPipelineProps(props);
        this.cliVersion = (_b = props.cdkCliVersion) !== null && _b !== void 0 ? _b : cli_version_1.preferredCliVersion();
        if (!core_1.App.isApp(this.node.root)) {
            throw new Error('CdkPipeline must be created under an App');
        }
        this._cloudAssemblyArtifact = props.cloudAssemblyArtifact;
        this._dockerCredentials = (_c = props.dockerCredentials) !== null && _c !== void 0 ? _c : [];
        const pipelineStack = core_1.Stack.of(this);
        if (props.codePipeline) {
            if (props.pipelineName) {
                throw new Error('Cannot set \'pipelineName\' if an existing CodePipeline is given using \'codePipeline\'');
            }
            if (props.crossAccountKeys !== undefined) {
                throw new Error('Cannot set \'crossAccountKeys\' if an existing CodePipeline is given using \'codePipeline\'');
            }
            if (props.enableKeyRotation !== undefined) {
                throw new Error('Cannot set \'enableKeyRotation\' if an existing CodePipeline is given using \'codePipeline\'');
            }
            this._pipeline = props.codePipeline;
        }
        else {
            this._pipeline = new codepipeline.Pipeline(this, 'Pipeline', {
                pipelineName: props.pipelineName,
                crossAccountKeys: props.crossAccountKeys,
                enableKeyRotation: props.enableKeyRotation,
                restartExecutionOnUpdate: true,
            });
        }
        if (props.sourceAction && !props.synthAction) {
            // Because of ordering limitations, you can: bring your own Source, bring your own
            // Both, or bring your own Nothing. You cannot bring your own Build (which because of the
            // current CodePipeline API must go BEFORE what we're adding) and then having us add a
            // Source after it. That doesn't make any sense.
            throw new Error('When passing a \'sourceAction\' you must also pass a \'synthAction\' (or a \'codePipeline\' that already has both)');
        }
        if (!props.sourceAction && (!props.codePipeline || props.codePipeline.stages.length < 1)) {
            throw new Error('You must pass a \'sourceAction\' (or a \'codePipeline\' that already has a Source stage)');
        }
        if (props.sourceAction) {
            this._pipeline.addStage({
                stageName: 'Source',
                actions: [props.sourceAction],
            });
        }
        if (props.synthAction) {
            if (props.synthAction instanceof synths_1.SimpleSynthAction && this._dockerCredentials.length > 0) {
                props.synthAction._addDockerCredentials(this._dockerCredentials);
            }
            this._pipeline.addStage({
                stageName: 'Build',
                actions: [props.synthAction],
            });
        }
        if ((_d = props.selfMutating) !== null && _d !== void 0 ? _d : true) {
            this._pipeline.addStage({
                stageName: 'UpdatePipeline',
                actions: [new actions_1.UpdatePipelineAction(this, 'UpdatePipeline', {
                        cloudAssemblyInput: this._cloudAssemblyArtifact,
                        pipelineStackHierarchicalId: pipelineStack.node.path,
                        cdkCliVersion: this.cliVersion,
                        projectName: maybeSuffix(props.pipelineName, '-selfupdate'),
                        privileged: props.supportDockerAssets,
                        dockerCredentials: this._dockerCredentials,
                        buildSpec: props.selfMutationBuildSpec,
                    })],
            });
        }
        this._assets = new AssetPublishing(this, 'Assets', {
            cloudAssemblyInput: this._cloudAssemblyArtifact,
            cdkCliVersion: this.cliVersion,
            pipeline: this._pipeline,
            projectName: maybeSuffix(props.pipelineName, '-publish'),
            vpc: props.vpc,
            subnetSelection: props.subnetSelection,
            singlePublisherPerType: props.singlePublisherPerType,
            preInstallCommands: props.assetPreInstallCommands,
            buildSpec: props.assetBuildSpec,
            dockerCredentials: this._dockerCredentials,
        });
    }
    /**
     * The underlying CodePipeline object
     *
     * You can use this to add more Stages to the pipeline, or Actions
     * to Stages.
     */
    get codePipeline() {
        jsiiDeprecationWarnings.print("monocdk.pipelines.CdkPipeline#codePipeline", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        return this._pipeline;
    }
    /**
     * Access one of the pipeline's stages by stage name
     *
     * You can use this to add more Actions to a stage.
     */
    stage(stageName) {
        jsiiDeprecationWarnings.print("monocdk.pipelines.CdkPipeline#stage", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        return this._pipeline.stage(stageName);
    }
    /**
     * Get a cached version of an Application Security Check, which consists of:
     *  - CodeBuild Project to check for security changes in a stage
     *  - Lambda Function that approves the manual approval if no security changes are detected
     *
     * @internal
     */
    _getApplicationSecurityCheck() {
        if (!this._applicationSecurityCheck) {
            this._applicationSecurityCheck = new application_security_check_1.ApplicationSecurityCheck(this, 'PipelineApplicationSecurityCheck', {
                codePipeline: this._pipeline,
            });
        }
        return this._applicationSecurityCheck;
    }
    /**
     * Add pipeline stage that will deploy the given application stage
     *
     * The application construct should subclass `Stage` and can contain any
     * number of `Stacks` inside it that may have dependency relationships
     * on one another.
     *
     * All stacks in the application will be deployed in the appropriate order,
     * and all assets found in the application will be added to the asset
     * publishing stage.
     */
    addApplicationStage(appStage, options = {}) {
        jsiiDeprecationWarnings.print("monocdk.pipelines.CdkPipeline#addApplicationStage", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        jsiiDeprecationWarnings.monocdk_Stage(appStage);
        jsiiDeprecationWarnings.monocdk_pipelines_AddStageOptions(options);
        const stage = this.addStage(appStage.stageName, options);
        stage.addApplication(appStage, options);
        return stage;
    }
    /**
     * Add a new, empty stage to the pipeline
     *
     * Prefer to use `addApplicationStage` if you are intended to deploy a CDK
     * application, but you can use this method if you want to add other kinds of
     * Actions to a pipeline.
     */
    addStage(stageName, options) {
        jsiiDeprecationWarnings.print("monocdk.pipelines.CdkPipeline#addStage", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        jsiiDeprecationWarnings.monocdk_pipelines_BaseStageOptions(options);
        const pipelineStage = this._pipeline.addStage({
            stageName,
        });
        const stage = new stage_1.CdkStage(this, stageName, {
            cloudAssemblyArtifact: this._cloudAssemblyArtifact,
            pipelineStage,
            stageName,
            host: {
                publishAsset: this._assets.addPublishAssetAction.bind(this._assets),
                stackOutputArtifact: (artifactId) => this._outputArtifacts[artifactId],
            },
            ...options,
        });
        this._stages.push(stage);
        return stage;
    }
    /**
     * Get the StackOutput object that holds this CfnOutput's value in this pipeline
     *
     * `StackOutput` can be used in validation actions later in the pipeline.
     */
    stackOutput(cfnOutput) {
        jsiiDeprecationWarnings.print("monocdk.pipelines.CdkPipeline#stackOutput", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        jsiiDeprecationWarnings.monocdk_CfnOutput(cfnOutput);
        const stack = core_1.Stack.of(cfnOutput);
        if (!this._outputArtifacts[stack.artifactId]) {
            // We should have stored the ArtifactPath in the map, but its Artifact
            // property isn't publicly readable...
            const artifactName = `${stack.artifactId}_Outputs`;
            const compactName = artifactName.slice(artifactName.length - Math.min(artifactName.length, CODE_BUILD_LENGTH_LIMIT));
            this._outputArtifacts[stack.artifactId] = new codepipeline.Artifact(compactName);
        }
        return new stage_1.StackOutput(this._outputArtifacts[stack.artifactId].atPath('outputs.json'), cfnOutput.logicalId);
    }
    /**
     * Validate that we don't have any stacks violating dependency order in the pipeline
     *
     * Our own convenience methods will never generate a pipeline that does that (although
     * this is a nice verification), but a user can also add the stacks by hand.
     */
    validate() {
        jsiiDeprecationWarnings.print("monocdk.pipelines.CdkPipeline#validate", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        const ret = new Array();
        ret.push(...this.validateDeployOrder());
        ret.push(...this.validateRequestedOutputs());
        return ret;
    }
    /**
     * Return all StackDeployActions in an ordered list
     */
    get stackActions() {
        return flatMap(this._pipeline.stages, s => s.actions.filter(isDeployAction));
    }
    *validateDeployOrder() {
        const stackActions = this.stackActions;
        for (const stackAction of stackActions) {
            // For every dependency, it must be executed in an action before this one is prepared.
            for (const depId of stackAction.dependencyStackArtifactIds) {
                const depAction = stackActions.find(s => s.stackArtifactId === depId);
                if (depAction === undefined) {
                    core_1.Annotations.of(this).addWarning(`Stack '${stackAction.stackName}' depends on stack ` +
                        `'${depId}', but that dependency is not deployed through the pipeline!`);
                }
                else if (!(depAction.executeRunOrder < stackAction.prepareRunOrder)) {
                    yield `Stack '${stackAction.stackName}' depends on stack ` +
                        `'${depAction.stackName}', but is deployed before it in the pipeline!`;
                }
            }
        }
    }
    *validateRequestedOutputs() {
        const artifactIds = this.stackActions.map(s => s.stackArtifactId);
        for (const artifactId of Object.keys(this._outputArtifacts)) {
            if (!artifactIds.includes(artifactId)) {
                yield `Trying to use outputs for Stack '${artifactId}', but Stack is not deployed in this pipeline. Add it to the pipeline.`;
            }
        }
    }
}
exports.CdkPipeline = CdkPipeline;
_a = JSII_RTTI_SYMBOL_1;
CdkPipeline[_a] = { fqn: "monocdk.pipelines.CdkPipeline", version: "1.149.0" };
function isDeployAction(a) {
    return a instanceof actions_1.DeployCdkStackAction;
}
function flatMap(xs, f) {
    return Array.prototype.concat([], ...xs.map(f));
}
/**
 * Add appropriate publishing actions to the asset publishing stage
 */
class AssetPublishing extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        // CodePipelines has a hard limit of 50 actions per stage. See https://github.com/aws/aws-cdk/issues/9353
        this.MAX_PUBLISHERS_PER_STAGE = 50;
        this.publishers = {};
        this.assetRoles = {};
        this.assetAttachedPolicies = {};
        this.assetPublishingRoles = {};
        this.stages = [];
        this._fileAssetCtr = 0;
        this._dockerAssetCtr = 0;
        this.myCxAsmRoot = path.resolve(construct_internals_1.assemblyBuilderOf(construct_internals_1.appOf(this)).outdir);
        this.pipeline = this.props.pipeline;
        // Hacks to get access to the innards of Pipeline
        const stages = this.props.pipeline._stages;
        // Any asset publishing stages will be added directly after the last stage that currently exists.
        this.lastStageBeforePublishing = stages.slice(-1)[0];
        this.dockerCredentials = props.dockerCredentials;
    }
    /**
     * Make sure there is an action in the stage to publish the given asset
     *
     * Assets are grouped by asset ID (which represent individual assets) so all assets
     * are published in parallel. For each assets, all destinations are published sequentially
     * so that we can reuse expensive operations between them (mostly: building a Docker image).
     */
    addPublishAssetAction(command) {
        var _b, _c, _d;
        // FIXME: this is silly, we need the relative path here but no easy way to get it
        const relativePath = path.relative(this.myCxAsmRoot, command.assetManifestPath);
        // The path cannot be outside the asm root. I don't really understand how this could ever
        // come to pass, but apparently it has (see https://github.com/aws/aws-cdk/issues/9766).
        // Add a sanity check here so we can catch it more quickly next time.
        if (relativePath.startsWith(`..${path.sep}`)) {
            throw new Error(`The asset manifest (${command.assetManifestPath}) cannot be outside the Cloud Assembly directory (${this.myCxAsmRoot}). Please report this error at https://github.com/aws/aws-cdk/issues to help us debug why this is happening.`);
        }
        // Late-binding here (rather than in the constructor) to prevent creating the role in cases where no asset actions are created.
        if (!this.assetRoles[command.assetType]) {
            this.generateAssetRole(command.assetType);
        }
        this.assetPublishingRoles[command.assetType] = ((_b = this.assetPublishingRoles[command.assetType]) !== null && _b !== void 0 ? _b : new Set()).add(command.assetPublishingRoleArn);
        const publisherKey = this.props.singlePublisherPerType ? command.assetType.toString() : command.assetId;
        let action = this.publishers[publisherKey];
        if (!action) {
            // Dynamically create new stages as needed, with `MAX_PUBLISHERS_PER_STAGE` assets per stage.
            const stageIndex = this.props.singlePublisherPerType ? 0 :
                Math.floor((this._fileAssetCtr + this._dockerAssetCtr) / this.MAX_PUBLISHERS_PER_STAGE);
            if (!this.props.singlePublisherPerType && stageIndex >= this.stages.length) {
                const previousStage = (_c = this.stages.slice(-1)[0]) !== null && _c !== void 0 ? _c : this.lastStageBeforePublishing;
                this.stages.push(this.pipeline.addStage({
                    stageName: `Assets${stageIndex > 0 ? stageIndex + 1 : ''}`,
                    placement: { justAfter: previousStage },
                }));
            }
            else if (this.props.singlePublisherPerType && this.stages.length == 0) {
                this.stages.push(this.pipeline.addStage({
                    stageName: 'Assets',
                    placement: { justAfter: this.lastStageBeforePublishing },
                }));
            }
            // The asset ID would be a logical candidate for the construct path and project names, but if the asset
            // changes it leads to recreation of a number of Role/Policy/Project resources which is slower than
            // necessary. Number sequentially instead.
            //
            // FIXME: The ultimate best solution is probably to generate a single Project per asset type
            // and reuse that for all assets.
            const id = this.props.singlePublisherPerType ?
                command.assetType === asset_type_1.AssetType.FILE ? 'FileAsset' : 'DockerAsset' :
                command.assetType === asset_type_1.AssetType.FILE ? `FileAsset${++this._fileAssetCtr}` : `DockerAsset${++this._dockerAssetCtr}`;
            const credsInstallCommands = docker_credentials_1.dockerCredentialsInstallCommands(docker_credentials_1.DockerCredentialUsage.ASSET_PUBLISHING, this.dockerCredentials);
            // NOTE: It's important that asset changes don't force a pipeline self-mutation.
            // This can cause an infinite loop of updates (see https://github.com/aws/aws-cdk/issues/9080).
            // For that reason, we use the id as the actionName below, rather than the asset hash.
            action = this.publishers[publisherKey] = new actions_1.PublishAssetsAction(this, id, {
                actionName: id,
                cloudAssemblyInput: this.props.cloudAssemblyInput,
                cdkCliVersion: this.props.cdkCliVersion,
                assetType: command.assetType,
                role: this.assetRoles[command.assetType],
                dependable: this.assetAttachedPolicies[command.assetType],
                vpc: this.props.vpc,
                subnetSelection: this.props.subnetSelection,
                buildSpec: this.props.buildSpec,
                createBuildspecFile: this.props.singlePublisherPerType,
                preInstallCommands: [...((_d = this.props.preInstallCommands) !== null && _d !== void 0 ? _d : []), ...credsInstallCommands],
            });
            this.stages[stageIndex].addAction(action);
        }
        action.addPublishCommand(relativePath, command.assetSelector);
    }
    /**
     * This role is used by both the CodePipeline build action and related CodeBuild project. Consolidating these two
     * roles into one, and re-using across all assets, saves significant size of the final synthesized output.
     * Modeled after the CodePipeline role and 'CodePipelineActionRole' roles.
     * Generates one role per asset type to separate file and Docker/image-based permissions.
     */
    generateAssetRole(assetType) {
        if (this.assetRoles[assetType]) {
            return this.assetRoles[assetType];
        }
        const rolePrefix = assetType === asset_type_1.AssetType.DOCKER_IMAGE ? 'Docker' : 'File';
        const assetRole = new asset_singleton_role_1.AssetSingletonRole(this, `${rolePrefix}Role`, {
            roleName: core_1.PhysicalName.GENERATE_IF_NEEDED,
            assumedBy: new iam.CompositePrincipal(new iam.ServicePrincipal('codebuild.amazonaws.com'), new iam.AccountPrincipal(core_1.Stack.of(this).account)),
        });
        // Publishing role access
        // The ARNs include raw AWS pseudo parameters (e.g., ${AWS::Partition}), which need to be substituted.
        // Lazy-evaluated so all asset publishing roles are included.
        assetRole.addToPolicy(new iam.PolicyStatement({
            actions: ['sts:AssumeRole'],
            resources: core_1.Lazy.list({ produce: () => [...this.assetPublishingRoles[assetType]].map(arn => core_1.Fn.sub(arn)) }),
        }));
        // Grant pull access for any ECR registries and secrets that exist
        if (assetType === asset_type_1.AssetType.DOCKER_IMAGE) {
            this.dockerCredentials.forEach(reg => reg.grantRead(assetRole, docker_credentials_1.DockerCredentialUsage.ASSET_PUBLISHING));
        }
        this.assetRoles[assetType] = assetRole;
        return this.assetRoles[assetType];
    }
}
function maybeSuffix(x, suffix) {
    if (x === undefined) {
        return undefined;
    }
    return `${x}${suffix}`;
}
//# sourceMappingURL=data:application/json;base64,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