"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdatePipelineAction = void 0;
const jsiiDeprecationWarnings = require("../../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codebuild = require("../../../../aws-codebuild");
const cpactions = require("../../../../aws-codepipeline-actions");
const iam = require("../../../../aws-iam");
const core_1 = require("../../../../core");
const docker_credentials_1 = require("../../docker-credentials");
const construct_internals_1 = require("../../private/construct-internals");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("../../../../core");
/**
 * Action to self-mutate the pipeline
 *
 * Creates a CodeBuild project which will use the CDK CLI
 * to deploy the pipeline stack.
 *
 * You do not need to instantiate this action -- it will automatically
 * be added by the pipeline.
 *
 * @deprecated This class is part of the old API. Use the API based on the `CodePipeline` class instead
 */
class UpdatePipelineAction extends core_2.Construct {
    constructor(scope, id, props) {
        var _b, _c, _d;
        super(scope, id);
        jsiiDeprecationWarnings.print("monocdk.pipelines.UpdatePipelineAction", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        jsiiDeprecationWarnings.monocdk_pipelines_UpdatePipelineActionProps(props);
        const installSuffix = props.cdkCliVersion ? `@${props.cdkCliVersion}` : '';
        const stackIdentifier = (_b = props.pipelineStackHierarchicalId) !== null && _b !== void 0 ? _b : props.pipelineStackName;
        const buildSpec = codebuild.BuildSpec.fromObject({
            version: '0.2',
            phases: {
                install: {
                    commands: [
                        `npm install -g aws-cdk${installSuffix}`,
                        ...docker_credentials_1.dockerCredentialsInstallCommands(docker_credentials_1.DockerCredentialUsage.SELF_UPDATE, props.dockerCredentials),
                    ],
                },
                build: {
                    commands: [
                        // Cloud Assembly is in *current* directory.
                        `cdk -a ${construct_internals_1.embeddedAsmPath(scope)} deploy ${stackIdentifier} --require-approval=never --verbose`,
                    ],
                },
            },
        });
        const selfMutationProject = new codebuild.PipelineProject(this, 'SelfMutation', {
            projectName: props.projectName,
            environment: {
                buildImage: codebuild.LinuxBuildImage.STANDARD_5_0,
                privileged: (_c = props.privileged) !== null && _c !== void 0 ? _c : false,
            },
            buildSpec: props.buildSpec ? codebuild.mergeBuildSpecs(props.buildSpec, buildSpec) : buildSpec,
        });
        // allow the self-mutating project permissions to assume the bootstrap Action role
        selfMutationProject.addToRolePolicy(new iam.PolicyStatement({
            actions: ['sts:AssumeRole'],
            resources: [`arn:*:iam::${core_1.Stack.of(this).account}:role/*`],
            conditions: {
                'ForAnyValue:StringEquals': {
                    'iam:ResourceTag/aws-cdk:bootstrap-role': ['image-publishing', 'file-publishing', 'deploy'],
                },
            },
        }));
        selfMutationProject.addToRolePolicy(new iam.PolicyStatement({
            actions: ['cloudformation:DescribeStacks'],
            resources: ['*'],
        }));
        // S3 checks for the presence of the ListBucket permission
        selfMutationProject.addToRolePolicy(new iam.PolicyStatement({
            actions: ['s3:ListBucket'],
            resources: ['*'],
        }));
        ((_d = props.dockerCredentials) !== null && _d !== void 0 ? _d : []).forEach(reg => reg.grantRead(selfMutationProject, docker_credentials_1.DockerCredentialUsage.SELF_UPDATE));
        this.action = new cpactions.CodeBuildAction({
            actionName: 'SelfMutate',
            input: props.cloudAssemblyInput,
            project: selfMutationProject,
            // Add this purely so that the pipeline will selfupdate if the CLI version changes
            environmentVariables: props.cdkCliVersion ? {
                CDK_CLI_VERSION: { value: props.cdkCliVersion },
            } : undefined,
        });
    }
    /**
     * Exists to implement IAction
     */
    bind(scope, stage, options) {
        jsiiDeprecationWarnings.print("monocdk.pipelines.UpdatePipelineAction#bind", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_codepipeline_IStage(stage);
        jsiiDeprecationWarnings.monocdk_aws_codepipeline_ActionBindOptions(options);
        return this.action.bind(scope, stage, options);
    }
    /**
     * Exists to implement IAction
     */
    onStateChange(name, target, options) {
        jsiiDeprecationWarnings.print("monocdk.pipelines.UpdatePipelineAction#onStateChange", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        jsiiDeprecationWarnings.monocdk_aws_events_IRuleTarget(target);
        jsiiDeprecationWarnings.monocdk_aws_events_RuleProps(options);
        return this.action.onStateChange(name, target, options);
    }
    /**
     * Exists to implement IAction
     */
    get actionProperties() {
        jsiiDeprecationWarnings.print("monocdk.pipelines.UpdatePipelineAction#actionProperties", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        // FIXME: I have had to make this class a Construct, because:
        //
        // - It needs access to the Construct tree, because it is going to add a `PipelineProject`.
        // - I would have liked to have done that in bind(), however,
        // - `actionProperties` (this method) is called BEFORE bind() is called, and by that point I
        //   don't have the "inner" Action yet to forward the call to.
        //
        // I've therefore had to construct the inner CodeBuildAction in the constructor, which requires making this
        // Action a Construct.
        //
        // Combined with how non-intuitive it is to make the "StackDeployAction", I feel there is something
        // wrong with the Action abstraction here.
        return this.action.actionProperties;
    }
}
exports.UpdatePipelineAction = UpdatePipelineAction;
_a = JSII_RTTI_SYMBOL_1;
UpdatePipelineAction[_a] = { fqn: "monocdk.pipelines.UpdatePipelineAction", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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