import * as codebuild from '../../../../aws-codebuild';
import * as codepipeline from '../../../../aws-codepipeline';
import * as events from '../../../../aws-events';
import { Construct } from 'constructs';
import { DockerCredential } from '../../docker-credentials';
import { Construct as CoreConstruct } from '../../../../core';
/**
 * Props for the UpdatePipelineAction
 *
 * @deprecated This class is part of the old API. Use the API based on the `CodePipeline` class instead
 */
export interface UpdatePipelineActionProps {
    /**
     * The CodePipeline artifact that holds the Cloud Assembly.
     */
    readonly cloudAssemblyInput: codepipeline.Artifact;
    /**
     * Name of the pipeline stack
     *
     * @deprecated - Use `pipelineStackHierarchicalId` instead.
     * @default - none
     */
    readonly pipelineStackName?: string;
    /**
     * Hierarchical id of the pipeline stack
     */
    readonly pipelineStackHierarchicalId: string;
    /**
     * Version of CDK CLI to 'npm install'.
     *
     * @default - Latest version
     */
    readonly cdkCliVersion?: string;
    /**
     * Name of the CodeBuild project
     *
     * @default - Automatically generated
     */
    readonly projectName?: string;
    /**
     * Whether the build step should run in privileged mode.
     *
     * @default - false
     */
    readonly privileged?: boolean;
    /**
     * Docker registries and associated credentials necessary during the pipeline
     * self-update stage.
     *
     * @default []
     */
    readonly dockerCredentials?: DockerCredential[];
    /**
     * Custom BuildSpec that is merged with generated one
     *
     * @default - none
     */
    readonly buildSpec?: codebuild.BuildSpec;
}
/**
 * Action to self-mutate the pipeline
 *
 * Creates a CodeBuild project which will use the CDK CLI
 * to deploy the pipeline stack.
 *
 * You do not need to instantiate this action -- it will automatically
 * be added by the pipeline.
 *
 * @deprecated This class is part of the old API. Use the API based on the `CodePipeline` class instead
 */
export declare class UpdatePipelineAction extends CoreConstruct implements codepipeline.IAction {
    private readonly action;
    constructor(scope: Construct, id: string, props: UpdatePipelineActionProps);
    /**
     * Exists to implement IAction
     */
    bind(scope: CoreConstruct, stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
    /**
     * Exists to implement IAction
     */
    onStateChange(name: string, target?: events.IRuleTarget, options?: events.RuleProps): events.Rule;
    /**
     * Exists to implement IAction
     */
    get actionProperties(): codepipeline.ActionProperties;
}
