"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PublishAssetsAction = void 0;
const jsiiDeprecationWarnings = require("../../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const codebuild = require("../../../../aws-codebuild");
const codepipeline_actions = require("../../../../aws-codepipeline-actions");
const core_1 = require("../../../../core");
const asset_type_1 = require("../../blueprint/asset-type");
const fs_1 = require("../../private/fs");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("../../../../core");
/**
 * Action to publish an asset in the pipeline
 *
 * Creates a CodeBuild project which will use the CDK CLI
 * to prepare and publish the asset.
 *
 * You do not need to instantiate this action -- it will automatically
 * be added by the pipeline when you add stacks that use assets.
 *
 * @deprecated This class is part of the old API. Use the API based on the `CodePipeline` class instead
 */
class PublishAssetsAction extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        this.commands = new Array();
        jsiiDeprecationWarnings.print("monocdk.pipelines.PublishAssetsAction", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        jsiiDeprecationWarnings.monocdk_pipelines_PublishAssetsActionProps(props);
        const installSuffix = props.cdkCliVersion ? `@${props.cdkCliVersion}` : '';
        const installCommand = `npm install -g cdk-assets${installSuffix}`;
        const buildSpec = codebuild.BuildSpec.fromObject({
            version: '0.2',
            phases: {
                install: {
                    commands: props.preInstallCommands ? [...props.preInstallCommands, installCommand] : installCommand,
                },
                build: {
                    commands: core_1.Lazy.list({ produce: () => this.commands }),
                },
            },
        });
        this.buildSpec = props.buildSpec ? codebuild.mergeBuildSpecs(props.buildSpec, buildSpec) : buildSpec;
        const project = new codebuild.PipelineProject(this, 'Default', {
            projectName: this.props.projectName,
            environment: {
                buildImage: codebuild.LinuxBuildImage.STANDARD_5_0,
                privileged: (props.assetType === asset_type_1.AssetType.DOCKER_IMAGE) ? true : undefined,
            },
            vpc: props.vpc,
            subnetSelection: props.subnetSelection,
            buildSpec: props.createBuildspecFile ? codebuild.BuildSpec.fromSourceFilename(this.getBuildSpecFileName()) : this.buildSpec,
            role: props.role,
        });
        if (props.dependable) {
            project.node.addDependency(props.dependable);
        }
        this.action = new codepipeline_actions.CodeBuildAction({
            actionName: props.actionName,
            project,
            input: this.props.cloudAssemblyInput,
            role: props.role,
            // Add this purely so that the pipeline will selfupdate if the CLI version changes
            environmentVariables: props.cdkCliVersion ? {
                CDK_CLI_VERSION: { value: props.cdkCliVersion },
            } : undefined,
        });
        core_1.attachCustomSynthesis(this, {
            onSynthesize: this._onSynth.bind(this),
        });
    }
    getBuildSpecFileName() {
        return `buildspec-assets-${this.node.path.replace(new RegExp('/', 'g'), '-')}.yaml`;
    }
    _onSynth(session) {
        if (this.props.createBuildspecFile) {
            const specFile = path.join(session.outdir, this.getBuildSpecFileName());
            fs.writeFileSync(specFile, core_1.Stack.of(this).resolve(this.buildSpec.toBuildSpec()), { encoding: 'utf-8' });
        }
    }
    /**
     * Add a single publishing command
     *
     * Manifest path should be relative to the root Cloud Assembly.
     */
    addPublishCommand(relativeManifestPath, assetSelector) {
        jsiiDeprecationWarnings.print("monocdk.pipelines.PublishAssetsAction#addPublishCommand", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        const command = `cdk-assets --path "${fs_1.toPosixPath(relativeManifestPath)}" --verbose publish "${assetSelector}"`;
        if (!this.commands.includes(command)) {
            this.commands.push(command);
        }
    }
    /**
     * Exists to implement IAction
     */
    bind(scope, stage, options) {
        jsiiDeprecationWarnings.print("monocdk.pipelines.PublishAssetsAction#bind", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_codepipeline_IStage(stage);
        jsiiDeprecationWarnings.monocdk_aws_codepipeline_ActionBindOptions(options);
        return this.action.bind(scope, stage, options);
    }
    /**
     * Exists to implement IAction
     */
    onStateChange(name, target, options) {
        jsiiDeprecationWarnings.print("monocdk.pipelines.PublishAssetsAction#onStateChange", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        jsiiDeprecationWarnings.monocdk_aws_events_IRuleTarget(target);
        jsiiDeprecationWarnings.monocdk_aws_events_RuleProps(options);
        return this.action.onStateChange(name, target, options);
    }
    /**
     * Exists to implement IAction
     */
    get actionProperties() {
        jsiiDeprecationWarnings.print("monocdk.pipelines.PublishAssetsAction#actionProperties", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        // FIXME: I have had to make this class a Construct, because:
        //
        // - It needs access to the Construct tree, because it is going to add a `PipelineProject`.
        // - I would have liked to have done that in bind(), however,
        // - `actionProperties` (this method) is called BEFORE bind() is called, and by that point I
        //   don't have the "inner" Action yet to forward the call to.
        //
        // I've therefore had to construct the inner CodeBuildAction in the constructor, which requires making this
        // Action a Construct.
        //
        // Combined with how non-intuitive it is to make the "StackDeployAction", I feel there is something
        // wrong with the Action abstraction here.
        return this.action.actionProperties;
    }
}
exports.PublishAssetsAction = PublishAssetsAction;
_a = JSII_RTTI_SYMBOL_1;
PublishAssetsAction[_a] = { fqn: "monocdk.pipelines.PublishAssetsAction", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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