"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeployCdkStackAction = void 0;
const jsiiDeprecationWarnings = require("../../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const cpactions = require("../../../../aws-codepipeline-actions");
const iam = require("../../../../aws-iam");
const core_1 = require("../../../../core");
const cxapi = require("../../../../cx-api");
const constructs_1 = require("constructs");
const construct_internals_1 = require("../../private/construct-internals");
const fs_1 = require("../../private/fs");
/**
 * Action to deploy a CDK Stack
 *
 * Adds two CodePipeline Actions to the pipeline: one to create a ChangeSet
 * and one to execute it.
 *
 * You do not need to instantiate this action yourself -- it will automatically
 * be added by the pipeline when you add stack artifacts or entire stages.
 *
 * @deprecated This class is part of the old API. Use the API based on the `CodePipeline` class instead
 */
class DeployCdkStackAction {
    constructor(props) {
        var _b, _c, _d, _e, _f;
        jsiiDeprecationWarnings.print("monocdk.pipelines.DeployCdkStackAction", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        jsiiDeprecationWarnings.monocdk_pipelines_DeployCdkStackActionProps(props);
        if (props.output && !props.outputFileName) {
            throw new Error('If \'output\' is set, \'outputFileName\' is also required');
        }
        this.stackArtifactId = props.stackArtifactId;
        this.dependencyStackArtifactIds = (_b = props.dependencyStackArtifactIds) !== null && _b !== void 0 ? _b : [];
        this.prepareRunOrder = (_c = props.prepareRunOrder) !== null && _c !== void 0 ? _c : 1;
        this.executeRunOrder = (_d = props.executeRunOrder) !== null && _d !== void 0 ? _d : this.prepareRunOrder + 1;
        this.stackName = props.stackName;
        const baseActionName = (_e = props.baseActionName) !== null && _e !== void 0 ? _e : this.stackName;
        const changeSetName = (_f = props.changeSetName) !== null && _f !== void 0 ? _f : 'PipelineChange';
        this.prepareChangeSetAction = new cpactions.CloudFormationCreateReplaceChangeSetAction({
            actionName: `${baseActionName}.Prepare`,
            changeSetName,
            runOrder: this.prepareRunOrder,
            stackName: this.stackName,
            templatePath: props.cloudAssemblyInput.atPath(props.templatePath),
            adminPermissions: false,
            role: props.actionRole,
            deploymentRole: props.cloudFormationExecutionRole,
            region: props.region,
            cfnCapabilities: [core_1.CfnCapabilities.NAMED_IAM, core_1.CfnCapabilities.AUTO_EXPAND],
            templateConfiguration: props.templateConfigurationPath ? props.cloudAssemblyInput.atPath(props.templateConfigurationPath) : undefined,
        });
        this.executeChangeSetAction = new cpactions.CloudFormationExecuteChangeSetAction({
            actionName: `${baseActionName}.Deploy`,
            changeSetName,
            runOrder: this.executeRunOrder,
            stackName: this.stackName,
            role: props.actionRole,
            region: props.region,
            outputFileName: props.outputFileName,
            output: props.output,
        });
    }
    /**
     * Construct a DeployCdkStackAction from a Stack artifact
     */
    static fromStackArtifact(scope, artifact, options) {
        var _b;
        jsiiDeprecationWarnings.print("monocdk.pipelines.DeployCdkStackAction#fromStackArtifact", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        jsiiDeprecationWarnings.monocdk_cx_api_CloudFormationStackArtifact(artifact);
        jsiiDeprecationWarnings.monocdk_pipelines_CdkStackActionFromArtifactOptions(options);
        if (!artifact.assumeRoleArn) {
            throw new Error(`Stack '${artifact.stackName}' does not have deployment role information; use the 'DefaultStackSynthesizer' synthesizer, or set the '@aws-cdk/core:newStyleStackSynthesis' context key.`);
        }
        const artRegion = artifact.environment.region;
        const region = artRegion === core_1.Stack.of(scope).region || artRegion === cxapi.UNKNOWN_REGION ? undefined : artRegion;
        const artAccount = artifact.environment.account;
        const account = artAccount === core_1.Stack.of(scope).account || artAccount === cxapi.UNKNOWN_ACCOUNT ? undefined : artAccount;
        const actionRole = roleFromPlaceholderArn(scope, region, account, artifact.assumeRoleArn);
        const cloudFormationExecutionRole = roleFromPlaceholderArn(scope, region, account, artifact.cloudFormationExecutionRoleArn);
        // We need the path of the template relative to the root Cloud Assembly
        // It should be easier to get this, but for now it is what it is.
        const appAsmRoot = construct_internals_1.assemblyBuilderOf(construct_internals_1.appOf(scope)).outdir;
        const fullTemplatePath = path.join(artifact.assembly.directory, artifact.templateFile);
        let fullConfigPath;
        if (Object.keys(artifact.tags).length > 0) {
            fullConfigPath = `${fullTemplatePath}.config.json`;
            // Write the template configuration file (for parameters into CreateChangeSet call that
            // cannot be configured any other way). They must come from a file, and there's unfortunately
            // no better hook to write this file (`construct.onSynthesize()` would have been the prime candidate
            // but that is being deprecated--and DeployCdkStackAction isn't even a construct).
            writeTemplateConfiguration(fullConfigPath, {
                Tags: artifact.tags,
            });
        }
        return new DeployCdkStackAction({
            actionRole,
            cloudFormationExecutionRole,
            templatePath: fs_1.toPosixPath(path.relative(appAsmRoot, fullTemplatePath)),
            templateConfigurationPath: fullConfigPath ? fs_1.toPosixPath(path.relative(appAsmRoot, fullConfigPath)) : undefined,
            region,
            stackArtifactId: artifact.id,
            dependencyStackArtifactIds: artifact.dependencies.filter(isStackArtifact).map(s => s.id),
            stackName: (_b = options.stackName) !== null && _b !== void 0 ? _b : artifact.stackName,
            ...options,
        });
    }
    /**
     * Exists to implement IAction
     */
    bind(scope, stage, options) {
        jsiiDeprecationWarnings.print("monocdk.pipelines.DeployCdkStackAction#bind", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_codepipeline_IStage(stage);
        jsiiDeprecationWarnings.monocdk_aws_codepipeline_ActionBindOptions(options);
        stage.addAction(this.prepareChangeSetAction);
        return this.executeChangeSetAction.bind(scope, stage, options);
    }
    /**
     * Exists to implement IAction
     */
    onStateChange(name, target, options) {
        jsiiDeprecationWarnings.print("monocdk.pipelines.DeployCdkStackAction#onStateChange", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        jsiiDeprecationWarnings.monocdk_aws_events_IRuleTarget(target);
        jsiiDeprecationWarnings.monocdk_aws_events_RuleProps(options);
        return this.executeChangeSetAction.onStateChange(name, target, options);
    }
    /**
     * Exists to implement IAction
     */
    get actionProperties() {
        jsiiDeprecationWarnings.print("monocdk.pipelines.DeployCdkStackAction#actionProperties", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        return this.executeChangeSetAction.actionProperties;
    }
}
exports.DeployCdkStackAction = DeployCdkStackAction;
_a = JSII_RTTI_SYMBOL_1;
DeployCdkStackAction[_a] = { fqn: "monocdk.pipelines.DeployCdkStackAction", version: "1.149.0" };
function roleFromPlaceholderArn(scope, region, account, arn) {
    if (!arn) {
        return undefined;
    }
    // Use placeholdered arn as construct ID.
    const id = arn;
    // https://github.com/aws/aws-cdk/issues/7255
    let existingRole = constructs_1.Node.of(scope).tryFindChild(`ImmutableRole${id}`);
    if (existingRole) {
        return existingRole;
    }
    // For when #7255 is fixed.
    existingRole = constructs_1.Node.of(scope).tryFindChild(id);
    if (existingRole) {
        return existingRole;
    }
    const arnToImport = cxapi.EnvironmentPlaceholders.replace(arn, {
        region: region !== null && region !== void 0 ? region : core_1.Aws.REGION,
        accountId: account !== null && account !== void 0 ? account : core_1.Aws.ACCOUNT_ID,
        partition: core_1.Aws.PARTITION,
    });
    return iam.Role.fromRoleArn(scope, id, arnToImport, { mutable: false, addGrantsToResources: true });
}
function isStackArtifact(a) {
    // instanceof is too risky, and we're at a too late stage to properly fix.
    // return a instanceof cxapi.CloudFormationStackArtifact;
    return a.constructor.name === 'CloudFormationStackArtifact';
}
/**
 * Write template configuration to the given file
 */
function writeTemplateConfiguration(filename, config) {
    fs.writeFileSync(filename, JSON.stringify(config, undefined, 2), { encoding: 'utf-8' });
}
//# sourceMappingURL=data:application/json;base64,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