"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.topoSort = exports.printDependencyMap = void 0;
function printDependencyMap(dependencies) {
    const lines = ['---'];
    for (const [k, vs] of dependencies.entries()) {
        lines.push(`${k} -> ${Array.from(vs)}`);
    }
    // eslint-disable-next-line no-console
    console.log(lines.join('\n'));
}
exports.printDependencyMap = printDependencyMap;
function topoSort(nodes, dependencies) {
    const remaining = new Set(nodes);
    const ret = [];
    while (remaining.size > 0) {
        // All elements with no more deps in the set can be ordered
        const selectable = Array.from(remaining.values()).filter(e => {
            if (!dependencies.has(e)) {
                throw new Error(`No key for ${e}`);
            }
            return dependencies.get(e).size === 0;
        });
        selectable.sort((a, b) => a.id < b.id ? -1 : b.id < a.id ? 1 : 0);
        // If we didn't make any progress, we got stuck
        if (selectable.length === 0) {
            const cycle = findCycle(dependencies);
            throw new Error(`Dependency cycle in graph: ${cycle.map(n => n.id).join(' => ')}`);
        }
        ret.push(selectable);
        for (const selected of selectable) {
            remaining.delete(selected);
            for (const depSet of dependencies.values()) {
                depSet.delete(selected);
            }
        }
    }
    return ret;
}
exports.topoSort = topoSort;
/**
 * Find cycles in a graph
 *
 * Not the fastest, but effective and should be rare
 */
function findCycle(deps) {
    for (const node of deps.keys()) {
        const cycle = recurse(node, [node]);
        if (cycle) {
            return cycle;
        }
    }
    throw new Error('No cycle found. Assertion failure!');
    function recurse(node, path) {
        var _a;
        for (const dep of (_a = deps.get(node)) !== null && _a !== void 0 ? _a : []) {
            if (dep === path[0]) {
                return [...path, dep];
            }
            const cycle = recurse(dep, [...path, dep]);
            if (cycle) {
                return cycle;
            }
        }
        return undefined;
    }
}
//# sourceMappingURL=data:application/json;base64,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