"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.namespaceName = exports.namespaceStepOutputs = exports.makeCodePipelineOutput = void 0;
const helpers_internal_1 = require("../../helpers-internal");
const CODEPIPELINE_ENGINE_NAME = 'codepipeline';
function makeCodePipelineOutput(step, variableName) {
    return new helpers_internal_1.StepOutput(step, CODEPIPELINE_ENGINE_NAME, variableName).toString();
}
exports.makeCodePipelineOutput = makeCodePipelineOutput;
/**
 * If the step is producing outputs, determine a variableNamespace for it, and configure that on the outputs
 */
function namespaceStepOutputs(step, stage, name) {
    let ret;
    for (const output of helpers_internal_1.StepOutput.producedStepOutputs(step)) {
        ret = namespaceName(stage, name);
        if (output.engineName !== CODEPIPELINE_ENGINE_NAME) {
            throw new Error(`Found unrecognized output type: ${output.engineName}`);
        }
        if (typeof output.engineSpecificInformation !== 'string') {
            throw new Error(`CodePipeline requires that 'engineSpecificInformation' is a string, got: ${JSON.stringify(output.engineSpecificInformation)}`);
        }
        output.defineResolution(`#{${ret}.${output.engineSpecificInformation}}`);
    }
    return ret;
}
exports.namespaceStepOutputs = namespaceStepOutputs;
/**
 * Generate a variable namespace from stage and action names
 *
 * Variable namespaces cannot have '.', but they can have '@'. Other than that,
 * action names are more limited so they translate easily.
 */
function namespaceName(stage, name) {
    return `${stage.stageName}/${name}`.replace(/[^a-zA-Z0-9@_-]/g, '@');
}
exports.namespaceName = namespaceName;
//# sourceMappingURL=data:application/json;base64,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