"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Wave = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const stage_deployment_1 = require("./stage-deployment");
/**
 * Multiple stages that are deployed in parallel
 */
class Wave {
    constructor(
    /** Identifier for this Wave */
    id, props = {}) {
        var _b, _c;
        this.id = id;
        /**
         * The stages that are deployed in this wave
         */
        this.stages = [];
        jsiiDeprecationWarnings.monocdk_pipelines_WaveProps(props);
        this.pre = (_b = props.pre) !== null && _b !== void 0 ? _b : [];
        this.post = (_c = props.post) !== null && _c !== void 0 ? _c : [];
    }
    /**
     * Add a Stage to this wave
     *
     * It will be deployed in parallel with all other stages in this
     * wave.
     */
    addStage(stage, options = {}) {
        jsiiDeprecationWarnings.monocdk_Stage(stage);
        jsiiDeprecationWarnings.monocdk_pipelines_AddStageOpts(options);
        const ret = stage_deployment_1.StageDeployment.fromStage(stage, options);
        this.stages.push(ret);
        return ret;
    }
    /**
     * Add an additional step to run before any of the stages in this wave
     */
    addPre(...steps) {
        jsiiDeprecationWarnings.monocdk_pipelines_Step(steps);
        this.pre.push(...steps);
    }
    /**
     * Add an additional step to run after all of the stages in this wave
     */
    addPost(...steps) {
        jsiiDeprecationWarnings.monocdk_pipelines_Step(steps);
        this.post.push(...steps);
    }
}
exports.Wave = Wave;
_a = JSII_RTTI_SYMBOL_1;
Wave[_a] = { fqn: "monocdk.pipelines.Wave", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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