"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StackOutputReference = exports.ShellStep = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../../core");
const javascript_1 = require("../private/javascript");
const file_set_1 = require("./file-set");
const step_1 = require("./step");
/**
 * Run shell script commands in the pipeline. This is a generic step designed
 * to be deployment engine agnostic.
 */
class ShellStep extends step_1.Step {
    constructor(id, props) {
        var _c, _d, _e, _f;
        super(id);
        /**
         * Input FileSets
         *
         * A list of `(FileSet, directory)` pairs, which are a copy of the
         * input properties. This list should not be modified directly.
         */
        this.inputs = [];
        /**
         * Output FileSets
         *
         * A list of `(FileSet, directory)` pairs, which are a copy of the
         * input properties. This list should not be modified directly.
         */
        this.outputs = [];
        this._additionalOutputs = {};
        jsiiDeprecationWarnings.monocdk_pipelines_ShellStepProps(props);
        this.commands = props.commands;
        this.installCommands = (_c = props.installCommands) !== null && _c !== void 0 ? _c : [];
        this.env = (_d = props.env) !== null && _d !== void 0 ? _d : {};
        this.envFromCfnOutputs = javascript_1.mapValues((_e = props.envFromCfnOutputs) !== null && _e !== void 0 ? _e : {}, StackOutputReference.fromCfnOutput);
        // 'env' is the only thing that can contain outputs
        this.discoverReferencedOutputs({
            env: this.env,
        });
        // Inputs
        if (props.input) {
            const fileSet = props.input.primaryOutput;
            if (!fileSet) {
                throw new Error(`'${id}': primary input should be a step that produces a file set, got ${props.input}`);
            }
            this.addDependencyFileSet(fileSet);
            this.inputs.push({ directory: '.', fileSet });
        }
        for (const [directory, step] of Object.entries((_f = props.additionalInputs) !== null && _f !== void 0 ? _f : {})) {
            if (directory === '.') {
                throw new Error(`'${id}': input for directory '.' should be passed via 'input' property`);
            }
            const fileSet = step.primaryOutput;
            if (!fileSet) {
                throw new Error(`'${id}': additionalInput for directory '${directory}' should be a step that produces a file set, got ${step}`);
            }
            this.addDependencyFileSet(fileSet);
            this.inputs.push({ directory, fileSet });
        }
        // Outputs
        if (props.primaryOutputDirectory) {
            this._primaryOutputDirectory = props.primaryOutputDirectory;
            const fileSet = new file_set_1.FileSet('Output', this);
            this.configurePrimaryOutput(fileSet);
            this.outputs.push({ directory: props.primaryOutputDirectory, fileSet });
        }
    }
    /**
     * Configure the given output directory as primary output
     *
     * If no primary output has been configured yet, this directory
     * will become the primary output of this ShellStep, otherwise this
     * method will throw if the given directory is different than the
     * currently configured primary output directory.
     */
    primaryOutputDirectory(directory) {
        if (this._primaryOutputDirectory !== undefined) {
            if (this._primaryOutputDirectory !== directory) {
                throw new Error(`${this}: primaryOutputDirectory is '${this._primaryOutputDirectory}', cannot be changed to '${directory}'`);
            }
            return this.primaryOutput;
        }
        this._primaryOutputDirectory = directory;
        const fileSet = new file_set_1.FileSet('Output', this);
        this.configurePrimaryOutput(fileSet);
        this.outputs.push({ directory: directory, fileSet });
        return fileSet;
    }
    /**
     * Add an additional output FileSet based on a directory.
     *
     *
     * After running the script, the contents of the given directory
     * will be exported as a `FileSet`. Use the `FileSet` as the
     * input to another step.
     *
     * Multiple calls with the exact same directory name string (not normalized)
     * will return the same FileSet.
     */
    addOutputDirectory(directory) {
        let fileSet = this._additionalOutputs[directory];
        if (!fileSet) {
            fileSet = new file_set_1.FileSet(directory, this);
            this._additionalOutputs[directory] = fileSet;
            this.outputs.push({ directory, fileSet });
        }
        return fileSet;
    }
}
exports.ShellStep = ShellStep;
_a = JSII_RTTI_SYMBOL_1;
ShellStep[_a] = { fqn: "monocdk.pipelines.ShellStep", version: "1.149.0" };
/**
 * A Reference to a Stack Output
 */
class StackOutputReference {
    constructor(
    /** A human-readable description of the producing stack */
    stackDescription, 
    /** Artifact id of the producing stack */
    stackArtifactId, 
    /** Output name of the producing stack */
    outputName) {
        this.stackDescription = stackDescription;
        this.stackArtifactId = stackArtifactId;
        this.outputName = outputName;
    }
    /**
     * Create a StackOutputReference that references the given CfnOutput
     */
    static fromCfnOutput(output) {
        jsiiDeprecationWarnings.monocdk_CfnOutput(output);
        const stack = core_1.Stack.of(output);
        return new StackOutputReference(stack.node.path, stack.artifactId, stack.resolve(output.logicalId));
    }
    /**
     * Whether or not this stack output is being produced by the given Stack deployment
     */
    isProducedBy(stack) {
        jsiiDeprecationWarnings.monocdk_pipelines_StackDeployment(stack);
        return stack.stackArtifactId === this.stackArtifactId;
    }
}
exports.StackOutputReference = StackOutputReference;
_b = JSII_RTTI_SYMBOL_1;
StackOutputReference[_b] = { fqn: "monocdk.pipelines.StackOutputReference", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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