"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ManualApprovalStep = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const step_1 = require("./step");
/**
 * A manual approval step
 *
 * If this step is added to a Pipeline, the Pipeline will
 * be paused waiting for a human to resume it
 *
 * Only engines that support pausing the deployment will
 * support this step type.
 */
class ManualApprovalStep extends step_1.Step {
    constructor(id, props = {}) {
        super(id);
        jsiiDeprecationWarnings.monocdk_pipelines_ManualApprovalStepProps(props);
        this.comment = props.comment;
        this.discoverReferencedOutputs(props.comment);
    }
}
exports.ManualApprovalStep = ManualApprovalStep;
_a = JSII_RTTI_SYMBOL_1;
ManualApprovalStep[_a] = { fqn: "monocdk.pipelines.ManualApprovalStep", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWFudWFsLWFwcHJvdmFsLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsibWFudWFsLWFwcHJvdmFsLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBLGlDQUE4QjtBQWM5Qjs7Ozs7Ozs7R0FRRztBQUNILE1BQWEsa0JBQW1CLFNBQVEsV0FBSTtJQVExQyxZQUFZLEVBQVUsRUFBRSxRQUFpQyxFQUFFO1FBQ3pELEtBQUssQ0FBQyxFQUFFLENBQUMsQ0FBQzs7UUFFVixJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUM7UUFFN0IsSUFBSSxDQUFDLHlCQUF5QixDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQztLQUMvQzs7QUFkSCxnREFlQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFN0ZXAgfSBmcm9tICcuL3N0ZXAnO1xuXG4vKipcbiAqIENvbnN0cnVjdGlvbiBwcm9wZXJ0aWVzIGZvciBhIGBNYW51YWxBcHByb3ZhbFN0ZXBgXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgTWFudWFsQXBwcm92YWxTdGVwUHJvcHMge1xuICAvKipcbiAgICogVGhlIGNvbW1lbnQgdG8gZGlzcGxheSB3aXRoIHRoaXMgbWFudWFsIGFwcHJvdmFsXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gTm8gY29tbWVudFxuICAgKi9cbiAgcmVhZG9ubHkgY29tbWVudD86IHN0cmluZztcbn1cblxuLyoqXG4gKiBBIG1hbnVhbCBhcHByb3ZhbCBzdGVwXG4gKlxuICogSWYgdGhpcyBzdGVwIGlzIGFkZGVkIHRvIGEgUGlwZWxpbmUsIHRoZSBQaXBlbGluZSB3aWxsXG4gKiBiZSBwYXVzZWQgd2FpdGluZyBmb3IgYSBodW1hbiB0byByZXN1bWUgaXRcbiAqXG4gKiBPbmx5IGVuZ2luZXMgdGhhdCBzdXBwb3J0IHBhdXNpbmcgdGhlIGRlcGxveW1lbnQgd2lsbFxuICogc3VwcG9ydCB0aGlzIHN0ZXAgdHlwZS5cbiAqL1xuZXhwb3J0IGNsYXNzIE1hbnVhbEFwcHJvdmFsU3RlcCBleHRlbmRzIFN0ZXAge1xuICAvKipcbiAgICogVGhlIGNvbW1lbnQgYXNzb2NpYXRlZCB3aXRoIHRoaXMgbWFudWFsIGFwcHJvdmFsXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gTm8gY29tbWVudFxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IGNvbW1lbnQ/OiBzdHJpbmc7XG5cbiAgY29uc3RydWN0b3IoaWQ6IHN0cmluZywgcHJvcHM6IE1hbnVhbEFwcHJvdmFsU3RlcFByb3BzID0ge30pIHtcbiAgICBzdXBlcihpZCk7XG5cbiAgICB0aGlzLmNvbW1lbnQgPSBwcm9wcy5jb21tZW50O1xuXG4gICAgdGhpcy5kaXNjb3ZlclJlZmVyZW5jZWRPdXRwdXRzKHByb3BzLmNvbW1lbnQpO1xuICB9XG59Il19