"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Provider = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const lambda = require("../../../aws-lambda");
const core_1 = require("../../../core");
const consts = require("./runtime/consts");
const util_1 = require("./util");
const waiter_state_machine_1 = require("./waiter-state-machine");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main",
// eslint-disable-next-line
const core_2 = require("../../../core");
const RUNTIME_HANDLER_PATH = path.join(__dirname, 'runtime');
const FRAMEWORK_HANDLER_TIMEOUT = core_1.Duration.minutes(15); // keep it simple for now
/**
 * Defines an AWS CloudFormation custom resource provider.
 */
class Provider extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        jsiiDeprecationWarnings.monocdk_custom_resources_ProviderProps(props);
        if (!props.isCompleteHandler && (props.queryInterval || props.totalTimeout)) {
            throw new Error('"queryInterval" and "totalTimeout" can only be configured if "isCompleteHandler" is specified. '
                + 'Otherwise, they have no meaning');
        }
        this.onEventHandler = props.onEventHandler;
        this.isCompleteHandler = props.isCompleteHandler;
        this.logRetention = props.logRetention;
        this.vpc = props.vpc;
        this.vpcSubnets = props.vpcSubnets;
        this.securityGroups = props.securityGroups;
        this.role = props.role;
        const onEventFunction = this.createFunction(consts.FRAMEWORK_ON_EVENT_HANDLER_NAME, props.providerFunctionName);
        if (this.isCompleteHandler) {
            const isCompleteFunction = this.createFunction(consts.FRAMEWORK_IS_COMPLETE_HANDLER_NAME);
            const timeoutFunction = this.createFunction(consts.FRAMEWORK_ON_TIMEOUT_HANDLER_NAME);
            const retry = util_1.calculateRetryPolicy(props);
            const waiterStateMachine = new waiter_state_machine_1.WaiterStateMachine(this, 'waiter-state-machine', {
                isCompleteHandler: isCompleteFunction,
                timeoutHandler: timeoutFunction,
                backoffRate: retry.backoffRate,
                interval: retry.interval,
                maxAttempts: retry.maxAttempts,
            });
            // the on-event entrypoint is going to start the execution of the waiter
            onEventFunction.addEnvironment(consts.WAITER_STATE_MACHINE_ARN_ENV, waiterStateMachine.stateMachineArn);
            waiterStateMachine.grantStartExecution(onEventFunction);
        }
        this.entrypoint = onEventFunction;
        this.serviceToken = this.entrypoint.functionArn;
    }
    /**
     * Called by `CustomResource` which uses this provider.
     * @deprecated use `provider.serviceToken` instead
     */
    bind(_scope) {
        jsiiDeprecationWarnings.print("monocdk.custom_resources.Provider#bind", "use `provider.serviceToken` instead");
        jsiiDeprecationWarnings.monocdk_Construct(_scope);
        return {
            serviceToken: this.entrypoint.functionArn,
        };
    }
    createFunction(entrypoint, name) {
        const fn = new lambda.Function(this, `framework-${entrypoint}`, {
            code: lambda.Code.fromAsset(RUNTIME_HANDLER_PATH),
            description: `AWS CDK resource provider framework - ${entrypoint} (${this.node.path})`.slice(0, 256),
            runtime: lambda.Runtime.NODEJS_12_X,
            handler: `framework.${entrypoint}`,
            timeout: FRAMEWORK_HANDLER_TIMEOUT,
            logRetention: this.logRetention,
            vpc: this.vpc,
            vpcSubnets: this.vpcSubnets,
            securityGroups: this.securityGroups,
            role: this.role,
            functionName: name,
        });
        fn.addEnvironment(consts.USER_ON_EVENT_FUNCTION_ARN_ENV, this.onEventHandler.functionArn);
        this.onEventHandler.grantInvoke(fn);
        if (this.isCompleteHandler) {
            fn.addEnvironment(consts.USER_IS_COMPLETE_FUNCTION_ARN_ENV, this.isCompleteHandler.functionArn);
            this.isCompleteHandler.grantInvoke(fn);
        }
        return fn;
    }
}
exports.Provider = Provider;
_a = JSII_RTTI_SYMBOL_1;
Provider[_a] = { fqn: "monocdk.custom_resources.Provider", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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