"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsCustomResource = exports.AwsCustomResourcePolicy = exports.PhysicalResourceId = exports.PhysicalResourceIdReference = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const iam = require("../../../aws-iam");
const lambda = require("../../../aws-lambda");
const cdk = require("../../../core");
const runtime_1 = require("./runtime");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_1 = require("../../../core");
/**
 * Reference to the physical resource id that can be passed to the AWS operation as a parameter.
 */
class PhysicalResourceIdReference {
    constructor() {
        this.creationStack = cdk.captureStackTrace();
    }
    /**
     * toJSON serialization to replace `PhysicalResourceIdReference` with a magic string.
     */
    toJSON() {
        return runtime_1.PHYSICAL_RESOURCE_ID_REFERENCE;
    }
    resolve(_) {
        jsiiDeprecationWarnings.monocdk_IResolveContext(_);
        return runtime_1.PHYSICAL_RESOURCE_ID_REFERENCE;
    }
    toString() {
        return runtime_1.PHYSICAL_RESOURCE_ID_REFERENCE;
    }
}
exports.PhysicalResourceIdReference = PhysicalResourceIdReference;
_a = JSII_RTTI_SYMBOL_1;
PhysicalResourceIdReference[_a] = { fqn: "monocdk.custom_resources.PhysicalResourceIdReference", version: "1.149.0" };
/**
 * Physical ID of the custom resource.
 */
class PhysicalResourceId {
    /**
     * @param responsePath Path to a response data element to be used as the physical id.
     * @param id Literal string to be used as the physical id.
     */
    constructor(responsePath, id) {
        this.responsePath = responsePath;
        this.id = id;
    }
    /**
     * Extract the physical resource id from the path (dot notation) to the data in the API call response.
     */
    static fromResponse(responsePath) {
        return new PhysicalResourceId(responsePath, undefined);
    }
    /**
     * Explicit physical resource id.
     */
    static of(id) {
        return new PhysicalResourceId(undefined, id);
    }
}
exports.PhysicalResourceId = PhysicalResourceId;
_b = JSII_RTTI_SYMBOL_1;
PhysicalResourceId[_b] = { fqn: "monocdk.custom_resources.PhysicalResourceId", version: "1.149.0" };
/**
 * The IAM Policy that will be applied to the different calls.
 */
class AwsCustomResourcePolicy {
    /**
     * @param statements statements for explicit policy.
     * @param resources resources for auto-generated from SDK calls.
     */
    constructor(statements, resources) {
        this.statements = statements;
        this.resources = resources;
    }
    /**
     * Explicit IAM Policy Statements.
     *
     * @param statements the statements to propagate to the SDK calls.
     */
    static fromStatements(statements) {
        return new AwsCustomResourcePolicy(statements, undefined);
    }
    /**
     * Generate IAM Policy Statements from the configured SDK calls.
     *
     * Each SDK call with be translated to an IAM Policy Statement in the form of: `call.service:call.action` (e.g `s3:PutObject`).
     *
     * @param options options for the policy generation
     */
    static fromSdkCalls(options) {
        jsiiDeprecationWarnings.monocdk_custom_resources_SdkCallsPolicyOptions(options);
        return new AwsCustomResourcePolicy([], options.resources);
    }
}
exports.AwsCustomResourcePolicy = AwsCustomResourcePolicy;
_c = JSII_RTTI_SYMBOL_1;
AwsCustomResourcePolicy[_c] = { fqn: "monocdk.custom_resources.AwsCustomResourcePolicy", version: "1.149.0" };
/**
 * Use this constant to configure access to any resource.
 */
AwsCustomResourcePolicy.ANY_RESOURCE = ['*'];
/**
 * Defines a custom resource that is materialized using specific AWS API calls. These calls are created using
 * a singleton Lambda function.
 *
 * Use this to bridge any gap that might exist in the CloudFormation Coverage.
 * You can specify exactly which calls are invoked for the 'CREATE', 'UPDATE' and 'DELETE' life cycle events.
 *
 */
class AwsCustomResource extends core_1.Construct {
    // 'props' cannot be optional, even though all its properties are optional.
    // this is because at least one sdk call must be provided.
    constructor(scope, id, props) {
        var _e, _f, _g;
        super(scope, id);
        jsiiDeprecationWarnings.monocdk_custom_resources_AwsCustomResourceProps(props);
        if (!props.onCreate && !props.onUpdate && !props.onDelete) {
            throw new Error('At least `onCreate`, `onUpdate` or `onDelete` must be specified.');
        }
        for (const call of [props.onCreate, props.onUpdate]) {
            if (call && !call.physicalResourceId) {
                throw new Error('`physicalResourceId` must be specified for onCreate and onUpdate calls.');
            }
        }
        for (const call of [props.onCreate, props.onUpdate, props.onDelete]) {
            if ((_e = call === null || call === void 0 ? void 0 : call.physicalResourceId) === null || _e === void 0 ? void 0 : _e.responsePath) {
                AwsCustomResource.breakIgnoreErrorsCircuit([call], 'PhysicalResourceId.fromResponse');
            }
        }
        if (includesPhysicalResourceIdRef((_f = props.onCreate) === null || _f === void 0 ? void 0 : _f.parameters)) {
            throw new Error('`PhysicalResourceIdReference` must not be specified in `onCreate` parameters.');
        }
        this.props = props;
        const provider = new lambda.SingletonFunction(this, 'Provider', {
            code: lambda.Code.fromAsset(path.join(__dirname, 'runtime')),
            runtime: lambda.Runtime.NODEJS_12_X,
            handler: 'index.handler',
            uuid: '679f53fa-c002-430c-b0da-5b7982bd2287',
            lambdaPurpose: 'AWS',
            timeout: props.timeout || cdk.Duration.minutes(2),
            role: props.role,
            logRetention: props.logRetention,
            functionName: props.functionName,
        });
        this.grantPrincipal = provider.grantPrincipal;
        // Create the policy statements for the custom resource function role, or use the user-provided ones
        const statements = [];
        if (props.policy.statements.length !== 0) {
            // Use custom statements provided by the user
            for (const statement of props.policy.statements) {
                statements.push(statement);
            }
        }
        else {
            // Derive statements from AWS SDK calls
            for (const call of [props.onCreate, props.onUpdate, props.onDelete]) {
                if (call && call.assumedRoleArn == null) {
                    const statement = new iam.PolicyStatement({
                        actions: [awsSdkToIamAction(call.service, call.action)],
                        resources: props.policy.resources,
                    });
                    statements.push(statement);
                }
                else if (call && call.assumedRoleArn != null) {
                    const statement = new iam.PolicyStatement({
                        actions: ['sts:AssumeRole'],
                        resources: [call.assumedRoleArn],
                    });
                    statements.push(statement);
                }
            }
        }
        const policy = new iam.Policy(this, 'CustomResourcePolicy', {
            statements: statements,
        });
        if (provider.role !== undefined) {
            policy.attachToRole(provider.role);
        }
        const create = props.onCreate || props.onUpdate;
        this.customResource = new cdk.CustomResource(this, 'Resource', {
            resourceType: props.resourceType || 'Custom::AWS',
            serviceToken: provider.functionArn,
            pascalCaseProperties: true,
            properties: {
                create: create && this.encodeJson(create),
                update: props.onUpdate && this.encodeJson(props.onUpdate),
                delete: props.onDelete && this.encodeJson(props.onDelete),
                installLatestAwsSdk: (_g = props.installLatestAwsSdk) !== null && _g !== void 0 ? _g : true,
            },
        });
        // If the policy was deleted first, then the function might lose permissions to delete the custom resource
        // This is here so that the policy doesn't get removed before onDelete is called
        this.customResource.node.addDependency(policy);
    }
    static breakIgnoreErrorsCircuit(sdkCalls, caller) {
        for (const call of sdkCalls) {
            if (call === null || call === void 0 ? void 0 : call.ignoreErrorCodesMatching) {
                throw new Error(`\`${caller}\`` + ' cannot be called along with `ignoreErrorCodesMatching`.');
            }
        }
    }
    /**
     * Returns response data for the AWS SDK call.
     *
     * Example for S3 / listBucket : 'Buckets.0.Name'
     *
     * Use `Token.asXxx` to encode the returned `Reference` as a specific type or
     * use the convenience `getDataString` for string attributes.
     *
     * Note that you cannot use this method if `ignoreErrorCodesMatching`
     * is configured for any of the SDK calls. This is because in such a case,
     * the response data might not exist, and will cause a CloudFormation deploy time error.
     *
     * @param dataPath the path to the data
     */
    getResponseFieldReference(dataPath) {
        AwsCustomResource.breakIgnoreErrorsCircuit([this.props.onCreate, this.props.onUpdate], 'getData');
        return this.customResource.getAtt(dataPath);
    }
    /**
     * Returns response data for the AWS SDK call as string.
     *
     * Example for S3 / listBucket : 'Buckets.0.Name'
     *
     * Note that you cannot use this method if `ignoreErrorCodesMatching`
     * is configured for any of the SDK calls. This is because in such a case,
     * the response data might not exist, and will cause a CloudFormation deploy time error.
     *
     * @param dataPath the path to the data
     */
    getResponseField(dataPath) {
        AwsCustomResource.breakIgnoreErrorsCircuit([this.props.onCreate, this.props.onUpdate], 'getDataString');
        return this.customResource.getAttString(dataPath);
    }
    encodeJson(obj) {
        return cdk.Lazy.uncachedString({ produce: () => cdk.Stack.of(this).toJsonString(obj) });
    }
}
exports.AwsCustomResource = AwsCustomResource;
_d = JSII_RTTI_SYMBOL_1;
AwsCustomResource[_d] = { fqn: "monocdk.custom_resources.AwsCustomResource", version: "1.149.0" };
/**
 * Gets awsSdkMetaData from file or from cache
 */
let getAwsSdkMetadata = (() => {
    let _awsSdkMetadata;
    return function () {
        if (_awsSdkMetadata) {
            return _awsSdkMetadata;
        }
        else {
            return _awsSdkMetadata = JSON.parse(fs.readFileSync(path.join(__dirname, 'sdk-api-metadata.json'), 'utf-8'));
        }
    };
})();
/**
 * Returns true if `obj` includes a `PhysicalResourceIdReference` in one of the
 * values.
 * @param obj Any object.
 */
function includesPhysicalResourceIdRef(obj) {
    if (obj === undefined) {
        return false;
    }
    let foundRef = false;
    // we use JSON.stringify as a way to traverse all values in the object.
    JSON.stringify(obj, (_, v) => {
        if (v === runtime_1.PHYSICAL_RESOURCE_ID_REFERENCE) {
            foundRef = true;
        }
        return v;
    });
    return foundRef;
}
/**
 * Transform SDK service/action to IAM action using metadata from aws-sdk module.
 * Example: CloudWatchLogs with putRetentionPolicy => logs:PutRetentionPolicy
 *
 * TODO: is this mapping correct for all services?
 */
function awsSdkToIamAction(service, action) {
    const srv = service.toLowerCase();
    const awsSdkMetadata = getAwsSdkMetadata();
    const iamService = (awsSdkMetadata[srv] && awsSdkMetadata[srv].prefix) || srv;
    const iamAction = action.charAt(0).toUpperCase() + action.slice(1);
    return `${iamService}:${iamAction}`;
}
//# sourceMappingURL=data:application/json;base64,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